/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver;

import de.ubs.jdbcserver.cursor.Cursor;
import de.ubs.jdbcserver.cursor.VirtualCursor;
import de.ubs.jdbcserver.evaluation.ExpressionEvaluator;
import de.ubs.jdbcserver.jdbccomm.struct.ColumnDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.TablePermission;
import de.ubs.jdbcserver.jdbccomm.struct.UserPermission;
import de.ubs.jdbcserver.jdbccomm.util.ClientSerializer;
import de.ubs.jdbcserver.jdbccomm.util.Pair;
import de.ubs.jdbcserver.jdbccommons.struct.CatalogManager;
import de.ubs.jdbcserver.jdbccommons.struct.PermissionManager;
import de.ubs.jdbcserver.jdbccommons.struct.TablespaceDefinition;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class CatalogRepository {
    public static final String SYSTABLES = "SYSTABLES";
    public static final String SYSDUMMY1 = "SYSDUMMY1";
    public static final String SYSSCHEMAS = "SYSSCHEMAS";
    public static final String SYSCOLUMNS = "SYSCOLUMNS";
    public static final String SYSTABLESPACE = "SYSTABLESPACE";
    public static final String SYSTABLESPACE_LAYOUT = "SYSTABLESPACELAYOUT";
    public static final String SYSTABAUTH = "SYSTABAUTH";
    public static final String SYSUSERAUTH = "SYSUSERAUTH";

    public static Cursor createVirtualCursor(TableDefinition tableDefinition, String tableName, ExpressionEvaluator<Boolean> ee) throws SQLException, IOException {
        boolean syscolumnsAccelerator = false;
        HashMap<String, Integer> referencedWhereColumns = null;
        VirtualCursor cursor = new VirtualCursor(tableDefinition);
        switch (tableName) {
            case "SYSTABAUTH": {
                for (Map.Entry<Pair<String, TableDefinition>, TablePermission> entry : PermissionManager.getDefault().getTablePermissions().entrySet()) {
                    cursor.addRecord(new Object[]{entry.getValue().getGrantor(), entry.getValue().getGrantee(), entry.getKey().second().getSchema(), entry.getKey().second().getName(), entry.getValue().isSelect() ? "Y" : "N", entry.getValue().isUpdate() ? "Y" : "N", entry.getValue().isInsert() ? "Y" : "N", entry.getValue().isDelete() ? "Y" : "N", entry.getValue().getGrantedTs()});
                }
                break;
            }
            case "SYSUSERAUTH": {
                for (UserPermission entry : PermissionManager.getDefault().getUserPermissions().values()) {
                    cursor.addRecord(new Object[]{entry.getGrantor(), entry.getGrantee(), entry.isDropTablespace() ? "Y" : "N", entry.isDropTable() ? "Y" : "N", entry.isCreateTablespace() ? "Y" : "N", entry.isCreateTable() ? "Y" : "N", entry.isSysadm() ? "Y" : "N", entry.getGrantedTs()});
                }
                break;
            }
            case "SYSCOLUMNS": {
                if (ee != null) {
                    referencedWhereColumns = new HashMap<String, Integer>(ee.getReferencedWhereColumns());
                    referencedWhereColumns.remove("TABLE_SCHEMA");
                    referencedWhereColumns.remove("TABLE_NAME");
                    syscolumnsAccelerator = referencedWhereColumns.isEmpty();
                }
                if (syscolumnsAccelerator) {
                    Logger.getLogger(CatalogRepository.class.getName()).log(Level.FINE, "Accelerated SYSCOLUMNS access");
                }
                for (TableDefinition table : CatalogManager.getDefault().getTables()) {
                    if (syscolumnsAccelerator) {
                        ee.setValue("TABLE_SCHEMA", (Comparable)((Object)table.getSchema().trim()));
                        ee.setValue("TABLE_NAME", (Comparable)((Object)table.getName().trim()));
                        Boolean b = ee.evaluate();
                        if (b != null && !b.booleanValue()) continue;
                        Logger.getLogger(CatalogRepository.class.getName()).log(Level.FINE, "+ Table {0}.{1}", new Object[]{table.getSchema(), table.getName()});
                    }
                    int pos = 1;
                    for (ColumnDefinition cd : table.getColumns()) {
                        int type = cd.getType();
                        boolean isDateTimeTimestamp = type == 91 || type == 92 || type == 2013 || type == 93 || type == 2014;
                        cursor.addRecord(new Object[]{table.getSchema(), table.getName(), cd.getName(), new BigDecimal(pos), new BigDecimal(type), cd.getTypeName(), cd.isNullable() ? "Y" : "N", new BigDecimal(cd.getLength()), new BigDecimal(cd.getScale()), new BigDecimal(cd.getKeySequence()), cd.getFieldPath() == null ? "" : cd.getFieldPath().toString(), isDateTimeTimestamp ? cd.getTimestampPattern() : null});
                        ++pos;
                    }
                }
                if (!syscolumnsAccelerator) break;
                Logger.getLogger(CatalogRepository.class.getName()).log(Level.FINE, "Accelerated SYSCOLUMNS access: End of matching table list");
                break;
            }
            case "SYSSCHEMAS": {
                HashSet<String> schemas = new HashSet<String>();
                for (TableDefinition table : CatalogManager.getDefault().getTables()) {
                    schemas.add(table.getSchema());
                }
                for (String schema : schemas) {
                    cursor.addRecord(new Object[]{schema});
                }
                break;
            }
            case "SYSDUMMY1": {
                cursor.addRecord(new Object[]{"Y"});
                break;
            }
            case "SYSTABLES": {
                for (TableDefinition table : CatalogManager.getDefault().getTables()) {
                    cursor.addRecord(new Object[]{table.getTablespaceName(), table.getSchema(), table.getName(), table.getCreatedTimestamp(), table.getAlteredTimestamp(), table.getCreator(), table.getWhenCondition()});
                }
                break;
            }
            case "SYSTABLESPACELAYOUT": {
                XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
                for (TablespaceDefinition tablespace : CatalogManager.getDefault().getTablespaces()) {
                    Element tables = new Element("tables");
                    for (TableDefinition table : tablespace.getTables()) {
                        tables.addContent(ClientSerializer.toXML(table));
                    }
                    ByteArrayOutputStream tsBos = new ByteArrayOutputStream();
                    ByteArrayOutputStream tbBos = new ByteArrayOutputStream();
                    outputter.output(new Document(ClientSerializer.toXML(tablespace.getLayout())), (OutputStream)tsBos);
                    outputter.output(new Document(tables), (OutputStream)tbBos);
                    cursor.addRecord(new Object[]{tablespace.getName(), tsBos.toString("UTF-8"), tbBos.toString("UTF-8")});
                }
                break;
            }
            case "SYSTABLESPACE": {
                for (TablespaceDefinition tablespace : CatalogManager.getDefault().getTablespaces()) {
                    boolean isCSV = tablespace.getTablespaceType() == TablespaceDefinition.TablespaceType.CSV;
                    Object[] objectArray = new Object[20];
                    objectArray[0] = tablespace.getName();
                    objectArray[1] = tablespace.getCreatedTimestamp();
                    objectArray[2] = tablespace.getAlteredTimestamp();
                    objectArray[3] = tablespace.getCreator();
                    objectArray[4] = tablespace.getLayout().getFileName();
                    objectArray[5] = tablespace.getLayout().getDefaultStringEncoding().name();
                    objectArray[6] = tablespace.isUseDfsortAccess() ? "Y" : "N";
                    objectArray[7] = tablespace.getMinThreshold() != -1 ? Integer.valueOf(tablespace.getMinThreshold()) : null;
                    objectArray[8] = tablespace.getDfsortOptions();
                    objectArray[9] = tablespace.getTablespaceType().toString();
                    objectArray[10] = tablespace.isReadOnly() ? "Y" : "N";
                    objectArray[11] = isCSV ? Character.toString(tablespace.getCSVColumnDelimiter()) : null;
                    objectArray[12] = isCSV ? Character.toString(tablespace.getCSVStringDelimiter()) : null;
                    objectArray[13] = isCSV ? Character.toString(tablespace.getCSVDecimalDelimiter()) : null;
                    objectArray[14] = isCSV ? Integer.valueOf(tablespace.getCSVCacheSize()) : null;
                    objectArray[15] = isCSV ? tablespace.getCSVBooleanRepresentation(true) : null;
                    objectArray[16] = isCSV ? tablespace.getCSVBooleanRepresentation(false) : null;
                    objectArray[17] = isCSV ? tablespace.getCSVQuoteMode().toString() : null;
                    Object object = objectArray[18] = tablespace.isStrictEncoding() ? "Y" : "N";
                    objectArray[19] = isCSV ? (tablespace.isCSVHeader() ? "Y" : "N") : null;
                    cursor.addRecord(objectArray);
                }
                break;
            }
            default: {
                SQLException e = new SQLException(String.format("Directory table %s is not defined", tableName), "42704", -204);
                Logger.getLogger(CatalogRepository.class.getName()).log(Level.FINE, e.getMessage(), e);
                throw e;
            }
        }
        return cursor;
    }
}

