/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.ErrnoException;
import com.ibm.jzos.Spawn;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.jzos.ZUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class DfSort {
    private static final String DFSORT_CMD = "jdfsort";
    private static final String loggingLevels = "EWNIDT";
    private List arguments = new ArrayList();
    private Spawn spawn;
    private int returnCode = -1;
    private boolean sameAddressSpace = true;
    private List stderrLines;
    private String loggingLevel = System.getProperty("jzos.logging", "N").toUpperCase();

    public void addAllocation(String allocation) {
        if (allocation == null) {
            throw new NullPointerException();
        }
        this.arguments.add("-x");
        this.arguments.add(allocation);
    }

    public void addControlStatement(String controlStatement) {
        if (controlStatement == null) {
            throw new NullPointerException();
        }
        this.arguments.add("-c");
        this.arguments.add(controlStatement);
    }

    public void setInputStreamRecLen(int reclen) {
        this.arguments.add("-i");
        this.arguments.add("" + reclen);
    }

    public void setInputStreamHasRdws() {
        this.arguments.add("-i");
        this.arguments.add("rdw");
    }

    public void disableInputStream() {
        this.arguments.add("-i");
        this.arguments.add("none");
    }

    public void setOutputStreamRecLen(int reclen) {
        this.arguments.add("-o");
        this.arguments.add("" + reclen);
    }

    public void setOutputStreamHasRdws() {
        this.arguments.add("-o");
        this.arguments.add("rdw");
    }

    public void disableOutputStream() {
        this.arguments.add("-o");
        this.arguments.add("none");
    }

    public OutputStream getChildStdinStream() {
        if (this.spawn == null) {
            throw new IllegalStateException("DFSORT child process does not exist");
        }
        return this.spawn.getChildStdinStream();
    }

    public InputStream getChildStdoutStream() {
        if (this.spawn == null) {
            throw new IllegalStateException("DFSORT child process does not exist");
        }
        return this.spawn.getChildStdoutStream();
    }

    private String getCommand() {
        String dfsortPath = System.getProperty("jzos.jdfsort.dir");
        if (dfsortPath != null) {
            if (!dfsortPath.endsWith("/")) {
                dfsortPath = dfsortPath + "/";
            }
        } else {
            dfsortPath = System.getProperty("java.home") + "/bin/";
        }
        return dfsortPath + DFSORT_CMD;
    }

    private String[] getEnvironment() {
        Properties p = ZUtil.getEnvironment();
        p.put("_BPX_SHAREAS", this.isSameAddressSpace() ? "MUST" : "NO");
        String[] environ = new String[p.size()];
        int i = 0;
        for (String string : p.keySet()) {
            environ[i++] = string + "=" + p.getProperty(string);
        }
        return environ;
    }

    private String[] getArguments() {
        this.arguments.add("-L");
        this.arguments.add(this.loggingLevel);
        String[] args = new String[this.arguments.size() + 1];
        int i = 0;
        args[i++] = DFSORT_CMD;
        Iterator iter = this.arguments.iterator();
        while (iter.hasNext()) {
            args[i++] = (String)iter.next();
        }
        return args;
    }

    public void execute() throws ErrnoException {
        boolean sysoutExists;
        this.spawn = new Spawn();
        try {
            sysoutExists = ZFile.ddExists("SYSOUT");
        }
        catch (ZFileException zfe) {
            sysoutExists = false;
        }
        if (!sysoutExists || !this.isSameAddressSpace()) {
            this.addAllocation("alloc fi(sysout) path('/dev/fd2') PATHOPTS(OWRONLY) RECFM(V,B) LRECL(500) BLKSIZE(5000) FILEDATA(TEXT) reuse msg(2)");
        }
        this.spawn.execute(this.getCommand(), this.getArguments(), this.getEnvironment());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReturnCode() {
        if (this.spawn != null) {
            try {
                this.returnCode = this.spawn.waitChild();
            }
            finally {
                this.stderrLines = this.spawn.getStderrLines();
                this.spawn = null;
            }
        }
        return this.returnCode;
    }

    public List getStderrLines() {
        return this.stderrLines;
    }

    public boolean isSameAddressSpace() {
        return this.sameAddressSpace;
    }

    public void setSameAddressSpace(boolean separateAddressSpace) {
        this.sameAddressSpace = separateAddressSpace;
    }

    public void setLoggingLevel(int logLevel) {
        this.loggingLevel = logLevel >= loggingLevels.length() ? "I" : "" + loggingLevels.charAt(logLevel);
    }
}

