/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.jdbccomm.util;

import de.ubs.jdbcserver.jdbccomm.struct.AbstractItem;
import de.ubs.jdbcserver.jdbccomm.struct.ColumnDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.Field;
import de.ubs.jdbcserver.jdbccomm.struct.Section;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.TablespaceLayout;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.time.FastDateFormat;
import org.jdom2.Element;

public class ClientSerializer {
    private static final String YES = "Y";
    private static final String NO = "N";
    private static final FastDateFormat DATE_FORMATTER = FastDateFormat.getInstance("yyyy-MM-dd-HH:mm:ss.SSS");

    public static TablespaceLayout fromXML(Element root) {
        TablespaceLayout descriptor = new TablespaceLayout();
        descriptor.setFileName(root.getAttributeValue("fileName"));
        descriptor.setDefaultStringEncoding(root.getAttributeValue("encoding", "UTF-8"));
        descriptor.setStartSection(ClientSerializer.sectionFromXML(null, root.getChild("section")));
        return descriptor;
    }

    private static Section sectionFromXML(Section parent, Element root) {
        Section section = new Section(parent, root.getAttributeValue("name"));
        section.setPosition(Integer.parseInt(root.getAttributeValue("position")));
        section.setMaximumOccurrences(Integer.parseInt(root.getAttributeValue("max-occurrences")));
        section.setOccurrencesField(root.getAttributeValue("occurs-field"));
        section.setRedefine(root.getAttributeValue("redefine", (String)null));
        ClientSerializer.addCondition(root, section);
        LinkedList<AbstractItem> items = new LinkedList<AbstractItem>();
        for (Element child : root.getChildren()) {
            if (child.getName().equals("section")) {
                items.add(ClientSerializer.sectionFromXML(section, child));
                continue;
            }
            if (!child.getName().equals("field")) continue;
            Field field = new Field(section, child.getAttributeValue("name"), child.getAttributeValue("type"), Integer.parseInt(child.getAttributeValue("storage-length")), Integer.parseInt(child.getAttributeValue("display-length")), Integer.parseInt(child.getAttributeValue("scale")));
            field.setPosition(Integer.parseInt(child.getAttributeValue("position")));
            field.setMaximumOccurrences(Integer.parseInt(child.getAttributeValue("max-occurrences")));
            field.setOccurrencesField(child.getAttributeValue("occurs-field"));
            field.setRedefine(child.getAttributeValue("redefine", (String)null));
            field.setImpliedDecimalPoint(Boolean.parseBoolean(child.getAttributeValue("decimal-implied", "false")));
            String fieldEncoding = child.getAttributeValue("encoding");
            if (fieldEncoding != null) {
                field.setEncoding(Charset.forName(fieldEncoding));
            }
            for (Element prop : child.getChildren("property")) {
                field.setProperty(prop.getAttributeValue("name"), prop.getAttributeValue("value"));
            }
            ClientSerializer.addCondition(child, field);
            items.add(field);
        }
        section.setFields(items);
        return section;
    }

    private static void addCondition(Element root, AbstractItem item) {
        Element conditionElement = root.getChild("condition");
        if (conditionElement != null) {
            item.setCondition(conditionElement.getText());
        }
    }

    public static Element toXML(TablespaceLayout rd) {
        Element element = new Element("record-descriptor");
        element.setAttribute("encoding", rd.getDefaultStringEncoding().name());
        if (rd.getFileName() != null) {
            element.setAttribute("fileName", rd.getFileName());
        }
        element.addContent(ClientSerializer.toXML(rd.getStartSection()));
        return element;
    }

    public static Element toXML(ColumnDefinition cd) {
        Element element = new Element("column-definition");
        element.setAttribute("name", cd.getName());
        element.setAttribute("type", cd.getTypeName());
        element.setAttribute("length", String.valueOf(cd.getLength()));
        element.setAttribute("scale", String.valueOf(cd.getScale()));
        element.setAttribute("nullable", cd.isNullable() ? YES : NO);
        element.setAttribute("read-only", cd.isReadOnly() ? YES : NO);
        element.setAttribute("key-seq", String.valueOf(cd.getKeySequence()));
        if (cd.getTimestampPattern() != null) {
            element.setAttribute("timestamp-pattern", cd.getTimestampPattern());
        }
        if (cd.getExistenceExpression() != null) {
            element.setAttribute("existence-expression", cd.getExistenceExpression());
        }
        if (cd.getLabel() != null) {
            element.setAttribute("label", cd.getLabel());
        }
        if (cd.getFieldPath() != null && cd.getFieldPath().getPathElements() != null) {
            for (String referencedFieldPath : cd.getFieldPath().getPathElements()) {
                element.addContent(new Element("references").setText(referencedFieldPath));
            }
        }
        return element;
    }

    public static Element toXML(TableDefinition td) {
        Element element = new Element("table-definition");
        element.setAttribute("name", td.getName());
        element.setAttribute("schema", td.getSchema());
        if (td.getWhenCondition() != null) {
            element.addContent(new Element("when").setText(td.getWhenCondition()));
        }
        if (td.getCreator() != null) {
            element.setAttribute("creator", td.getCreator());
        }
        if (null != td.getCreatedTimestamp()) {
            element.setAttribute("createdts", DATE_FORMATTER.format(td.getCreatedTimestamp()));
        }
        if (null != td.getAlteredTimestamp()) {
            element.setAttribute("alteredts", DATE_FORMATTER.format(td.getAlteredTimestamp()));
        }
        for (ColumnDefinition columnDefinition : td.getColumns()) {
            element.addContent(ClientSerializer.toXML(columnDefinition));
        }
        return element;
    }

    public static Element toXML(Section section) {
        Element element = ClientSerializer.createForAbstractItem(section, "section");
        if (section.getCondition() != null) {
            element.addContent(new Element("condition").setText(section.getCondition()));
        }
        for (AbstractItem item : section.getItems()) {
            if (item instanceof Section) {
                Section subsection = (Section)item;
                element.addContent(ClientSerializer.toXML(subsection));
                continue;
            }
            Field f = (Field)item;
            Element fieldElement = ClientSerializer.createForAbstractItem(f, "field");
            fieldElement.setAttribute("type", f.getType());
            fieldElement.setAttribute("storage-length", String.valueOf(f.getLength()));
            fieldElement.setAttribute("display-length", String.valueOf(f.getDisplayLength()));
            fieldElement.setAttribute("scale", String.valueOf(f.getScale()));
            fieldElement.setAttribute("decimal-implied", String.valueOf(f.isImpliedDecimalPoint()));
            if (f.getEncoding() != null) {
                fieldElement.setAttribute("encoding", f.getEncoding().name());
            }
            for (Map.Entry<String, String> entry : f.getAdditionalProperties().entrySet()) {
                Element prop = new Element("property");
                prop.setAttribute("name", entry.getKey());
                prop.setAttribute("value", entry.getValue());
                fieldElement.addContent(prop);
            }
            element.addContent(fieldElement);
            if (f.getCondition() == null) continue;
            fieldElement.addContent(new Element("condition").setText(f.getCondition()));
        }
        return element;
    }

    private static Element createForAbstractItem(AbstractItem ai, String elementName) {
        Element element = new Element(elementName);
        element.setAttribute("name", ai.getName());
        element.setAttribute("position", String.valueOf(ai.getPosition()));
        element.setAttribute("max-occurrences", String.valueOf(ai.getMaximumOccurrences()));
        if (ai.getOccurrenceCounterField() != null) {
            element.setAttribute("occurs-field", ai.getOccurrenceCounterField());
        }
        if (ai.getRedefine() != null) {
            element.setAttribute("redefine", ai.getRedefine());
        }
        return element;
    }

    public static TableDefinition tableDefinitionFromXML(Element e) throws ParseException {
        TableDefinition td = new TableDefinition(e.getAttributeValue("schema"), e.getAttributeValue("name"));
        Element when = e.getChild("when");
        if (when != null) {
            td.setWhenCondition(when.getText());
        }
        if (td.getSchema().equals("SYSUBS")) {
            td.setCreator(td.getSchema());
        } else {
            td.setCreatedTimestamp(new Timestamp(DATE_FORMATTER.parse(e.getAttributeValue("createdts")).getTime()));
            td.setAlteredTimestamp(new Timestamp(DATE_FORMATTER.parse(e.getAttributeValue("alteredts")).getTime()));
            td.setCreator(e.getAttributeValue("creator"));
        }
        for (Element children : e.getChildren("column-definition")) {
            td.getColumns().add(ClientSerializer.columnDefinitionFromXML(children));
        }
        return td;
    }

    private static ColumnDefinition columnDefinitionFromXML(Element e) {
        List<Element> referenceChildren = e.getChildren("references");
        int idx = 0;
        String[] references = new String[referenceChildren.size()];
        for (Element children : referenceChildren) {
            references[idx] = children.getText();
            ++idx;
        }
        ColumnDefinition cd = new ColumnDefinition(e.getAttributeValue("name"), references);
        cd.setTypeName(e.getAttributeValue("type"));
        cd.setLength(Integer.parseInt(e.getAttributeValue("length", "0")));
        cd.setScale(Integer.parseInt(e.getAttributeValue("scale", "0")));
        cd.setKeySequence(Integer.parseInt(e.getAttributeValue("key-seq", "0")));
        cd.setNullable(e.getAttributeValue("nullable", YES).equals(YES));
        cd.setReadOnly(e.getAttributeValue("read-only", NO).equals(YES));
        cd.setLabel(e.getAttributeValue("label", ""));
        cd.setExistenceExpression(e.getAttributeValue("existence-expression", (String)null));
        cd.setTimestampPattern(e.getAttributeValue("timestamp-pattern", (String)null));
        return cd;
    }
}

