/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.jdbccomm.transport;

import de.ubs.jdbcserver.jdbccomm.transport.SimpleTransportable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.NotImplementedException;

public class SerializeTransportable
extends SimpleTransportable {
    private static final byte TYPE_NULL = 0;
    private static final byte TYPE_BYTE = 1;
    private static final byte TYPE_STRING = 2;
    private static final byte TYPE_NUMBER = 3;
    private static final byte TYPE_TIMESTAMP = 4;
    private static final byte[] MARKER_BYTES = new byte[]{119, 50, 18};
    private ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();

    @Override
    public String serialize(Serializable data) throws IOException {
        if (data instanceof ArrayList) {
            ArrayList dataList = (ArrayList)data;
            DataOutputStream dataOutputStream = new DataOutputStream(this.byteArrayOutputStream);
            dataOutputStream.write(MARKER_BYTES);
            Byte[] typeMap = null;
            dataOutputStream.writeInt(dataList.size());
            boolean first = true;
            for (Object[] objectArray : dataList) {
                if (typeMap == null) {
                    typeMap = new Byte[objectArray.length];
                }
                if (first) {
                    dataOutputStream.writeShort(objectArray.length);
                    first = false;
                }
                int c = 0;
                for (Object d : objectArray) {
                    if (d == null) {
                        dataOutputStream.writeByte(0);
                    } else {
                        byte[] bytes;
                        Byte type = typeMap[c];
                        if (type == null) {
                            if (d instanceof byte[]) {
                                type = 1;
                            } else if (d instanceof String) {
                                type = 2;
                            } else if (d instanceof BigDecimal) {
                                type = 3;
                            } else if (d instanceof Timestamp) {
                                type = 4;
                            } else {
                                throw new NotImplementedException("Type " + d.getClass().getName() + " not serializable");
                            }
                            typeMap[c] = type;
                        }
                        dataOutputStream.writeByte(type.byteValue());
                        if (type == 1) {
                            bytes = (byte[])d;
                            dataOutputStream.writeShort(bytes.length);
                            dataOutputStream.write(bytes);
                        } else if (type == 2) {
                            bytes = ((String)d).getBytes(StandardCharsets.UTF_8);
                            dataOutputStream.writeShort(bytes.length);
                            dataOutputStream.write(bytes);
                        } else if (type == 3) {
                            BigDecimal bd = (BigDecimal)d;
                            dataOutputStream.writeShort(bd.scale());
                            BigInteger unscaledValue = bd.unscaledValue();
                            byte[] intBytes = unscaledValue.toByteArray();
                            dataOutputStream.writeShort(intBytes.length);
                            dataOutputStream.write(intBytes);
                        } else if (type == 4) {
                            bytes = d.toString().getBytes(StandardCharsets.UTF_8);
                            dataOutputStream.writeShort(bytes.length);
                            dataOutputStream.write(bytes);
                        } else if (type == 4) {
                            bytes = d.toString().getBytes(StandardCharsets.UTF_8);
                            dataOutputStream.writeShort(bytes.length);
                            dataOutputStream.write(bytes);
                        } else {
                            throw new NotImplementedException("Type " + d.getClass().getName() + " not serializable");
                        }
                    }
                    ++c;
                }
            }
            dataOutputStream.flush();
            String returnValue = Base64.encodeBase64String(this.byteArrayOutputStream.toByteArray());
            this.byteArrayOutputStream.reset();
            return returnValue;
        }
        return super.serialize(data);
    }

    @Override
    public Serializable deserialize(String data) throws IOException {
        byte[] bytes = Base64.decodeBase64(data);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(bytes));
        byte[] buffer = new byte[4096];
        byte b0 = dataInputStream.readByte();
        byte b1 = dataInputStream.readByte();
        byte b2 = dataInputStream.readByte();
        if (b0 == MARKER_BYTES[0] && b1 == MARKER_BYTES[1] && b2 == MARKER_BYTES[2]) {
            ArrayList<Object[]> dataList = new ArrayList<Object[]>();
            int numberOfListElements = dataInputStream.readInt();
            int numberOfColumns = -1;
            for (int row = 0; row < numberOfListElements; ++row) {
                if (numberOfColumns == -1) {
                    numberOfColumns = dataInputStream.readShort();
                }
                Object[] dataArray = new Object[numberOfColumns];
                block8: for (int c = 0; c < numberOfColumns; ++c) {
                    byte type = dataInputStream.readByte();
                    switch (type) {
                        case 0: {
                            dataArray[c] = null;
                            continue block8;
                        }
                        case 1: {
                            short length = dataInputStream.readShort();
                            byte[] typeBytes = new byte[length];
                            dataInputStream.read(typeBytes);
                            dataArray[c] = typeBytes;
                            continue block8;
                        }
                        case 2: {
                            short length = dataInputStream.readShort();
                            dataInputStream.read(buffer, 0, length);
                            String string = new String(Arrays.copyOfRange(buffer, 0, (int)length), StandardCharsets.UTF_8);
                            dataArray[c] = string;
                            continue block8;
                        }
                        case 3: {
                            short scale = dataInputStream.readShort();
                            short length = dataInputStream.readShort();
                            dataInputStream.read(buffer, 0, length);
                            BigInteger bigInteger = new BigInteger(Arrays.copyOfRange(buffer, 0, (int)length));
                            dataArray[c] = new BigDecimal(bigInteger, scale);
                            continue block8;
                        }
                        case 4: {
                            short length = dataInputStream.readShort();
                            dataInputStream.read(buffer, 0, length);
                            dataArray[c] = Timestamp.valueOf(new String(Arrays.copyOfRange(buffer, 0, (int)length), StandardCharsets.UTF_8));
                            continue block8;
                        }
                        default: {
                            throw new NotImplementedException("Unknown deserialize type: " + type + " in row: " + row + ", column: " + c);
                        }
                    }
                }
                dataList.add(dataArray);
            }
            return dataList;
        }
        return super.deserialize(data);
    }
}

