/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.jdbccomm.transport;

import de.ubs.jdbcserver.jdbccomm.Constants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;

public class OptimizedXmlSerializer {
    Map<String, Short> dictionary = new HashMap<String, Short>();
    Map<Short, String> dictionaryReverse = new HashMap<Short, String>();

    public OptimizedXmlSerializer() {
        this.buildDictionary();
    }

    private void buildDictionary() {
        Field[] declaredFields = Constants.class.getDeclaredFields();
        LinkedList<String> fieldList = new LinkedList<String>();
        for (Field f : declaredFields) {
            if (!Modifier.isFinal(f.getModifiers()) || !Modifier.isStatic(f.getModifiers()) || f.getType() != String.class) continue;
            String name = f.getName();
            try {
                String value = (String)f.get(null);
                fieldList.add(value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        Collections.sort(fieldList);
        short number = 0;
        for (String fieldName : fieldList) {
            this.dictionary.put(fieldName, number);
            this.dictionaryReverse.put(number, fieldName);
            number = (short)(number + 1);
        }
    }

    private short getDictionary(String name) {
        Short shortNumber = this.dictionary.get(name);
        if (shortNumber == null) {
            throw new RuntimeException("Value " + name + " is not listed in " + Constants.class.getName() + " as final static variable");
        }
        return shortNumber;
    }

    public byte[] serializeXml(Document doc) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        this.serializeElement(dos, doc.getRootElement());
        return baos.toByteArray();
    }

    private void serializeElement(DataOutputStream dos, Element element) throws IOException {
        dos.writeShort(this.getDictionary(element.getName()));
        this.serializeString(dos, element.getText());
        dos.writeShort(element.getAttributes().size());
        for (Attribute a : element.getAttributes()) {
            this.serializeAttribute(dos, a);
        }
        dos.writeShort(element.getChildren().size());
        for (Element c : element.getChildren()) {
            this.serializeElement(dos, c);
        }
    }

    private void serializeAttribute(DataOutputStream dos, Attribute a) throws IOException {
        dos.writeShort(this.getDictionary(a.getName()));
        this.serializeString(dos, a.getValue());
    }

    private void serializeString(DataOutputStream dos, String string) throws IOException {
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        dos.writeInt(bytes.length);
        dos.write(bytes);
    }

    public Document deserializeXml(byte[] content) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(content);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        Element element = this.deserializeElement(dataInputStream);
        Document document = new Document(element);
        return document;
    }

    private Element deserializeElement(DataInputStream dataInputStream) throws IOException {
        short elementNameShort = dataInputStream.readShort();
        Element element = new Element(this.getDictionaryName(elementNameShort));
        String text = this.deserializeString(dataInputStream);
        element.setText(text);
        short numberOfAttributes = dataInputStream.readShort();
        for (short i = 0; i < numberOfAttributes; i = (short)(i + 1)) {
            Attribute attribute = this.deserializeAttribute(dataInputStream);
            element.setAttribute(attribute);
        }
        short numberOfChildren = dataInputStream.readShort();
        for (short i = 0; i < numberOfChildren; i = (short)(i + 1)) {
            Element child = this.deserializeElement(dataInputStream);
            element.addContent(child);
        }
        return element;
    }

    private Attribute deserializeAttribute(DataInputStream dataInputStream) throws IOException {
        String name = this.getDictionaryName(dataInputStream.readShort());
        String value = this.deserializeString(dataInputStream);
        Attribute attribute = new Attribute(name, value);
        return attribute;
    }

    private String getDictionaryName(short id) throws IOException {
        String lookupString = this.dictionaryReverse.get(id);
        if (lookupString == null) {
            throw new RuntimeException("Unable to locate id " + id + "\n Dictionary content:\n\t" + this.dictionaryReverse);
        }
        return lookupString;
    }

    private String deserializeString(DataInputStream dataInputStream) throws IOException {
        int length = dataInputStream.readInt();
        byte[] bytes = new byte[length];
        dataInputStream.read(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

