/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.driver.util;

import de.ubs.jdbcserver.driver.AbstractResultSet;
import de.ubs.jdbcserver.jdbccomm.struct.ColumnDefinition;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Utilities {
    public static String getColumnClassName(int columnType) throws SQLException {
        switch (columnType) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2009: {
                return String.class.getName();
            }
            case -2: {
                return byte[].class.getName();
            }
            case -5: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return BigDecimal.class.getName();
            }
            case 91: 
            case 92: 
            case 93: {
                return Timestamp.class.getName();
            }
        }
        SQLException e = new SQLException("-060 Invalid type specification: " + columnType);
        Logger.getLogger(AbstractResultSet.class.getName()).log(Level.FINE, e.getMessage(), e);
        throw e;
    }

    public static int getColumnDisplaySize(ColumnDefinition coldef) throws SQLException {
        switch (coldef.getType()) {
            case -16: 
            case -15: 
            case -9: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                return coldef.getLength();
            }
            case -5: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return 10;
            }
            case 91: 
            case 92: 
            case 93: {
                return 26;
            }
            case 2009: {
                return 256;
            }
        }
        SQLException e = new SQLException("-060 Invalid type specification: " + coldef.getType());
        Logger.getLogger(AbstractResultSet.class.getName()).log(Level.FINE, e.getMessage(), e);
        throw e;
    }
}

