/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.driver;

import de.ubs.jdbcserver.driver.AbstractResultSet;
import de.ubs.jdbcserver.driver.util.Utilities;
import de.ubs.jdbcserver.jdbccomm.struct.ColumnDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UBSResultSetMetaData
implements ResultSetMetaData {
    private final TableDefinition tableDefinition;

    public UBSResultSetMetaData(TableDefinition tableDefinition) {
        this.tableDefinition = tableDefinition;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.tableDefinition.getColumns().size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this.getColumn(column).isNullable() ? 0 : 0;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return false;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return Utilities.getColumnDisplaySize(this.getColumn(column));
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        String label = this.getColumn(column).getLabel();
        return label != null && !label.isEmpty() ? label : this.getColumnName(column);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.getColumn(column).getName();
    }

    private ColumnDefinition getColumn(int column) {
        return this.tableDefinition.getColumns().get(column - 1);
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return this.tableDefinition.getName();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.getColumn(column).getLength();
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.getColumn(column).getScale();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.tableDefinition.getName();
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.getColumn(column).getType();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        String typeName = this.getColumn(column).getTypeName();
        if (typeName == null) {
            SQLException e = new SQLException("-060 Invalid type specification: " + this.getColumnType(column));
            Logger.getLogger(AbstractResultSet.class.getName()).log(Level.FINE, e.getMessage(), e);
            throw e;
        }
        return typeName;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return Utilities.getColumnClassName(this.getColumn(column).getType());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

