/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.driver;

import de.ubs.jdbcserver.driver.AbstractResultSet;
import de.ubs.jdbcserver.driver.AbstractStatement;
import de.ubs.jdbcserver.driver.UBSConnection;
import de.ubs.jdbcserver.driver.UBSResultSetMetaData;
import de.ubs.jdbcserver.driver.UBSStatement;
import de.ubs.jdbcserver.jdbccomm.RecordFormat;
import de.ubs.jdbcserver.jdbccomm.ResultSetAction;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom2.Document;
import org.jdom2.Element;

public class UBSResultSet
extends AbstractResultSet {
    private final UUID resultSetUUID;
    private final UBSConnection connection;
    private final AbstractStatement statement;
    private int fetchSize = -1;
    private List<Object[]> cachedRecords;
    private int currentCacheIndex = 0;
    private boolean eof = false;
    private Object[] currentRow;
    private boolean closed = false;
    private long rowsReturned = 0L;

    public UBSResultSet(UUID resultSetUUID, AbstractStatement statement, ResultSetMetaData metaData) throws SQLException {
        super(metaData);
        this.resultSetUUID = resultSetUUID;
        this.statement = statement;
        this.connection = (UBSConnection)statement.getConnection();
    }

    private void sortCacheBy(List<String> labels, UBSResultSetMetaData meta) throws SQLException {
        for (int i = 1; i <= meta.getColumnCount(); ++i) {
            for (String label : labels) {
                if (!meta.getColumnLabel(i).equals(label)) continue;
                final int index = i - 1;
                this.cachedRecords.sort(new Comparator<Object[]>(){

                    @Override
                    public int compare(Object[] o1, Object[] o2) {
                        return String.valueOf(o1[index]).compareTo(String.valueOf(o2[index]));
                    }
                });
            }
        }
    }

    public void preCacheAndSort(List<String> orderBy, UBSResultSetMetaData meta) {
        try {
            while (this.next()) {
            }
            this.sortCacheBy(orderBy, meta);
            this.rowsReturned = 0L;
            this.currentCacheIndex = 0;
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "preCacheAndSort failed: " + e.getMessage());
        }
    }

    @Override
    public boolean next() throws SQLException {
        boolean cacheConsumed;
        if (this.statement.getMaxRows() > 0 && this.rowsReturned >= (long)this.statement.getMaxRows()) {
            return false;
        }
        boolean bl = cacheConsumed = this.cachedRecords != null && this.currentCacheIndex >= this.cachedRecords.size();
        if (this.eof && cacheConsumed) {
            return false;
        }
        if (this.cachedRecords == null || cacheConsumed) {
            Element element = new Element("result-set");
            element.setAttribute("action", ResultSetAction.NEXT.name());
            element.setAttribute("uuid", this.resultSetUUID.toString());
            element.setAttribute("connection-uuid", this.connection.getConnectionUUID().toString());
            element.setAttribute("record-count", String.valueOf(this.getFetchSize()));
            element.setAttribute("record-format", RecordFormat.OBJECTS.name());
            Logger.getLogger(UBSResultSet.class.getName()).log(Level.FINEST, "element result-set:\n    {0} = {1}\n    {2} = {3}\n    {4} = {5}\n    {6} = {7}\n    {8} = {9}", new Object[]{"action", ResultSetAction.NEXT.name(), "uuid", this.resultSetUUID.toString(), "connection-uuid", this.connection.getConnectionUUID().toString(), "record-count", String.valueOf(this.getFetchSize()), "record-format", RecordFormat.OBJECTS.name()});
            try {
                Element reply = this.connection.getRemoteSession().send(new Document(element));
                this.eof = Boolean.parseBoolean(reply.getAttributeValue("eof", "false"));
                if (this.eof && reply.getText().isEmpty()) {
                    return false;
                }
                this.cachedRecords = this.connection.getTransportable().deserialize(reply.getText());
                this.currentCacheIndex = 0;
            }
            catch (SQLException ex) {
                throw ex;
            }
            catch (Exception ex) {
                SQLException e = new SQLException("Failed to fetch data: " + ex.getMessage(), ex);
                throw e;
            }
        }
        this.currentRow = this.cachedRecords.get(this.currentCacheIndex);
        ++this.currentCacheIndex;
        ++this.rowsReturned;
        return true;
    }

    @Override
    public void close() throws SQLException {
        Element element = new Element("result-set");
        element.setAttribute("action", ResultSetAction.CLOSE.name());
        element.setAttribute("uuid", this.resultSetUUID.toString());
        try {
            this.connection.getRemoteSession().send(new Document(element));
            Logger.getLogger(UBSStatement.class.getName()).log(Level.FINE, "Closed result set with ID {0}", this.resultSetUUID.toString());
            this.closed = true;
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (Exception ex) {
            SQLException e = new SQLException("Failed to close result set " + this.resultSetUUID.toString(), ex);
            throw e;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLException("Not supported yet.");
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        Object value = null;
        switch (this.getMetaData().getColumnType(columnIndex)) {
            case -2: {
                value = this.getBytes(columnIndex);
                break;
            }
            case 16: {
                value = this.getBoolean(columnIndex);
                break;
            }
            default: {
                value = this.getObjectInternal(columnIndex);
            }
        }
        return value;
    }

    @Override
    protected Object getObjectInternal(int columnIndex) throws SQLException {
        Object value = this.currentRow[columnIndex - 1];
        return this.checkForNullValue(value);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        throw new SQLException("Not supported yet.");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        throw new SQLException("Not supported yet.");
    }

    @Override
    public boolean isFirst() throws SQLException {
        throw new SQLException("Not supported yet.");
    }

    @Override
    public boolean isLast() throws SQLException {
        throw new SQLException("Not supported yet.");
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new SQLException("Not supported yet.");
    }

    @Override
    public void afterLast() throws SQLException {
        throw new SQLException("Not supported yet.");
    }

    @Override
    public boolean first() throws SQLException {
        throw new SQLException("Not supported yet.");
    }

    @Override
    public boolean last() throws SQLException {
        throw new SQLException("Not supported yet.");
    }

    @Override
    public int getRow() throws SQLException {
        throw new SQLException("Not supported yet.");
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw new SQLException("Not supported yet.");
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw new SQLException("Not supported yet.");
    }

    @Override
    public boolean previous() throws SQLException {
        throw new SQLException("Not supported yet.");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new SQLException("Not supported yet.");
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize != -1 ? this.fetchSize : this.statement.getFetchSize();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.fetchSize = rows;
    }

    @Override
    public int getType() throws SQLException {
        throw new SQLException("Not supported yet.");
    }

    @Override
    public int getConcurrency() throws SQLException {
        throw new SQLException("Not supported yet.");
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new SQLException("Not supported yet.");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new SQLException("Not supported yet.");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new SQLException("Not supported yet.");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLException("Not supported yet.");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLException("Not supported yet.");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLException("Not supported yet.");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLException("Not supported yet.");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLException("Not supported yet.");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLException("Not supported yet.");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new SQLException("Not supported yet.");
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("Not supported yet.");
    }
}

