/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.driver;

import de.ubs.jdbcserver.driver.util.Utilities;
import de.ubs.jdbcserver.jdbccomm.struct.ColumnDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import java.sql.ParameterMetaData;
import java.sql.SQLException;

public class UBSParameterMetaData
implements ParameterMetaData {
    private final TableDefinition tableDefinition;

    public UBSParameterMetaData(TableDefinition tableDefinition) {
        this.tableDefinition = tableDefinition;
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.tableDefinition.getColumns().size();
    }

    private ColumnDefinition getColumn(int param) {
        return this.tableDefinition.getColumns().get(param - 1);
    }

    @Override
    public int isNullable(int param) throws SQLException {
        return this.getColumn(param).isNullable() ? 1 : 0;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        return false;
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        return this.getColumn(param).getLength();
    }

    @Override
    public int getScale(int param) throws SQLException {
        return this.getColumn(param).getScale();
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        return this.getColumn(param).getType();
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        return this.getColumn(param).getTypeName();
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        return Utilities.getColumnClassName(this.getColumn(param).getType());
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        return 1;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

