/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.driver;

import de.ubs.jdbcserver.driver.MemoryResultSet;
import de.ubs.jdbcserver.driver.MemoryResultSetMetaData;
import de.ubs.jdbcserver.driver.UBSConnection;
import de.ubs.jdbcserver.driver.UBSDriver;
import de.ubs.jdbcserver.driver.UBSStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class UBSDatabaseMetaData
implements DatabaseMetaData {
    private static final int MAX_VSAM_LRECL = 32760;
    private static final int MAX_NAME_LENGTH = 128;
    private static final int MAX_STATEMENt_LENGTH = 32768;
    private static final int MAX_USERNAME_LENGTH = 8;
    private UBSConnection connection;

    public UBSDatabaseMetaData(UBSConnection connection) {
        this.connection = connection;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return false;
    }

    @Override
    public String getURL() throws SQLException {
        return this.connection.getUrl();
    }

    @Override
    public String getUserName() throws SQLException {
        return this.connection.getUser();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return this.connection.getDatabaseProductName();
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return this.getDatabaseMajorVersion() + "." + this.getDatabaseMinorVersion();
    }

    @Override
    public String getDriverName() throws SQLException {
        return "UBS File Bridge Driver";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return this.getDriverMajorVersion() + "." + this.getDriverMinorVersion();
    }

    @Override
    public int getDriverMajorVersion() {
        return 1;
    }

    @Override
    public int getDriverMinorVersion() {
        return UBSDriver.getDriverBuildDate();
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return true;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return "CREATETS,CREATETB,DROPTS,DROPTB,USES,USE,PUBLIC,REPLACING,ENCODING,FILE,DESCRIPTION,PL1,PL/1,PLI,PL/I,COBOL,TABLESPACE,ASC,DESC,NAME,PRIVILEGES,IF,SYSADM,DATA,TYPE,ACCESS,DFSORT,DEACTIVATE,THRESHOLD,PATTERN,COLDEL,CHARDEL,DECPT,BOOLVALUES,HEADER,YES,LINEENDINGS,WINDOWS,UNIX,FORMAT,CSV,QUOTE,STRINGS,MINIMAL,READONLY,CACHESIZE,MB,KB,STRICT,FIRST";
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "MIN,MAX,BITNOT,BITAND,BITOR,BITXOR";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "STRIP,LOWER,UPPER,CONCAT,LENGTH,HEX,SUBSTR,TO_CHAR,GETVARIABLE";
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "TO_DATE,TO_TIME,TO_TIMESTAMP";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return false;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "schema";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "procedure";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "catalog";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 32760;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 32760;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 128;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 128;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 128;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 128;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 128;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 128;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 32760;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return true;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 32768;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 128;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 1;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 8;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return 0 == level;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return new MemoryResultSet(new MemoryResultSetMetaData.ColumnInfo[]{new MemoryResultSetMetaData.ColumnInfo("PROCEDURE_CAT", 12), new MemoryResultSetMetaData.ColumnInfo("PROCEDURE_SCHEM", 12), new MemoryResultSetMetaData.ColumnInfo("PROCEDURE_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("reserved1", 12), new MemoryResultSetMetaData.ColumnInfo("reserved2", 12), new MemoryResultSetMetaData.ColumnInfo("reserved3", 12), new MemoryResultSetMetaData.ColumnInfo("REMARKS", 12), new MemoryResultSetMetaData.ColumnInfo("PROCEDURE_TYPE", 12), new MemoryResultSetMetaData.ColumnInfo("SPECIFIC_NAME", 12)});
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        ArrayList<String> labels = new ArrayList<String>();
        labels.add("TABLE_NAME");
        return ((UBSStatement)this.createStatement()).executeQueryOrdered(String.format("SELECT   ''       AS TABLE_CAT , SCHEMA   AS TABLE_SCHEM , \"NAME\" AS TABLE_NAME , CASE SCHEMA WHEN 'SYSUBS' THEN 'SYSTEM TABLE' ELSE 'TABLE' END AS TABLE_TYPE , ''       AS REMARKS , NULL     AS TYPE_CAT , NULL     AS TYPE_SCHEM , NULL     AS TYPE_NAME , NULL     AS SELF_REFERENCING_COL_NAME , NULL     AS REF_GENERATION FROM SYSUBS.SYSTABLES WHERE SCHEMA LIKE '%s' AND \"NAME\" LIKE '%s'", schemaPattern == null ? "%" : schemaPattern, tableNamePattern == null ? "%" : tableNamePattern), labels);
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, "%");
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        return new MemoryResultSet(new MemoryResultSetMetaData.ColumnInfo[]{new MemoryResultSetMetaData.ColumnInfo("TABLE_CAT ", 12)});
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        return this.createStatement().executeQuery("SELECT 'TABLE' AS TABLE_TYPE FROM SYSUBS.SYSDUMMY1");
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        StringBuilder query = new StringBuilder("SELECT   ''             AS TABLE_CAT        , TABLE_SCHEMA   AS TABLE_SCHEM      , TABLE_NAME     AS TABLE_NAME       , \"NAME\"       AS COLUMN_NAME      , DATA_TYPE      AS DATA_TYPE        , TYPE_NAME      AS TYPE_NAME        , \"LENGTH\"     AS COLUMN_SIZE      , 0              AS BUFFER_LENGTH    , SCALE          AS DECIMAL_DIGITS   , 10             AS NUM_PREC_RADIX   , CASE NULLABLE      WHEN 'Y' THEN 1     ELSE          0  END            AS NULLABLE         , ''             AS REMARKS          , ''             AS COLUMN_DEF       , 0              AS SQL_DATA_TYPE    , 0              AS SQL_DATETIME_SUB , 0              AS CHAR_OCTET_LENGTH , POSITION       AS ORDINAL_POSITION , CASE NULLABLE      WHEN 'Y' THEN 'YES'      ELSE          'NO'    END            AS IS_NULLABLE , NULL           AS SCOPE_CATALOG , NULL           AS SCOPE_SCHEMA , NULL           AS SCOPE_TABLE , 0              AS SOURCE_DATA_TYPE , 'NO'           AS IS_AUTOINCREMENT , 'NO'           AS IS_GENERATEDCOLUMN FROM SYSUBS.SYSCOLUMNS");
        boolean first = true;
        if (schemaPattern != null && !schemaPattern.equals("%")) {
            query.append(first ? " WHERE " : " AND ");
            query.append("TABLE_SCHEMA LIKE '").append(schemaPattern).append("'");
            first = false;
        }
        if (tableNamePattern != null && !tableNamePattern.equals("%")) {
            query.append(first ? " WHERE " : " AND ");
            query.append("TABLE_NAME LIKE '").append(tableNamePattern).append("'");
            first = false;
        }
        if (columnNamePattern != null && !columnNamePattern.equals("%")) {
            query.append(first ? " WHERE " : " AND ");
            query.append("\"NAME\" LIKE '").append(columnNamePattern).append("'");
            first = false;
        }
        return this.createStatement().executeQuery(query.toString());
    }

    private Statement createStatement() throws SQLException {
        Statement stmt = this.connection.createStatement();
        stmt.setFetchSize(100);
        return stmt;
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        return new MemoryResultSet(new MemoryResultSetMetaData.ColumnInfo[]{new MemoryResultSetMetaData.ColumnInfo("TABLE_CAT", 12), new MemoryResultSetMetaData.ColumnInfo("TABLE_SCHEM", 12), new MemoryResultSetMetaData.ColumnInfo("TABLE_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("COLUMN_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("GRANTOR", 12), new MemoryResultSetMetaData.ColumnInfo("GRANTEE", 12), new MemoryResultSetMetaData.ColumnInfo("PRIVILEGE", 12), new MemoryResultSetMetaData.ColumnInfo("IS_GRANTABLE", 12)});
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return this.createStatement().executeQuery(String.format("SELECT   ''       AS TABLE_CAT , \"TABLE_SCHEMA\"   AS TABLE_SCHEM , \"TABLE_NAME\"     AS TABLE_NAME , \"GRANTOR\"        AS GRANTOR , \"GRANTEE\"        AS GRANTEE , 'SELECT'           AS PRIVILEGE , \"NO\"             AS IS_GRANTABLE FROM SYSUBS.SYSTABAUTH WHERE \"TABLE_SCHEMA\" LIKE '%s' AND \"TABLE_NAME\" LIKE '%s' AND SELECT_AUTH = 'Y'", schemaPattern == null ? "%" : schemaPattern, tableNamePattern == null ? "%" : tableNamePattern));
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        return new MemoryResultSet(new MemoryResultSetMetaData.ColumnInfo[]{new MemoryResultSetMetaData.ColumnInfo("SCOPE", 5), new MemoryResultSetMetaData.ColumnInfo("COLUMN_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("DATA_TYPE", 4), new MemoryResultSetMetaData.ColumnInfo("TYPE_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("COLUMN_SIZE", 4), new MemoryResultSetMetaData.ColumnInfo("BUFFER_LENGTH", 4), new MemoryResultSetMetaData.ColumnInfo("DECIMAL_DIGITS", 5), new MemoryResultSetMetaData.ColumnInfo("PSEUDO_COLUMN", 5)});
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        return new MemoryResultSet(new MemoryResultSetMetaData.ColumnInfo[]{new MemoryResultSetMetaData.ColumnInfo("SCOPE", 5), new MemoryResultSetMetaData.ColumnInfo("COLUMN_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("DATA_TYPE", 4), new MemoryResultSetMetaData.ColumnInfo("TYPE_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("COLUMN_SIZE", 4), new MemoryResultSetMetaData.ColumnInfo("BUFFER_LENGTH", 4), new MemoryResultSetMetaData.ColumnInfo("DECIMAL_DIGITS", 5), new MemoryResultSetMetaData.ColumnInfo("PSEUDO_COLUMN", 5)});
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schemaPattern, String tablePattern) throws SQLException {
        return this.createStatement().executeQuery(String.format("SELECT   ''                 AS TABLE_CAT , \"TABLE_SCHEMA\"   AS TABLE_SCHEM , \"TABLE_NAME\"     AS TABLE_NAME , \"NAME\"           AS COLUMN_NAME , KEY_SEQ            AS KEY_SEQ , NULL               AS PK_NAME FROM SYSUBS.SYSCOLUMNS WHERE \"TABLE_SCHEMA\" LIKE '%s' AND \"TABLE_NAME\" LIKE '%s' AND KEY_SEQ > 0", schemaPattern == null ? "%" : schemaPattern, tablePattern == null ? "%" : tablePattern));
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schemaName, String tableName) throws SQLException {
        MemoryResultSet rs = this.prepareForeignKeyResultSet();
        return rs;
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schemaName, String tableName) throws SQLException {
        MemoryResultSet rs = this.prepareForeignKeyResultSet();
        return rs;
    }

    private MemoryResultSet prepareForeignKeyResultSet() {
        MemoryResultSet rs = new MemoryResultSet(new MemoryResultSetMetaData.ColumnInfo[]{new MemoryResultSetMetaData.ColumnInfo("PKTABLE_CAT", 12), new MemoryResultSetMetaData.ColumnInfo("PKTABLE_SCHEM", 12), new MemoryResultSetMetaData.ColumnInfo("PKTABLE_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("PKCOLUMN_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("FKTABLE_CAT", 12), new MemoryResultSetMetaData.ColumnInfo("FKTABLE_SCHEM", 12), new MemoryResultSetMetaData.ColumnInfo("FKTABLE_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("FKCOLUMN_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("KEY_SEQ", 5), new MemoryResultSetMetaData.ColumnInfo("UPDATE_RULE", 5), new MemoryResultSetMetaData.ColumnInfo("DELETE_RULE", 5), new MemoryResultSetMetaData.ColumnInfo("FK_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("PK_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("DEFERRABILITY", 5)});
        return rs;
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return new MemoryResultSet(new MemoryResultSetMetaData.ColumnInfo[]{new MemoryResultSetMetaData.ColumnInfo("PKTABLE_CAT", 12), new MemoryResultSetMetaData.ColumnInfo("PKTABLE_SCHEM", 12), new MemoryResultSetMetaData.ColumnInfo("PKTABLE_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("PKCOLUMN_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("FKTABLE_CAT", 12), new MemoryResultSetMetaData.ColumnInfo("FKTABLE_SCHEM", 12), new MemoryResultSetMetaData.ColumnInfo("FKTABLE_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("FKCOLUMN_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("KEY_SEQ", 5), new MemoryResultSetMetaData.ColumnInfo("UPDATE_RULE", 5), new MemoryResultSetMetaData.ColumnInfo("DELETE_RULE", 5), new MemoryResultSetMetaData.ColumnInfo("FK_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("PK_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("DEFERRABILITY", 5)});
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        return new MemoryResultSet(new MemoryResultSetMetaData.ColumnInfo[]{new MemoryResultSetMetaData.ColumnInfo("TYPE_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("DATA_TYPE", 4), new MemoryResultSetMetaData.ColumnInfo("PRECISION", 4), new MemoryResultSetMetaData.ColumnInfo("LITERAL_PREFIX", 12), new MemoryResultSetMetaData.ColumnInfo("LITERAL_SUFFIX", 12), new MemoryResultSetMetaData.ColumnInfo("CREATE_PARAMS", 12), new MemoryResultSetMetaData.ColumnInfo("NULLABLE", 5), new MemoryResultSetMetaData.ColumnInfo("CASE_SENSITIVE", 16), new MemoryResultSetMetaData.ColumnInfo("SEARCHABLE", 5), new MemoryResultSetMetaData.ColumnInfo("UNSIGNED_ATTRIBUTE", 16), new MemoryResultSetMetaData.ColumnInfo("FIXED_PREC_SCALE", 16), new MemoryResultSetMetaData.ColumnInfo("AUTO_INCREMENT", 16), new MemoryResultSetMetaData.ColumnInfo("LOCAL_TYPE_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("MINIMUM_SCALE", 5), new MemoryResultSetMetaData.ColumnInfo("MAXIMUM_SCALE", 5), new MemoryResultSetMetaData.ColumnInfo("SQL_DATA_TYPE", 4), new MemoryResultSetMetaData.ColumnInfo("SQL_DATETIME_SUB", 4), new MemoryResultSetMetaData.ColumnInfo("NUM_PREC_RADIX", 4)});
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schemaName, String tableName, boolean unique, boolean approximate) throws SQLException {
        MemoryResultSet rs = new MemoryResultSet(new MemoryResultSetMetaData.ColumnInfo[]{new MemoryResultSetMetaData.ColumnInfo("TABLE_CAT", 12), new MemoryResultSetMetaData.ColumnInfo("TABLE_SCHEM", 12), new MemoryResultSetMetaData.ColumnInfo("TABLE_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("NON_UNIQUE", 16), new MemoryResultSetMetaData.ColumnInfo("INDEX_QUALIFIER", 12), new MemoryResultSetMetaData.ColumnInfo("INDEX_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("TYPE", 5), new MemoryResultSetMetaData.ColumnInfo("ORDINAL_POSITION", 5), new MemoryResultSetMetaData.ColumnInfo("COLUMN_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("ASC_OR_DESC", 12), new MemoryResultSetMetaData.ColumnInfo("CARDINALITY", 4), new MemoryResultSetMetaData.ColumnInfo("PAGES", 4), new MemoryResultSetMetaData.ColumnInfo("FILTER_CONDITION", 12)});
        return rs;
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return 1003 == type;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return new MemoryResultSet(new MemoryResultSetMetaData.ColumnInfo[]{new MemoryResultSetMetaData.ColumnInfo("TYPE_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("DATA_TYPE", 4), new MemoryResultSetMetaData.ColumnInfo("PRECISION", 4), new MemoryResultSetMetaData.ColumnInfo("LITERAL_PREFIX", 12), new MemoryResultSetMetaData.ColumnInfo("LITERAL_SUFFIX", 12), new MemoryResultSetMetaData.ColumnInfo("CREATE_PARAMS", 12), new MemoryResultSetMetaData.ColumnInfo("NULLABLE", 5), new MemoryResultSetMetaData.ColumnInfo("CASE_SENSITIVE", 16), new MemoryResultSetMetaData.ColumnInfo("SEARCHABLE", 5), new MemoryResultSetMetaData.ColumnInfo("UNSIGNED_ATTRIBUTE", 16), new MemoryResultSetMetaData.ColumnInfo("FIXED_PREC_SCALE", 16), new MemoryResultSetMetaData.ColumnInfo("AUTO_INCREMENT", 16), new MemoryResultSetMetaData.ColumnInfo("LOCAL_TYPE_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("MINIMUM_SCALE", 5), new MemoryResultSetMetaData.ColumnInfo("MAXIMUM_SCALE", 5), new MemoryResultSetMetaData.ColumnInfo("SQL_DATA_TYPE", 4), new MemoryResultSetMetaData.ColumnInfo("SQL_DATETIME_SUB", 4), new MemoryResultSetMetaData.ColumnInfo("NUM_PREC_RADIX", 4)});
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return new MemoryResultSet(new MemoryResultSetMetaData.ColumnInfo[]{new MemoryResultSetMetaData.ColumnInfo("TYPE_CAT", 12), new MemoryResultSetMetaData.ColumnInfo("TYPE_SCHEM", 12), new MemoryResultSetMetaData.ColumnInfo("TYPE_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("SUPERTYPE_CAT", 12), new MemoryResultSetMetaData.ColumnInfo("SUPERTYPE_NAME", 12)});
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return new MemoryResultSet(new MemoryResultSetMetaData.ColumnInfo[]{new MemoryResultSetMetaData.ColumnInfo("TABLE_CAT", 12), new MemoryResultSetMetaData.ColumnInfo("TABLE_SCHEM", 12), new MemoryResultSetMetaData.ColumnInfo("TABLE_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("SUPERTABLE_NAME", 12)});
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return new MemoryResultSet(new MemoryResultSetMetaData.ColumnInfo[]{new MemoryResultSetMetaData.ColumnInfo("TYPE_CAT", 12), new MemoryResultSetMetaData.ColumnInfo("TYPE_SCHEM", 12), new MemoryResultSetMetaData.ColumnInfo("TYPE_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("ATTR_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("DATA_TYPE", 4), new MemoryResultSetMetaData.ColumnInfo("ATTR_TYPE_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("ATTR_SIZE", 4), new MemoryResultSetMetaData.ColumnInfo("DECIMAL_DIGITS", 4), new MemoryResultSetMetaData.ColumnInfo("NUM_PREC_RADIX", 4), new MemoryResultSetMetaData.ColumnInfo("NULLABLE", 4), new MemoryResultSetMetaData.ColumnInfo("REMARKS", 12), new MemoryResultSetMetaData.ColumnInfo("ATTR_DEF", 12), new MemoryResultSetMetaData.ColumnInfo("SQL_DATA_TYPE", 4), new MemoryResultSetMetaData.ColumnInfo("SQL_DATETIME_SUB", 4), new MemoryResultSetMetaData.ColumnInfo("CHAR_OCTET_LENGTH", 4), new MemoryResultSetMetaData.ColumnInfo("ORDINAL_POSITION", 4), new MemoryResultSetMetaData.ColumnInfo("IS_NULLABLE", 12), new MemoryResultSetMetaData.ColumnInfo("SCOPE_CATALOG", 12), new MemoryResultSetMetaData.ColumnInfo("SCOPE_SCHEMA", 12), new MemoryResultSetMetaData.ColumnInfo("SCOPE_TABLE", 12), new MemoryResultSetMetaData.ColumnInfo("SOURCE_DATA_TYPE", 5)});
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return holdability == 2;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return 1;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        try {
            return Integer.parseInt(this.connection.getDatabaseProductVersion());
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 1;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        return this.createStatement().executeQuery(String.format("SELECT \"NAME\" AS TABLE_SCHEM, NULL     AS TABLE_CATALOG FROM SYSUBS.SYSSCHEMAS WHERE \"NAME\" LIKE '%s'", schemaPattern != null ? schemaPattern : "%"));
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return new MemoryResultSet(new MemoryResultSetMetaData.ColumnInfo[]{new MemoryResultSetMetaData.ColumnInfo("NAME", 12), new MemoryResultSetMetaData.ColumnInfo("MAX_LEN", 4), new MemoryResultSetMetaData.ColumnInfo("DEFAULT_VALUE", 12), new MemoryResultSetMetaData.ColumnInfo("DESCRIPTION", 12)});
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return new MemoryResultSet(new MemoryResultSetMetaData.ColumnInfo[]{new MemoryResultSetMetaData.ColumnInfo("FUNCTION_CAT", 12), new MemoryResultSetMetaData.ColumnInfo("FUNCTION_SCHEM", 12), new MemoryResultSetMetaData.ColumnInfo("FUNCTION_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("REMARKS", 12), new MemoryResultSetMetaData.ColumnInfo("FUNCTION_TYPE", 5), new MemoryResultSetMetaData.ColumnInfo("SPECIFIC_NAME", 12)});
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        return new MemoryResultSet(new MemoryResultSetMetaData.ColumnInfo[]{new MemoryResultSetMetaData.ColumnInfo("FUNCTION_CAT", 12), new MemoryResultSetMetaData.ColumnInfo("FUNCTION_SCHEM", 12), new MemoryResultSetMetaData.ColumnInfo("FUNCTION_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("COLUMN_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("COLUMN_TYPE", 5), new MemoryResultSetMetaData.ColumnInfo("DATA_TYPE", 4), new MemoryResultSetMetaData.ColumnInfo("TYPE_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("PRECISION", 4), new MemoryResultSetMetaData.ColumnInfo("LENGTH", 4), new MemoryResultSetMetaData.ColumnInfo("SCALE", 5), new MemoryResultSetMetaData.ColumnInfo("RADIX", 5), new MemoryResultSetMetaData.ColumnInfo("NULLABLE", 5), new MemoryResultSetMetaData.ColumnInfo("REMARKS", 12), new MemoryResultSetMetaData.ColumnInfo("CHAR_OCTET_LENGTH", 4), new MemoryResultSetMetaData.ColumnInfo("ORDINAL_POSITION", 4), new MemoryResultSetMetaData.ColumnInfo("IS_NULLABLE", 12), new MemoryResultSetMetaData.ColumnInfo("SPECIFIC_NAME", 12)});
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return new MemoryResultSet(new MemoryResultSetMetaData.ColumnInfo[]{new MemoryResultSetMetaData.ColumnInfo("TABLE_CAT", 12), new MemoryResultSetMetaData.ColumnInfo("TABLE_SCHEM", 12), new MemoryResultSetMetaData.ColumnInfo("TABLE_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("COLUMN_NAME", 12), new MemoryResultSetMetaData.ColumnInfo("DATA_TYPE", 4), new MemoryResultSetMetaData.ColumnInfo("COLUMN_SIZE", 4), new MemoryResultSetMetaData.ColumnInfo("DECIMAL_DIGITS", 4), new MemoryResultSetMetaData.ColumnInfo("NUM_PREC_RADIX", 4), new MemoryResultSetMetaData.ColumnInfo("COLUMN_USAGE", 12), new MemoryResultSetMetaData.ColumnInfo("REMARKS", 12), new MemoryResultSetMetaData.ColumnInfo("CHAR_OCTET_LENGTH", 4), new MemoryResultSetMetaData.ColumnInfo("IS_NULLABLE", 12)});
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

