/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.driver;

import de.ubs.jdbcserver.driver.UBSDatabaseMetaData;
import de.ubs.jdbcserver.driver.UBSPreparedStatement;
import de.ubs.jdbcserver.driver.UBSStatement;
import de.ubs.jdbcserver.jdbccomm.ConnectionAction;
import de.ubs.jdbcserver.jdbccomm.RemoteSession;
import de.ubs.jdbcserver.jdbccomm.transport.Transportable;
import de.ubs.jdbcserver.jdbccomm.transport.TransportableFactory;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom2.Document;
import org.jdom2.Element;

public class UBSConnection
implements Connection {
    public static final String PROP_HOST = "host";
    public static final String PROP_PORT = "port";
    public static final String PROP_USER = "user";
    public static final String PROP_PASSWORD = "password";
    public static final String PROP_TEST = "test";
    public static final String PROP_MODE = "mode";
    public static final String PROP_FILE = "file";
    public static final String PROP_ENCRYPTED = "encrypted";
    private final String url;
    private final Map<String, String> properties;
    private boolean autoCommit = false;
    private boolean readOnly = false;
    private RemoteSession remoteSession;
    private UUID connectionUUID;
    private Transportable<ArrayList> transportable;
    private String databaseProductName = null;
    private String databaseProductVersion = null;
    private Map<String, Class<?>> typeMap = new HashMap();
    private Properties clientInfo = new Properties();
    private int networkTimeout = 0;

    public UBSConnection(String url, Map<String, String> properties) throws SQLException {
        this.properties = properties;
        String user = properties.get(PROP_USER);
        String password = properties.get(PROP_PASSWORD);
        String host = properties.get(PROP_HOST);
        int port = Integer.parseInt(properties.get(PROP_PORT));
        boolean encrypted = Boolean.parseBoolean(properties.getOrDefault(PROP_ENCRYPTED, "false"));
        this.url = url;
        if (!properties.containsKey(PROP_TEST)) {
            try {
                this.remoteSession = RemoteSession.connect(host, port, user, password, encrypted);
                this.databaseProductName = this.remoteSession.getDatabaseProductName();
                this.databaseProductVersion = this.remoteSession.getDatabaseProductVersion();
                TransportableFactory.TransportType transportType = TransportableFactory.TransportType.COMPRESS;
                if (properties.containsKey("transport")) {
                    String transport = properties.get("transport");
                    try {
                        transportType = TransportableFactory.TransportType.valueOf(transport);
                    }
                    catch (RuntimeException e) {
                        throw new RuntimeException("Unknown value for URL property transport: " + transport + ".\nAvailable values are: " + Arrays.toString((Object[])TransportableFactory.TransportType.values()));
                    }
                }
                this.transportable = TransportableFactory.createTransportable(transportType, ArrayList.class);
                Element element = new Element("connection");
                element.setAttribute("action", ConnectionAction.OPEN.name());
                element.setAttribute("transportable", transportType.name());
                Element reply = this.remoteSession.send(element);
                this.connectionUUID = UUID.fromString(reply.getAttributeValue("uuid"));
                Logger.getLogger(UBSConnection.class.getName()).log(Level.FINE, "Remote connection to {0}:{1} established", new Object[]{host, port});
            }
            catch (SQLException ex) {
                throw ex;
            }
            catch (Exception ex) {
                SQLException e = new SQLException("Failed to connect to remote host " + host + ":" + port, ex);
                throw e;
            }
        }
    }

    public RemoteSession getRemoteSession() {
        if (this.remoteSession == null) {
            throw new RuntimeException("Connection already closed");
        }
        return this.remoteSession;
    }

    public UUID getConnectionUUID() {
        return this.connectionUUID;
    }

    public Transportable<ArrayList> getTransportable() {
        return this.transportable;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.properties.get(PROP_USER);
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1008, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1008, 1);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.autoCommit = autoCommit;
    }

    @Override
    public void commit() throws SQLException {
    }

    @Override
    public void rollback() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
        try {
            if (this.connectionUUID != null) {
                Element element = new Element("connection");
                element.setAttribute("action", ConnectionAction.CLOSE.name());
                element.setAttribute("uuid", this.connectionUUID.toString());
                this.remoteSession.send(new Document(element));
            }
            this.remoteSession.close();
            this.remoteSession = null;
            Logger.getLogger(UBSConnection.class.getName()).log(Level.FINE, "Remote connection closed");
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (Exception ex) {
            SQLException e = new SQLException("Failed to close connection", ex);
            throw e;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.remoteSession == null;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new UBSDatabaseMetaData(this);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.readOnly = readOnly;
    }

    @Override
    public String getCatalog() throws SQLException {
        return null;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(1003, 1008, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, 1);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.typeMap;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.typeMap = map;
    }

    @Override
    public int getHoldability() throws SQLException {
        return 2;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new SQLFeatureNotSupportedException("setHoldability() is not supported yet");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException("setSavepoint() is not supported yet.");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("setSavepoint() is not supported yet.");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("releaseSavepoint() is not supported yet.");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new UBSStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new UBSPreparedStatement(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Boolean> future = executor.submit(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                ResultSet rs = null;
                Statement stmt = null;
                try {
                    stmt = UBSConnection.this.createStatement();
                    rs = stmt.executeQuery("select * from sysubs.sysdummy1");
                    while (rs.next()) {
                    }
                    Boolean bl = true;
                    return bl;
                }
                catch (SQLException ex) {
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    stmt.close();
                }
            }
        });
        try {
            return future.get(timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            return false;
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.clientInfo.put(name, value);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.clientInfo.getProperty(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.clientInfo;
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.clientInfo = properties;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    UBSConnection.this.close();
                }
                catch (SQLException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.networkTimeout = milliseconds;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.networkTimeout;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    public String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }
}

