/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.driver;

import de.ubs.jdbcserver.driver.AbstractResultSet;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MemoryResultSetMetaData
implements ResultSetMetaData {
    private final List<ColumnInfo> columnList = new LinkedList<ColumnInfo>();

    public MemoryResultSetMetaData() {
    }

    public MemoryResultSetMetaData(ColumnInfo[] cols) {
        this.setColumns(cols);
    }

    public void addColumn(ColumnInfo column) {
        this.columnList.add(column);
    }

    public final void setColumns(ColumnInfo[] cols) {
        for (ColumnInfo col : cols) {
            this.addColumn(col);
        }
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnList.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this.getColumnInfo(column).isNullable() ? 1 : 0;
    }

    private ColumnInfo getColumnInfo(int column) {
        return this.columnList.get(column - 1);
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return false;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return 20;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnInfo(column).getName();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.getColumnInfo(column).getName();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.getColumnInfo(column).getLength();
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.getColumnInfo(column).getScale();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return "";
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.getColumnInfo(column).getType();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        int type = this.getColumnType(column);
        switch (type) {
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
            case 1: {
                return "CHAR";
            }
            case 4: {
                return "INTEGER";
            }
            case 5: {
                return "SMALLINT";
            }
            case -5: {
                return "BIGINT";
            }
            case 3: {
                return "DECIMAL";
            }
        }
        return String.format("Unknown SQL type: %d", type);
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return true;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        int type = this.getColumnType(column);
        switch (type) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return BigDecimal.class.getName();
            }
            case 91: 
            case 92: 
            case 93: {
                return Timestamp.class.getName();
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return String.class.getName();
            }
        }
        SQLException e = new SQLException("Unknown data type " + type);
        Logger.getLogger(AbstractResultSet.class.getName()).log(Level.FINE, e.getMessage(), e);
        throw e;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    public static class ColumnInfo {
        private final String name;
        private final int type;
        private final int scale = 0;
        private final int length = 0;
        private final boolean nullable;

        public ColumnInfo(String name, int type) {
            this(name, type, true);
        }

        public ColumnInfo(String name, int type, boolean nullable) {
            this.name = name;
            this.type = type;
            this.nullable = nullable;
        }

        public int getLength() {
            return 0;
        }

        public int getScale() {
            return 0;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public String getName() {
            return this.name;
        }

        public int getType() {
            return this.type;
        }
    }
}

