/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.driver;

import de.ubs.jdbcserver.driver.UBSConnection;
import de.ubs.jdbcserver.driver.UBSParameterMetaData;
import de.ubs.jdbcserver.driver.UBSStatement;
import de.ubs.jdbcserver.jdbccomm.ConnectionAction;
import de.ubs.jdbcserver.jdbccomm.StatementAction;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccomm.util.ClientSerializer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom2.Document;
import org.jdom2.Element;

public abstract class AbstractStatement
implements Statement {
    protected UUID statementUUID;
    protected UBSConnection connection;
    protected int maxRows = -1;
    protected int currentUpdateCount = -1;
    protected ResultSet currentResultSet = null;
    protected UBSParameterMetaData parameterMetaData;
    private boolean closed;
    private int fetchSize = 50;

    public AbstractStatement(UBSConnection connection) {
        this.connection = connection;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public void clearBatch() throws SQLException {
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int maxRows) throws SQLException {
        this.maxRows = maxRows;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    protected Element internalExecuteStatement() throws SQLException {
        Element statementElement = new Element("statement");
        statementElement.setAttribute("action", StatementAction.EXECUTE.name());
        statementElement.setAttribute("uuid", this.statementUUID.toString());
        try {
            return this.connection.getRemoteSession().send(new Document(statementElement));
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (Exception ex) {
            SQLException e = new SQLException(ex.getMessage(), ex);
            throw e;
        }
    }

    protected void internalPrepareStatement(String sql) throws SQLException {
        Element connectionElement = new Element("connection");
        connectionElement.setAttribute("action", ConnectionAction.PREPARE.name());
        connectionElement.addContent(new Element("sql").setText(sql));
        try {
            Element result = this.connection.getRemoteSession().send(new Document(connectionElement));
            this.statementUUID = UUID.fromString(result.getAttributeValue("uuid"));
            Element parameterMarkerElement = result.getChild("parameter-markers");
            if (parameterMarkerElement != null) {
                TableDefinition temp = ClientSerializer.tableDefinitionFromXML(parameterMarkerElement.getChild("table-definition"));
                this.parameterMetaData = new UBSParameterMetaData(temp);
            }
            Logger.getLogger(UBSStatement.class.getName()).log(Level.FINE, "Prepared statement with ID {0}", this.statementUUID.toString());
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (Exception ex) {
            SQLException e = new SQLException(ex.getMessage(), ex);
            throw e;
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1003;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    @Override
    public void close() throws SQLException {
        if (this.statementUUID != null) {
            Element element = new Element("statement");
            element.setAttribute("action", StatementAction.CLOSE.name());
            element.setAttribute("uuid", this.statementUUID.toString());
            try {
                this.connection.getRemoteSession().send(new Document(element));
                Logger.getLogger(UBSStatement.class.getName()).log(Level.FINE, "Closed statement with ID {0}", this.statementUUID.toString());
                this.closed = true;
            }
            catch (SQLException ex) {
                throw ex;
            }
            catch (Exception ex) {
                SQLException e = new SQLException("Failed to close statement " + this.statementUUID.toString(), ex);
                throw e;
            }
            this.statementUUID = null;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.currentResultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        int rc = this.currentResultSet != null ? -1 : this.currentUpdateCount;
        return rc;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

