/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.jdbccommons.util;

import de.ubs.jdbcserver.jdbccomm.struct.AbstractItem;
import de.ubs.jdbcserver.jdbccomm.struct.ColumnDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.Field;
import de.ubs.jdbcserver.jdbccomm.struct.Section;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.TablePermission;
import de.ubs.jdbcserver.jdbccomm.struct.UserPermission;
import de.ubs.jdbcserver.jdbccomm.util.Pair;
import de.ubs.jdbcserver.jdbccommons.struct.CatalogManager;
import de.ubs.jdbcserver.jdbccommons.struct.PermissionManager;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Map;
import org.apache.commons.lang3.time.FastDateFormat;
import org.jdom2.Element;

public class ServerSerializer {
    private static final String YES = "Y";
    private static final String NO = "N";
    private static final FastDateFormat DATE_FORMATTER = FastDateFormat.getInstance("yyyy-MM-dd-HH:mm:ss.SSS");

    public static Element toXML(PermissionManager pm) {
        Element root = new Element("permissions");
        for (UserPermission userPermission : pm.getUserPermissions().values()) {
            root.addContent(ServerSerializer.toXML(userPermission));
        }
        for (Map.Entry entry : pm.getTablePermissions().entrySet()) {
            root.addContent(ServerSerializer.toXML((TableDefinition)((Pair)entry.getKey()).second(), (TablePermission)entry.getValue()));
        }
        return root;
    }

    private static Element toXML(UserPermission up) {
        Element root = new Element("user");
        root.setAttribute("grantor", up.getGrantor());
        root.setAttribute("grantee", up.getGrantee());
        root.setAttribute("createtb", up.isCreateTable() ? YES : NO);
        root.setAttribute("createts", up.isCreateTablespace() ? YES : NO);
        root.setAttribute("droptb", up.isDropTable() ? YES : NO);
        root.setAttribute("dropts", up.isDropTablespace() ? YES : NO);
        root.setAttribute("sysadm", up.isSysadm() ? YES : NO);
        root.setAttribute("time", DATE_FORMATTER.format(up.getGrantedTs()));
        return root;
    }

    private static Element toXML(TableDefinition td, TablePermission tp) {
        Element root = new Element("table");
        root.setAttribute("grantor", tp.getGrantor());
        root.setAttribute("grantee", tp.getGrantee());
        root.setAttribute("schema", td.getSchema());
        root.setAttribute("name", td.getName());
        root.setAttribute("delete", tp.isDelete() ? YES : NO);
        root.setAttribute("insert", tp.isInsert() ? YES : NO);
        root.setAttribute("select", tp.isSelect() ? YES : NO);
        root.setAttribute("update", tp.isUpdate() ? YES : NO);
        root.setAttribute("time", DATE_FORMATTER.format(tp.getGrantedTs()));
        return root;
    }

    private static Element toXML(ColumnDefinition cd) {
        Element element = new Element("column-definition");
        element.setAttribute("name", cd.getName());
        element.setAttribute("type", cd.getTypeName());
        element.setAttribute("length", String.valueOf(cd.getLength()));
        element.setAttribute("scale", String.valueOf(cd.getScale()));
        element.setAttribute("nullable", cd.isNullable() ? YES : NO);
        element.setAttribute("read-only", cd.isReadOnly() ? YES : NO);
        element.setAttribute("key-seq", String.valueOf(cd.getKeySequence()));
        if (cd.getTimestampPattern() != null) {
            element.setAttribute("timestamp-pattern", cd.getTimestampPattern());
        }
        if (cd.getExistenceExpression() != null) {
            element.setAttribute("existence-expression", cd.getExistenceExpression());
        }
        if (cd.getLabel() != null) {
            element.setAttribute("label", cd.getLabel());
        }
        if (cd.getFieldPath() != null && cd.getFieldPath().getPathElements() != null) {
            for (String referencedFieldPath : cd.getFieldPath().getPathElements()) {
                element.addContent(new Element("references").setText(referencedFieldPath));
            }
        }
        return element;
    }

    private static Pair<TableDefinition, TablePermission> loadTablePermission(Element e) throws SQLException, ParseException {
        String schema = e.getAttributeValue("schema");
        String tableName = e.getAttributeValue("name");
        String grantor = e.getAttributeValue("grantor");
        String grantee = e.getAttributeValue("grantee");
        Timestamp timestamp = new Timestamp(DATE_FORMATTER.parse(e.getAttributeValue("time")).getTime());
        TableDefinition td = CatalogManager.getDefault().getTableDefinition(schema, tableName);
        TablePermission tp = new TablePermission(grantee, grantor, schema, tableName);
        tp.setGrantedTs(timestamp);
        if (YES.equalsIgnoreCase(e.getAttributeValue("insert"))) {
            tp.grantInsert();
        }
        if (YES.equalsIgnoreCase(e.getAttributeValue("update"))) {
            tp.grantUpdate();
        }
        if (YES.equalsIgnoreCase(e.getAttributeValue("delete"))) {
            tp.grantDelete();
        }
        if (YES.equalsIgnoreCase(e.getAttributeValue("select"))) {
            tp.grantSelect();
        }
        return new Pair<TableDefinition, TablePermission>(td, tp);
    }

    private static UserPermission loadUserPermission(Element e) throws ParseException {
        String grantor = e.getAttributeValue("grantor");
        String grantee = e.getAttributeValue("grantee");
        Timestamp timestamp = new Timestamp(DATE_FORMATTER.parse(e.getAttributeValue("time")).getTime());
        UserPermission up = new UserPermission(grantee, grantor);
        up.setGrantedTs(timestamp);
        if (YES.equalsIgnoreCase(e.getAttributeValue("sysadm"))) {
            up.grantSysadm();
        }
        if (YES.equalsIgnoreCase(e.getAttributeValue("createts"))) {
            up.grantCreateTablespace();
        }
        if (YES.equalsIgnoreCase(e.getAttributeValue("createtb"))) {
            up.grantCreateTable();
        }
        if (YES.equalsIgnoreCase(e.getAttributeValue("droptb"))) {
            up.grantDropTable();
        }
        if (YES.equalsIgnoreCase(e.getAttributeValue("dropts"))) {
            up.grantDropTablespace();
        }
        return up;
    }

    public static void loadPermissionManager(PermissionManager pm, Element e) throws SQLException, ParseException {
        for (Element children : e.getChildren()) {
            if (children.getName().equals("table")) {
                Pair<TableDefinition, TablePermission> pair = ServerSerializer.loadTablePermission(children);
                pm.getTablePermissions().put(new Pair<String, TableDefinition>(pair.second().getGrantee(), pair.first()), pair.second());
                continue;
            }
            if (!children.getName().equals("user")) continue;
            UserPermission up = ServerSerializer.loadUserPermission(children);
            pm.getUserPermissions().put(up.getGrantee(), up);
        }
    }

    public static Element toXML(TableDefinition td) {
        Element element = new Element("table-definition");
        element.setAttribute("name", td.getName());
        element.setAttribute("schema", td.getSchema());
        if (td.getWhenCondition() != null) {
            element.addContent(new Element("when").setText(td.getWhenCondition()));
        }
        if (td.getCreator() != null) {
            element.setAttribute("creator", td.getCreator());
        }
        if (null != td.getCreatedTimestamp()) {
            element.setAttribute("createdts", DATE_FORMATTER.format(td.getCreatedTimestamp()));
        }
        if (null != td.getAlteredTimestamp()) {
            element.setAttribute("alteredts", DATE_FORMATTER.format(td.getAlteredTimestamp()));
        }
        for (ColumnDefinition columnDefinition : td.getColumns()) {
            element.addContent(ServerSerializer.toXML(columnDefinition));
        }
        return element;
    }

    private static Element toXML(Section section) {
        Element element = ServerSerializer.createForAbstractItem(section, "section");
        if (section.getCondition() != null) {
            element.addContent(new Element("condition").setText(section.getCondition()));
        }
        for (AbstractItem item : section.getItems()) {
            if (item instanceof Section) {
                Section subsection = (Section)item;
                element.addContent(ServerSerializer.toXML(subsection));
                continue;
            }
            Field f = (Field)item;
            Element fieldElement = ServerSerializer.createForAbstractItem(f, "field");
            fieldElement.setAttribute("type", f.getType());
            fieldElement.setAttribute("storage-length", String.valueOf(f.getLength()));
            fieldElement.setAttribute("display-length", String.valueOf(f.getDisplayLength()));
            fieldElement.setAttribute("scale", String.valueOf(f.getScale()));
            fieldElement.setAttribute("decimal-implied", String.valueOf(f.isImpliedDecimalPoint()));
            if (f.getEncoding() != null) {
                fieldElement.setAttribute("encoding", f.getEncoding().name());
            }
            for (Map.Entry<String, String> entry : f.getAdditionalProperties().entrySet()) {
                Element prop = new Element("property");
                prop.setAttribute("name", entry.getKey());
                prop.setAttribute("value", entry.getValue());
                fieldElement.addContent(prop);
            }
            element.addContent(fieldElement);
            if (f.getCondition() == null) continue;
            fieldElement.addContent(new Element("condition").setText(f.getCondition()));
        }
        return element;
    }

    private static Element createForAbstractItem(AbstractItem ai, String elementName) {
        Element element = new Element(elementName);
        element.setAttribute("name", ai.getName());
        element.setAttribute("position", String.valueOf(ai.getPosition()));
        element.setAttribute("max-occurrences", String.valueOf(ai.getMaximumOccurrences()));
        if (ai.getOccurrenceCounterField() != null) {
            element.setAttribute("occurs-field", ai.getOccurrenceCounterField());
        }
        if (ai.getRedefine() != null) {
            element.setAttribute("redefine", ai.getRedefine());
        }
        return element;
    }
}

