/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.file;

import de.ubs.jdbcserver.file.AbstractCsvFileReader;
import de.ubs.jdbcserver.file.CsvFileReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.nio.file.Files;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UnixCsvFileReader
extends AbstractCsvFileReader {
    private final File f;
    private final Reader reader;
    private final int maximumRecordSize;
    private boolean eof = false;
    private char previousLineTerminator = '\u0000';
    private String detectedLineSeparator = System.lineSeparator();

    public UnixCsvFileReader(File f, Charset encoding, char stringDelimiter, int maximumRecordSize, CodingErrorAction codingErrorAction, CsvFileReader.HeaderProcessingMode headerProcessingMode) throws IOException {
        super(encoding, codingErrorAction, stringDelimiter, headerProcessingMode);
        this.f = f;
        this.reader = new InputStreamReader((InputStream)new FileInputStream(f), this.charsetDecoder);
        this.maximumRecordSize = maximumRecordSize;
        this.detectedLineSeparator = UnixCsvFileReader.detectLineSeparator(f, maximumRecordSize, encoding);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final String detectLineSeparator(File f, int maximumBytesToScan, Charset encoding) {
        try {
            if (Files.size(f.toPath()) == 0L) {
                return System.lineSeparator();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try (InputStreamReader tempReader = new InputStreamReader((InputStream)new FileInputStream(f), encoding);){
            int readRc1;
            for (int i = 0; i < maximumBytesToScan && (readRc1 = tempReader.read()) != -1; ++i) {
                char c1 = (char)readRc1;
                if (c1 == '\r') {
                    char c2;
                    int readRc2 = tempReader.read();
                    ++i;
                    if (readRc2 == -1 || (c2 = (char)readRc2) != '\n') continue;
                    Logger.getLogger(UnixCsvFileReader.class.getName()).log(Level.FINER, String.format("Windows-style line endings detected for %s", f.getAbsolutePath()));
                    String string = "\r\n";
                    return string;
                }
                if (c1 != '\n') continue;
                Logger.getLogger(UnixCsvFileReader.class.getName()).log(Level.FINER, String.format("Unix-style line endings detected for %s", f.getAbsolutePath()));
                String string = "\n";
                return string;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Logger.getLogger(UnixCsvFileReader.class.getName()).log(Level.FINER, String.format("Unable to detect line endings for %s, using system default", f.getAbsolutePath()));
        return System.lineSeparator();
    }

    @Override
    protected String getNextRawRecord() throws IOException {
        StringBuilder sb;
        block7: {
            if (this.eof) {
                return null;
            }
            sb = new StringBuilder();
            int stringDelimiterCount = 0;
            while (true) {
                int readRc;
                if ((readRc = this.reader.read()) == -1) {
                    this.eof = true;
                    if (sb.length() == 0) {
                        return null;
                    }
                    break block7;
                }
                char c = (char)readRc;
                if (this.stringDelimiter != '\u0000' && c == this.stringDelimiter) {
                    ++stringDelimiterCount;
                }
                if ((c == '\n' || c == '\r') && stringDelimiterCount % 2 == 0) {
                    if (c == '\n' && this.previousLineTerminator == '\r') {
                        this.previousLineTerminator = '\u0000';
                        continue;
                    }
                    this.previousLineTerminator = c;
                    break block7;
                }
                sb.append((char)readRc);
                if (sb.length() >= this.maximumRecordSize) break;
            }
            throw new IOException("Maximum record size " + this.maximumRecordSize + " exceeded while reading record from " + this.f.getAbsolutePath());
        }
        return sb.toString();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public String getDetectedLineSeparator() {
        return this.detectedLineSeparator;
    }
}

