/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver;

import com.ibm.jzos.MvsConsole;
import de.ubs.jdbcserver.CommandServerInstance;
import de.ubs.jdbcserver.jdbccomm.util.CommonUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class CommandServer
implements Runnable {
    public static final String THREAD_NAME_PREFIX = "client-thread";
    private static final int MAX_ERRORS_UNTIL_DELAY = 5;
    private static int maxListenErrors = 10;
    private static int listenDelay = 30;
    private static boolean printWtoMessages = false;
    private boolean shutdownRequested = false;
    private final int serverPort;
    private ServerSocket serverSocket = null;
    private static Certificate certificate;
    private static PrivateKey privateKey;

    public CommandServer(int serverPort) {
        this.serverPort = serverPort;
    }

    public static void setListenDelay(int s) {
        listenDelay = s;
    }

    public static void setMaxListenErrors(int e) {
        maxListenErrors = e;
    }

    public static void setPrintWtoMessages(boolean p) {
        printWtoMessages = p;
    }

    public static boolean getSecured() {
        return certificate != null && privateKey != null;
    }

    public static void setCertificate(String cert) throws CertificateException, IOException {
        if (StringUtils.isNotBlank(cert)) {
            try (ByteArrayInputStream input = new ByteArrayInputStream(cert.getBytes(StandardCharsets.UTF_8));){
                certificate = CertificateFactory.getInstance("X509").generateCertificate(input);
            }
        }
    }

    public static void setPrivateKey(String key) throws GeneralSecurityException {
        if (StringUtils.isNotBlank(key)) {
            privateKey = CommandServer.getPrivateKeyFromString(key);
        }
    }

    public static PrivateKey getPrivateKeyFromString(String key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        String privateKeyPEM = key;
        privateKeyPEM = privateKeyPEM.replace("-----BEGIN PRIVATE KEY-----\n", "");
        privateKeyPEM = privateKeyPEM.replace("-----END PRIVATE KEY-----", "");
        privateKeyPEM = privateKeyPEM.trim();
        byte[] encoded = Base64.decodeBase64(privateKeyPEM);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encoded);
        return kf.generatePrivate(keySpec);
    }

    public void requestShutdown() {
        this.shutdownRequested = true;
        this.closeServerSocket();
    }

    private synchronized void closeServerSocket() {
        if (this.serverSocket != null) {
            if (!this.serverSocket.isClosed()) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.serverSocket = null;
        }
    }

    @Override
    public void run() {
        if (printWtoMessages && CommonUtils.isZos()) {
            MvsConsole.wto(String.format("UBSFBR01 UBS File Bridge Server started on port %d", this.serverPort), 16384, 1024);
        }
        Logger.getLogger(CommandServer.class.getName()).log(Level.INFO, "Opening port {0} for incoming commands", this.serverPort);
        try {
            this.serverSocket = this.createServerSocket();
        }
        catch (BindException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
            Logger.getLogger(CommandServer.class.getName()).log(Level.SEVERE, ex.getMessage());
            return;
        }
        catch (IOException ex) {
            Logger.getLogger(CommandServer.class.getName()).log(Level.SEVERE, "Unable to open server socket for commands", ex);
            return;
        }
        this.runServer();
        this.closeServerSocket();
        Logger.getLogger(CommandServer.class.getName()).log(Level.INFO, "Command server thread ended");
        if (printWtoMessages && CommonUtils.isZos()) {
            MvsConsole.wto("UBSFBR02 UBS File Bridge Server ended", 16384, 1024);
        }
    }

    private ServerSocket createServerSocket() throws IOException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, CertificateException {
        if (certificate != null && privateKey != null) {
            char[] password = "e94gXnTSrF*e7@ui@fU9M5gqq!39p23A".toCharArray();
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, password);
            keyStore.setCertificateEntry("jdbcserver", certificate);
            keyStore.setKeyEntry("jdbcserver", privateKey, password, new Certificate[]{certificate});
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, password);
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            SSLServerSocketFactory factory = context.getServerSocketFactory();
            return factory.createServerSocket(this.serverPort);
        }
        return ServerSocketFactory.getDefault().createServerSocket(this.serverPort);
    }

    private void runServer() {
        int listenErrorCount = 0;
        while (!this.shutdownRequested) {
            Socket s = null;
            try {
                s = this.serverSocket.accept();
                if (listenErrorCount != 0) {
                    Logger.getLogger(CommandServer.class.getName()).log(Level.INFO, "Successfully accepted client connection. Clearing previous errors (number of errors: {0}).", listenErrorCount);
                    listenErrorCount = 0;
                }
            }
            catch (IOException ex) {
                if (this.shutdownRequested) {
                    return;
                }
                Logger.getLogger(CommandServer.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
                if (CommandServer.handleException(++listenErrorCount)) break;
            }
            if (s == null) continue;
            CommandServerInstance serverInstance = new CommandServerInstance(s);
            Thread thread = new Thread(serverInstance);
            thread.setName(THREAD_NAME_PREFIX + s.getRemoteSocketAddress().toString());
            thread.start();
        }
    }

    private static boolean handleException(int listenErrorCount) {
        if (listenErrorCount >= maxListenErrors) {
            Logger.getLogger(CommandServer.class.getName()).log(Level.INFO, "Error waiting for incoming connections (consecutive errors: {0}). Server is shutting down.", maxListenErrors);
            return true;
        }
        if (listenErrorCount >= 5) {
            Logger.getLogger(CommandServer.class.getName()).log(Level.INFO, "Error waiting for incoming connections (consecutive errors: {0}). Waiting for {1} sec. before next retry, max. errors until shutdown: {2}", new Object[]{listenErrorCount, listenDelay, maxListenErrors});
            try {
                Thread.sleep((long)listenDelay * 1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Logger.getLogger(CommandServer.class.getName()).log(Level.INFO, "Reattempting to listen for incoming connections.");
        }
        return false;
    }
}

