/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.jdbccomm.struct;

import de.ubs.jdbcserver.jdbccomm.struct.AbstractPermission;

public class TablePermission
extends AbstractPermission {
    private final String tableName;
    private final String tableSchema;
    private boolean insert = false;
    private boolean delete = false;
    private boolean update = false;
    private boolean select = false;

    public TablePermission(String grantee, String grantor, String tableSchema, String tableName) {
        super(grantee, grantor);
        this.tableName = tableName;
        this.tableSchema = tableSchema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableSchema() {
        return this.tableSchema;
    }

    public void grantInsert() {
        this.insert = true;
    }

    public void revokeInsert() {
        this.insert = false;
    }

    public void grantDelete() {
        this.delete = true;
    }

    public void revokeDelete() {
        this.delete = false;
    }

    public void grantUpdate() {
        this.update = true;
    }

    public void revokeUpdate() {
        this.update = false;
    }

    public void grantSelect() {
        this.select = true;
    }

    public void revokeSelect() {
        this.select = false;
    }

    public boolean isInsert() {
        return this.insert;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public boolean isSelect() {
        return this.select;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public static enum Action {
        INSERT,
        DELETE,
        UPDATE,
        SELECT,
        GRANT,
        REVOKE;

    }
}

