/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.command.sql;

import de.ubs.jdbcserver.ScratchPadManager;
import de.ubs.jdbcserver.command.AbstractServerCommand;
import de.ubs.jdbcserver.command.UniqueConnectionIdentifier;
import de.ubs.jdbcserver.command.file.FileCommand;
import de.ubs.jdbcserver.command.sql.ParameterValueData;
import de.ubs.jdbcserver.command.sql.PreparedDeleteContext;
import de.ubs.jdbcserver.command.sql.PreparedInsertContext;
import de.ubs.jdbcserver.command.sql.PreparedUpdateContext;
import de.ubs.jdbcserver.cursor.FileCursor;
import de.ubs.jdbcserver.cursor.IndexFileCursor;
import de.ubs.jdbcserver.evaluation.AbstractParameterMarkerVisitor;
import de.ubs.jdbcserver.evaluation.ExpressionEvaluator;
import de.ubs.jdbcserver.evaluation.InsertParameterMarkerVisitor;
import de.ubs.jdbcserver.evaluation.SelectParameterMarkerVisitor;
import de.ubs.jdbcserver.evaluation.UpdateParameterMarkerVisitor;
import de.ubs.jdbcserver.file.FileManager;
import de.ubs.jdbcserver.file.ProcessableFile;
import de.ubs.jdbcserver.index.IndexUtils;
import de.ubs.jdbcserver.jdbccomm.ConnectionAction;
import de.ubs.jdbcserver.jdbccomm.struct.ColumnDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.TablePermission;
import de.ubs.jdbcserver.jdbccomm.struct.TablespaceLayout;
import de.ubs.jdbcserver.jdbccomm.transport.Transportable;
import de.ubs.jdbcserver.jdbccomm.transport.TransportableFactory;
import de.ubs.jdbcserver.jdbccomm.util.ClientSerializer;
import de.ubs.jdbcserver.jdbccommons.FileType;
import de.ubs.jdbcserver.jdbccommons.sql.parser.ParserUtils;
import de.ubs.jdbcserver.jdbccommons.sql.parser.SQLParserParser;
import de.ubs.jdbcserver.jdbccommons.sql.parser.StatementInformation;
import de.ubs.jdbcserver.jdbccommons.struct.CatalogManager;
import de.ubs.jdbcserver.jdbccommons.struct.PermissionManager;
import de.ubs.jdbcserver.jdbccommons.struct.TablespaceDefinition;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom2.Document;
import org.jdom2.Element;

public class ConnectionCommand
extends AbstractServerCommand {
    public ConnectionCommand(UniqueConnectionIdentifier connectionId, Document doc) {
        super(connectionId, doc);
    }

    @Override
    public Element execute() throws Exception {
        Element root = this.doc.getRootElement();
        ConnectionAction action = ConnectionAction.valueOf(root.getAttributeValue("action"));
        switch (action) {
            case OPEN: {
                return this.open(root);
            }
            case CLOSE: {
                return this.close(root);
            }
            case PREPARE: {
                return this.prepareStatement(root);
            }
        }
        throw new RuntimeException("Unsupported connection action: " + (Object)((Object)action));
    }

    protected Element open(Element root) throws IOException, UnsupportedEncodingException {
        UUID connectionUUID = UUID.randomUUID();
        Transportable<ArrayList> transportable = TransportableFactory.createTransportable(root, ArrayList.class);
        ScratchPadManager.getDefault().put(this.connectionId, connectionUUID, transportable);
        return new Element("connection").setAttribute("uuid", connectionUUID.toString());
    }

    private Element prepareStatement(Element root) throws IOException, SQLException {
        TableDefinition parameterMarkerDefinition;
        UUID statementUUID = UUID.randomUUID();
        String sql = root.getChild("sql").getText();
        StatementInformation si = new ParserUtils().parseSQL(sql);
        Logger.getLogger(ConnectionCommand.class.getName()).log(Level.FINER, "parse SQL: {0}", sql);
        ScratchPadManager.getDefault().put(this.connectionId, statementUUID, si);
        SQLParserParser.DeleteStatementContext deleteStatement = si.getStatementInformation().deleteStatement();
        SQLParserParser.UpdateStatementContext updateStatement = si.getStatementInformation().updateStatement();
        SQLParserParser.InsertStatementContext insertStatement = si.getStatementInformation().insertStatement();
        SQLParserParser.SelectStatementContext selectStatement = si.getStatementInformation().selectStatement();
        boolean isApplicableStatement = deleteStatement != null || updateStatement != null || insertStatement != null;
        TableDefinition tableDefinition = null;
        if (si.getTableName() != null && si.getTableSchema() != null) {
            tableDefinition = CatalogManager.getDefault().getTableDefinition(si.getTableSchema(), si.getTableName());
        }
        if (insertStatement != null) {
            PermissionManager.getDefault().checkPermission(tableDefinition, this.user, TablePermission.Action.INSERT);
            ScratchPadManager.getDefault().put(this.connectionId, statementUUID, new PreparedInsertContext(si));
        } else if (deleteStatement != null) {
            PermissionManager.getDefault().checkPermission(tableDefinition, this.user, TablePermission.Action.DELETE);
            ScratchPadManager.getDefault().put(this.connectionId, statementUUID, new PreparedDeleteContext(si));
        } else if (updateStatement != null) {
            PermissionManager.getDefault().checkPermission(tableDefinition, this.user, TablePermission.Action.UPDATE);
            ScratchPadManager.getDefault().put(this.connectionId, statementUUID, new PreparedUpdateContext(si));
        } else if (selectStatement != null) {
            PermissionManager.getDefault().checkPermission(tableDefinition, this.user, TablePermission.Action.SELECT);
        }
        if (tableDefinition != null && tableDefinition.getSchema().equalsIgnoreCase("SYSUBS")) {
            if (insertStatement != null) {
                throw new SQLException("Operation INSERT is not defined for directory tables", "42832", -607);
            }
            if (deleteStatement != null) {
                throw new SQLException("Operation DELETE is not defined for directory tables", "42832", -607);
            }
            if (updateStatement != null) {
                throw new SQLException("Operation UPDATE is not defined for directory tables", "42832", -607);
            }
        }
        if (isApplicableStatement) {
            if (insertStatement != null && tableDefinition != null) {
                if (!insertStatement.identifier().isEmpty()) {
                    if (insertStatement.identifier().size() != insertStatement.sum().size()) {
                        throw new SQLException(String.format("The number of values in the INSERT statement (%d) does not match the number of columns (%d).", insertStatement.identifier(), insertStatement.sum().size()), "42802", -117);
                    }
                    for (SQLParserParser.IdentifierContext column : insertStatement.identifier()) {
                        if (tableDefinition.indexOfColumn(column.value) != -1) continue;
                        throw new SQLException(String.format("%s is not a column of table %s.%s", column.value, tableDefinition.getSchema(), tableDefinition.getName()), "42703", -205);
                    }
                } else if (tableDefinition.getColumns().size() != insertStatement.sum().size()) {
                    throw new SQLException(String.format("The number of values in the INSERT statement (%d) does not match the number of columns (%d).", insertStatement.sum().size(), tableDefinition.getColumns().size()), "42802", -117);
                }
            }
            TablespaceDefinition tablespace = CatalogManager.getDefault().getTablespace(tableDefinition.getTablespaceName());
            TablespaceLayout layout = tablespace.getLayout();
            String fileName = layout.getFileName();
            ProcessableFile file = tablespace.getTablespaceType() == TablespaceDefinition.TablespaceType.VSAM ? FileManager.getDefault().open(fileName, "a+b,type=record", FileType.VSAM_KSDS, tablespace, tableDefinition) : FileManager.getDefault().open(fileName, "a+b,type=record", FileType.PLAINTEXT_CSV, tablespace, tableDefinition);
            ParameterValueData parameterValueData = new ParameterValueData();
            ScratchPadManager.getDefault().put(this.connectionId, statementUUID, parameterValueData);
            FileCursor cursor = null;
            Boolean indexAccessPossible = new IndexUtils().isIndexAccessPossible(layout, si);
            cursor = indexAccessPossible != false ? new IndexFileCursor(tablespace, tableDefinition, file, si) : new FileCursor(tablespace, tableDefinition, file);
            ScratchPadManager.getDefault().put(this.connectionId, statementUUID, cursor);
            if (cursor.isReadOnly()) {
                throw new SQLException(String.format("Operation is not defined on table %s.%s", si.getTableSchema(), si.getTableName()), "42832", -607);
            }
            if (updateStatement != null && updateStatement.whereClause() != null) {
                cursor.updateFilter(new ExpressionEvaluator(tableDefinition, null, updateStatement.whereClause().disjunction()));
            } else if (deleteStatement != null && deleteStatement.whereClause() != null) {
                PreparedDeleteContext ctx = ScratchPadManager.getDefault().get(this.connectionId, statementUUID, PreparedDeleteContext.class);
                cursor.updateFilter(ctx.getVisitor());
            }
        }
        Logger.getLogger(ConnectionCommand.class.getName()).log(Level.FINER, "Statement has been parsed: {0}", sql);
        Element result = new Element("statement").setAttribute("uuid", statementUUID.toString());
        if (tableDefinition != null && (parameterMarkerDefinition = this.createParameterMarkerDefinition(si.getStatementInformation(), tableDefinition)) != null) {
            Element parameterMakerElement = new Element("parameter-markers");
            parameterMakerElement.addContent(ClientSerializer.toXML(parameterMarkerDefinition));
            result.addContent(parameterMakerElement);
        }
        return result;
    }

    private TableDefinition createParameterMarkerDefinition(SQLParserParser.StatementContext ctx, TableDefinition referencedTable) {
        AbstractParameterMarkerVisitor visitor = null;
        if (ctx.selectStatement() != null || ctx.deleteStatement() != null) {
            visitor = new SelectParameterMarkerVisitor(referencedTable);
        } else if (ctx.insertStatement() != null) {
            visitor = new InsertParameterMarkerVisitor(referencedTable);
        } else if (ctx.updateStatement() != null) {
            visitor = new UpdateParameterMarkerVisitor(referencedTable);
        }
        if (visitor == null) {
            return null;
        }
        visitor.visitStatement(ctx);
        List<ColumnDefinition> columns = visitor.getParameterMarkerColumns();
        if (columns.isEmpty()) {
            return null;
        }
        TableDefinition tableDefinition = new TableDefinition(referencedTable.getSchema(), referencedTable.getName());
        for (ColumnDefinition columnDefinition : columns) {
            tableDefinition.getColumns().add(columnDefinition);
        }
        return tableDefinition;
    }

    private Element close(Element root) {
        UUID connectionUUID = UUID.fromString(root.getAttributeValue("uuid"));
        int count = ScratchPadManager.getDefault().removeAll(this.connectionId, connectionUUID);
        Logger.getLogger(FileCommand.class.getName()).log(Level.FINER, "Closed connection {0} and removed {1} open resources", new Object[]{connectionUUID.toString(), count});
        return new Element("connection");
    }
}

