/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver;

import com.ibm.jzos.PdsDirectory;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.jzos.ZUtil;
import de.ubs.jdbcserver.jdbccomm.struct.TablePermission;
import de.ubs.jdbcserver.jdbccomm.struct.UserPermission;
import de.ubs.jdbcserver.jdbccomm.util.CommonUtils;
import de.ubs.jdbcserver.jdbccommons.struct.AbstractDatabaseEngine;
import de.ubs.jdbcserver.jdbccommons.struct.CatalogManager;
import de.ubs.jdbcserver.jdbccommons.struct.PermissionManager;
import de.ubs.jdbcserver.jdbccommons.struct.TablespaceDefinition;
import de.ubs.jdbcserver.jdbccommons.util.ServerSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class MainframeDatabaseEngine
extends AbstractDatabaseEngine {
    private static final String DD_STRCTREP = "//DD:STRCTREP";
    private boolean sysauthExistedAtBootTime = false;

    private static ZFile getTablespaceFile(String memberName, String mode) throws ZFileException {
        return new ZFile(String.format("%s(%s)", DD_STRCTREP, memberName), mode);
    }

    @Override
    public boolean isApplicable() {
        return CommonUtils.isZos();
    }

    @Override
    public void dropTablespace(TablespaceDefinition ts) throws IOException {
        ZFile.remove(String.format("%s(%s)", DD_STRCTREP, ts.getName()));
    }

    @Override
    public void writePermissions(PermissionManager pm) throws IOException {
        Element root = ServerSerializer.toXML(pm);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new XMLOutputter(Format.getPrettyFormat()).output(root, (OutputStream)out);
        this.write("SYSAUTH", new String(out.toByteArray(), StandardCharsets.UTF_8));
    }

    @Override
    public void loadPermissions(PermissionManager pm) throws IOException {
        if (!this.sysauthExistedAtBootTime) {
            Logger.getLogger(MainframeDatabaseEngine.class.getName()).log(Level.INFO, "Permission tablespace SYSAUTH does not yet exist. ");
            return;
        }
        String content = this.read("SYSAUTH");
        try {
            Document doc = new SAXBuilder().build(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)));
            ServerSerializer.loadPermissionManager(pm, doc.getRootElement());
            if (Logger.getLogger(MainframeDatabaseEngine.class.getName()).isLoggable(Level.FINE)) {
                LinkedList<String> permissions = new LinkedList<String>();
                for (UserPermission up : pm.getUserPermissions().values()) {
                    permissions.add(String.format("USER:  Grantee: %-8s Grantor: %-8s sysadm: %5s", up.getGrantee(), up.getGrantor(), up.isSysadm() ? "Yes" : "No"));
                }
                for (TablePermission tp : pm.getTablePermissions().values()) {
                    permissions.add(String.format("TABLE: Grantee: %-8s Grantor: %-8s select: %5s insert: %5s delete: %5s update: %5s", tp.getGrantee(), tp.getGrantor(), tp.isSelect() ? "Yes" : "No", tp.isInsert() ? "Yes" : "No", tp.isDelete() ? "Yes" : "No", tp.isUpdate() ? "Yes" : "No"));
                }
                Logger.getLogger(MainframeDatabaseEngine.class.getName()).log(Level.FINE, "Permissions loaded: \n{0}", StringUtils.join(permissions, "\n"));
            }
        }
        catch (IOException | SQLException | ParseException | JDOMException ex) {
            Logger.getLogger(MainframeDatabaseEngine.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOException(ex);
        }
    }

    @Override
    public List<TablespaceDefinition> getTablespaces() throws IOException {
        LinkedList<TablespaceDefinition> tablespaces = new LinkedList<TablespaceDefinition>();
        if (null != ZUtil.getJzosDllVersion()) {
            LinkedList<String> memberList = new LinkedList<String>();
            PdsDirectory dir = new PdsDirectory(DD_STRCTREP);
            Iterator iter = dir.iterator();
            while (iter.hasNext()) {
                PdsDirectory.MemberInfo info = (PdsDirectory.MemberInfo)iter.next();
                if (info.getName().equals("SYSAUTH")) {
                    this.sysauthExistedAtBootTime = true;
                    continue;
                }
                memberList.add(info.getName());
            }
            dir.close();
            for (String member : memberList) {
                try {
                    tablespaces.add(this.readTablespace(member));
                }
                catch (IOException | ParseException | JDOMException ex) {
                    Logger.getLogger(MainframeDatabaseEngine.class.getName()).log(Level.SEVERE, null, ex);
                    throw new IOException("Failed to read tablespace definition " + member, ex);
                }
            }
            Logger.getLogger(CatalogManager.class.getName()).log(Level.FINE, "Read {0} registered member from repository", memberList.size());
        }
        return tablespaces;
    }

    @Override
    protected String read(String tablespaceName) throws IOException {
        ZFile zFile = MainframeDatabaseEngine.getTablespaceFile(tablespaceName, "rb,type=record");
        Logger.getLogger(MainframeDatabaseEngine.class.getName()).log(Level.FINE, String.format("Reading definition of tablespace %s from data set %s", tablespaceName, zFile.getFilename()));
        byte[] b = new byte[zFile.getLrecl()];
        ByteArrayOutputStream temp = new ByteArrayOutputStream();
        int rc = 0;
        while ((rc = zFile.read(b)) > 0) {
            temp.write(b, 0, rc);
        }
        zFile.close();
        return new String(temp.toByteArray(), StandardCharsets.UTF_8);
    }

    @Override
    protected void write(String tablespaceName, String content) throws IOException {
        ZFile zFile = MainframeDatabaseEngine.getTablespaceFile(tablespaceName, "wb,type=record");
        Logger.getLogger(MainframeDatabaseEngine.class.getName()).log(Level.FINE, String.format("Writing definition of tablespace %s to data set %s", tablespaceName, zFile.getFilename()));
        for (String line : content.split("\n")) {
            zFile.write(line.getBytes(StandardCharsets.UTF_8));
        }
        zFile.close();
    }
}

