/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.sort;

import de.ubs.jdbcserver.accessor.DataAccessor;
import de.ubs.jdbcserver.command.sql.ParameterValueData;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccomm.util.Pair;
import de.ubs.jdbcserver.jdbccommons.sql.parser.ParserUtils;
import de.ubs.jdbcserver.jdbccommons.sql.parser.SQLParserParser;
import de.ubs.jdbcserver.sort.SortStatementVisitor;
import de.ubs.jdbcserver.sort.TreeOptimizer;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.SQLException;

public class ExpressionOptimizer {
    private final TreeOptimizer treeOptimizer;
    private final SortStatementVisitor filterVisitor;
    private final DataAccessor[] accessors;
    private final TableDefinition tableDefinition;
    private String sortFilterExpression;
    private SQLParserParser.DisjunctionContext optimizedDisjunction;
    private String optimizedExpression;

    public ExpressionOptimizer(TableDefinition table, DataAccessor[] accessors, Charset charset, ParameterValueData pvd, SQLParserParser.DisjunctionContext ctx) throws IOException, SQLException {
        this.tableDefinition = table;
        this.accessors = accessors;
        this.filterVisitor = new SortStatementVisitor(table, accessors, charset, pvd);
        this.treeOptimizer = new TreeOptimizer(this.filterVisitor);
        if (ctx != null) {
            Object pair = this.filterVisitor.visitDisjunction(ctx);
            this.sortFilterExpression = (String)((Pair)pair).second();
            this.optimizedExpression = this.treeOptimizer.visitDisjunction(ctx);
            if (this.optimizedExpression != null) {
                this.optimizedDisjunction = new ParserUtils().parseDisjuncation(this.optimizedExpression);
            }
        }
    }

    public DataAccessor[] getAccessors() {
        return this.accessors;
    }

    public TableDefinition getTableDefinition() {
        return this.tableDefinition;
    }

    public SQLParserParser.DisjunctionContext getOptimizedDisjunction() {
        return this.optimizedDisjunction;
    }

    public String getOptimizedExpression() {
        return this.optimizedExpression;
    }

    public String getSortFilterExpression() {
        return this.sortFilterExpression;
    }
}

