/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.jdbccommons.struct;

import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.TablespaceLayout;
import de.ubs.jdbcserver.jdbccomm.util.ClientSerializer;
import de.ubs.jdbcserver.jdbccommons.struct.DatabaseEngine;
import de.ubs.jdbcserver.jdbccommons.struct.PermissionManager;
import de.ubs.jdbcserver.jdbccommons.struct.TablespaceDefinition;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class CatalogManager {
    private static CatalogManager instance;
    private static DatabaseEngine databaseEngine;
    private final Map<String, TablespaceDefinition> tablespaceMap = new HashMap<String, TablespaceDefinition>();

    public CatalogManager() {
        try {
            for (TablespaceDefinition tablespace : databaseEngine.getTablespaces()) {
                this.tablespaceMap.put(tablespace.getName(), tablespace);
            }
            TablespaceDefinition catalogTablespace = new TablespaceDefinition();
            catalogTablespace.setCreator("SYSUBS");
            catalogTablespace.setName("SYS");
            TablespaceLayout layout = new TablespaceLayout();
            layout.setFileName("");
            catalogTablespace.setLayout(layout);
            Document temp = new SAXBuilder().build(CatalogManager.class.getResourceAsStream("/catalog.xml"));
            for (Element children : temp.getRootElement().getChildren()) {
                TableDefinition td = ClientSerializer.tableDefinitionFromXML(children);
                td.setTablespaceName("SYS");
                catalogTablespace.getTables().add(td);
                Logger.getLogger(CatalogManager.class.getName()).log(Level.FINE, "Read definition of catalog table {0}.{1}", new Object[]{td.getSchema(), td.getName()});
            }
            this.tablespaceMap.put("SYS", catalogTablespace);
            Logger.getLogger(CatalogManager.class.getName()).log(Level.FINE, "Read catalog information");
        }
        catch (IOException | ParseException | JDOMException e) {
            Logger.getLogger(CatalogManager.class.getName()).log(Level.SEVERE, "Failed to read STRCTREP", e);
            System.exit(8);
        }
    }

    public static void reset() {
        instance = null;
    }

    public static synchronized CatalogManager getDefault() {
        if (instance == null) {
            if (databaseEngine == null) {
                Logger.getLogger(CatalogManager.class.getName()).log(Level.SEVERE, "No database engine registered");
                System.exit(8);
            }
            instance = new CatalogManager();
        }
        return instance;
    }

    public static DatabaseEngine getDatabaseEngine() {
        return databaseEngine;
    }

    public static void setDatabaseEngine(DatabaseEngine databaseEngine) {
        CatalogManager.databaseEngine = databaseEngine;
    }

    public static void checkLength(String s, String what, int maxLength) throws SQLException {
        if (s.length() > maxLength) {
            SQLException e = new SQLException(String.format("The %s %s is too long. Maximum allowable size is %d", what, s, maxLength), "46002", -107);
            Logger.getLogger(CatalogManager.class.getName()).log(Level.SEVERE, e.getMessage());
            throw e;
        }
        if (s.isEmpty()) {
            SQLException e = new SQLException(String.format("The %s must not be empty", what), "46002", -107);
            Logger.getLogger(CatalogManager.class.getName()).log(Level.SEVERE, e.getMessage());
            throw e;
        }
    }

    public TableDefinition getTableDefinition(String schema, String name) throws SQLException {
        Logger.getLogger(CatalogManager.class.getName()).log(Level.FINE, "Access catalog information of table {0}.{1}", new Object[]{schema, name});
        for (TablespaceDefinition ts : this.tablespaceMap.values()) {
            for (TableDefinition td : ts.getTables()) {
                if (!td.getSchema().equals(schema) || !td.getName().equals(name)) continue;
                return td;
            }
        }
        SQLException e = new SQLException(String.format("The table %s.%s is not defined", schema, name), "42704", -204);
        Logger.getLogger(CatalogManager.class.getName()).log(Level.SEVERE, e.getMessage());
        throw e;
    }

    public Set<TableDefinition> getTables() {
        HashSet<TableDefinition> tables = new HashSet<TableDefinition>();
        for (TablespaceDefinition value : this.tablespaceMap.values()) {
            tables.addAll(value.getTables());
        }
        return tables;
    }

    public Collection<TablespaceDefinition> getTablespaces() {
        return this.tablespaceMap.values();
    }

    public void dropTable(String schema, String name) throws SQLException, IOException {
        TableDefinition td = this.getTableDefinition(schema, name);
        if (td == null) {
            SQLException e = new SQLException(String.format("The table %s.%s is not defined", schema, name), "42704", -204);
            Logger.getLogger(CatalogManager.class.getName()).log(Level.SEVERE, e.getMessage());
            throw e;
        }
        TablespaceDefinition tablespace = this.getTablespace(td.getTablespaceName());
        tablespace.getTables().remove(td);
        databaseEngine.updateTablespace(tablespace);
        PermissionManager.getDefault().removePermissionsFor(td);
        Logger.getLogger(CatalogManager.class.getName()).log(Level.FINE, "Dropped table {0}.{1}", new Object[]{schema, name});
    }

    public void updateTable(TableDefinition td) throws IOException, SQLException {
        CatalogManager.checkLength(td.getSchema(), "table schema", 128);
        CatalogManager.checkLength(td.getName(), "table name", 128);
        TablespaceDefinition tablespace = this.getTablespace(td.getTablespaceName());
        databaseEngine.updateTablespace(tablespace);
        Logger.getLogger(CatalogManager.class.getName()).log(Level.FINE, "Table {0}.{1} has been updated", new Object[]{td.getSchema(), td.getName()});
    }

    public void updateTablespace(TablespaceDefinition tablespace) throws IOException, SQLException {
        CatalogManager.checkLength(tablespace.getName(), "tablespace name", 128);
        databaseEngine.updateTablespace(tablespace);
        Logger.getLogger(CatalogManager.class.getName()).log(Level.FINE, "Tablespace {0} has been updated", tablespace.getName());
    }

    public void createTable(TablespaceDefinition tablespace, TableDefinition td) throws IOException, SQLException {
        String tableSchema = td.getSchema();
        String tableName = td.getName();
        CatalogManager.checkLength(tableSchema, "table schema", 128);
        CatalogManager.checkLength(tableName, "table name", 128);
        CatalogManager.checkLength(tablespace.getName(), "tablespace name", 128);
        if (tablespace.getTablespaceType() == TablespaceDefinition.TablespaceType.CSV && !tablespace.getTables().isEmpty()) {
            SQLException e = new SQLException(String.format("Table %s.%s cannot be created in specified CSV tablespace %s because it already contains a table", tableSchema, tableName, tablespace.getName()), "55017", -646);
            Logger.getLogger(CatalogManager.class.getName()).log(Level.SEVERE, e.getMessage());
            throw e;
        }
        for (TableDefinition tableDefinition : tablespace.getTables()) {
            if (td.equals(tableDefinition) || !tableDefinition.getSchema().equals(tableSchema) || !tableDefinition.getName().equals(tableName)) continue;
            SQLException e = new SQLException(String.format("The table %s.%s already exists", tableSchema, tableName), "42710", -601);
            Logger.getLogger(CatalogManager.class.getName()).log(Level.SEVERE, e.getMessage());
            throw e;
        }
        boolean hasWhenCondition = true;
        for (TableDefinition table : tablespace.getTables()) {
            if (table.equals(td) || table.getWhenCondition() != null && !table.getWhenCondition().isEmpty()) continue;
            hasWhenCondition = false;
        }
        if ((td.getWhenCondition() == null || td.getWhenCondition().isEmpty()) && !hasWhenCondition) {
            SQLException sQLException = new SQLException("Table refused because no when clause has been specified", "42612", -84);
            Logger.getLogger(CatalogManager.class.getName()).log(Level.SEVERE, sQLException.getMessage());
            throw sQLException;
        }
        tablespace.getTables().add(td);
        databaseEngine.updateTablespace(tablespace);
        Logger.getLogger(CatalogManager.class.getName()).log(Level.FINE, "Table {0}.{1} created and tablespace {2} updated", new Object[]{tableSchema, tableName, tablespace.getName()});
    }

    public void dropTablespace(String tablespaceName) throws SQLException, IOException {
        CatalogManager.checkLength(tablespaceName, "tablespace name", 128);
        if (!this.tablespaceMap.containsKey(tablespaceName)) {
            SQLException e = new SQLException("The tablespace " + tablespaceName + " is not defined", "42704", -204);
            Logger.getLogger(CatalogManager.class.getName()).log(Level.FINE, "Tablespace {0} cannot be dropped because it does not exist");
            throw e;
        }
        TablespaceDefinition ts = this.tablespaceMap.remove(tablespaceName);
        databaseEngine.dropTablespace(ts);
        Logger.getLogger(CatalogManager.class.getName()).log(Level.FINE, "Tablespace {0} has been dropped", tablespaceName);
    }

    public String createTablespace(TablespaceDefinition tablespace) throws IOException, SQLException {
        String tablespaceName = tablespace.getName();
        CatalogManager.checkLength(tablespaceName, "tablespace name", 128);
        String dsname = "";
        if (tablespace.getTablespaceType() == TablespaceDefinition.TablespaceType.VSAM) {
            dsname = tablespace.getLayout().getFileName();
            if (tablespaceName == null) {
                tablespace.setName(this.getTablespaceNameForFile(dsname));
            }
        }
        if (this.tablespaceMap.containsKey(tablespaceName)) {
            SQLException e = new SQLException("The tablespace " + tablespaceName + " already exists", "42710", -601);
            Logger.getLogger(CatalogManager.class.getName()).log(Level.SEVERE, e.getMessage());
            throw e;
        }
        this.tablespaceMap.put(tablespaceName, tablespace);
        databaseEngine.updateTablespace(tablespace);
        if (tablespace.getTablespaceType() == TablespaceDefinition.TablespaceType.VSAM) {
            Logger.getLogger(CatalogManager.class.getName()).log(Level.FINE, "Created tablespace {0} for VSAM {1}", new Object[]{tablespaceName, dsname});
        } else if (tablespace.getTablespaceType() == TablespaceDefinition.TablespaceType.CSV) {
            Logger.getLogger(CatalogManager.class.getName()).log(Level.FINE, "Created CSV tablespace {0}", new Object[]{tablespaceName});
        } else {
            SQLException e = new SQLException("Unsupported tablespace type", "56038", -4700);
            Logger.getLogger(CatalogManager.class.getName()).log(Level.SEVERE, e.getMessage());
            throw e;
        }
        return tablespaceName;
    }

    public String getTablespaceNameForFile(String dsname) {
        for (Map.Entry<String, TablespaceDefinition> entry : this.tablespaceMap.entrySet()) {
            if (!entry.getValue().getLayout().getFileName().equals(dsname)) continue;
            return entry.getKey();
        }
        return StringUtils.leftPad(Integer.toHexString(dsname.hashCode()).toUpperCase(), 8, "0");
    }

    public TablespaceDefinition getTablespace(String tablespaceName) {
        return this.tablespaceMap.get(tablespaceName);
    }

    static {
        for (DatabaseEngine load : ServiceLoader.load(DatabaseEngine.class)) {
            if (!load.isApplicable()) continue;
            databaseEngine = load;
            break;
        }
    }
}

