/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.jdbccommons.pl1;

import de.ubs.jdbcserver.jdbccomm.struct.AbstractItem;
import de.ubs.jdbcserver.jdbccomm.struct.Section;
import de.ubs.jdbcserver.jdbccommons.pl1.PL1declException;
import de.ubs.jdbcserver.jdbccommons.pl1.PL1declLexer;
import de.ubs.jdbcserver.jdbccommons.pl1.PL1declNodeVisitor;
import de.ubs.jdbcserver.jdbccommons.pl1.PL1declParser;
import de.ubs.jdbcserver.jdbccommons.pl1.pict.PL1pictParser;
import de.ubs.jdbcserver.jdbccommons.sql.parser.ANTLRNoCaseFileStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class PL1Utils {
    private static PL1Utils instance;
    private static String testLogFile;
    private static String traceLogFile;
    private static String testLogLevel;
    private static String traceLogLevel;
    private static String testLoggerName;
    private static String traceLoggerName;
    private static Logger testLogger;
    private static Logger traceLogger;
    private PL1declException parserError = null;

    private PL1Utils() {
        PL1Utils.setUpTestLogger();
        PL1Utils.setUpTraceLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PL1Utils getInstance() {
        Class<PL1Utils> clazz = PL1Utils.class;
        synchronized (PL1Utils.class) {
            if (instance == null) {
                instance = new PL1Utils();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static void setUpTestLogger() {
        testLogger = PL1Utils.setUpLogger(testLoggerName, testLogLevel, testLogFile);
    }

    private static void setUpTraceLogger() {
        traceLogger = PL1Utils.setUpLogger(traceLoggerName, traceLogLevel, traceLogFile);
    }

    public static Logger setUpLogger(String name, String level, String output) {
        Logger lgr = Logger.getLogger(name);
        lgr.setLevel(Level.parse(level == null ? "INFO" : level.toUpperCase()));
        if (output != null) {
            try {
                FileHandler fh = new FileHandler(output);
                fh.setLevel(lgr.getLevel());
                fh.setFormatter(new SimpleFormatter());
                lgr.addHandler(fh);
                lgr.setUseParentHandlers(false);
            }
            catch (IOException ex) {
                String msg = "FileHandler for " + output + " could not be created.\n Default handlers will be used.\n";
                System.out.println(msg + ex.getMessage());
            }
            catch (SecurityException ex) {
                String msg = "Formatter for FileHandler (" + output + " ) could not be altered.\n Default formatter will be used.\n";
                System.out.println(msg + ex.getMessage());
            }
        } else {
            try {
                lgr.setUseParentHandlers(true);
            }
            catch (SecurityException ex) {
                String msg = "Formatter for FileHandler (" + output + " ) could not be altered.\n Default formatter will be used.\n";
                System.out.println(msg + ex.getMessage());
            }
        }
        return lgr;
    }

    public static String getTestLogFile() {
        return testLogFile;
    }

    public static void setTestLogFile(String testLog) {
        testLogFile = testLog;
    }

    public static String getTestLogLevel() {
        return testLogLevel;
    }

    public static void setTestLogLevel(String level) {
        testLogLevel = level;
    }

    public static String getTestLoggerName() {
        return testLoggerName;
    }

    public static String getTraceLogFile() {
        return traceLogFile;
    }

    public static void setTraceLogFile(String traceLog) {
        traceLogFile = traceLog;
    }

    public static String getTraceLogLevel() {
        return traceLogLevel;
    }

    public static void setTraceLogLevel(String level) {
        traceLogLevel = level;
    }

    public static String getTraceLoggerName() {
        return traceLoggerName;
    }

    public static boolean hasTestLog() {
        return testLogger != null && testLogLevel != null && !testLogLevel.toUpperCase().equals("OFF");
    }

    public static boolean hasTraceLog() {
        return traceLogger != null && traceLogLevel != null && !traceLogLevel.toUpperCase().equals("OFF");
    }

    public static Logger getTestLogger() {
        if (testLogger == null) {
            PL1Utils.setUpTestLogger();
        }
        return testLogger;
    }

    public static Logger getTraceLogger() {
        if (traceLogger == null) {
            PL1Utils.setUpTraceLogger();
        }
        return traceLogger;
    }

    public static void writeTestLog(String msg) {
        if (PL1Utils.hasTestLog()) {
            PL1Utils.getTestLogger().log(Level.parse(testLogLevel == null ? "INFO" : testLogLevel.toUpperCase()), msg);
        }
    }

    public static void writeTraceLog(String msg) {
        if (PL1Utils.hasTraceLog()) {
            PL1Utils.getTraceLogger().log(Level.parse(traceLogLevel == null ? "INFO" : traceLogLevel.toUpperCase()), msg);
        }
    }

    public PL1declParser.DeclStmtListContext parse(String pl1) throws IOException, PL1declException {
        this.parserError = null;
        ANTLRNoCaseFileStream in = new ANTLRNoCaseFileStream(pl1);
        PL1declLexer lexer = new PL1declLexer(in);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        PL1declParser parser = new PL1declParser(tokens);
        parser.addErrorListener(new ErrorHandler());
        PL1declParser.DeclStmtListContext declStmtList = parser.declStmtList();
        if (null != this.parserError) {
            Logger.getLogger(PL1Utils.class.getName()).log(Level.SEVERE, this.parserError.getMessage(), this.parserError);
            throw this.parserError;
        }
        return declStmtList;
    }

    public PL1declParser.DeclStmtListContext parse(List<String> inputLines) throws IOException, PL1declException {
        return this.parse(StringUtils.join(inputLines, "\n"));
    }

    public PL1declParser.DeclStmtListContext parse(InputStream inputStr) throws IOException, PL1declException {
        return this.parse(IOUtils.readLines(inputStr));
    }

    public Section parseItems(List<String> inputLines) throws IOException, PL1declException {
        PL1declParser.DeclStmtListContext declStmtListContext = this.parse(inputLines);
        PL1declNodeVisitor visitor = new PL1declNodeVisitor();
        visitor.visit(declStmtListContext);
        Section section = new Section(null, "start");
        for (AbstractItem item : visitor.getLevelOneItemList()) {
            section.addItem(item);
        }
        return section;
    }

    public Section parseItems(InputStream in) throws IOException, PL1declException {
        return this.parseItems(IOUtils.readLines(in));
    }

    public PL1pictParser.PictSpecContext parsePict(String pl1pict) throws IOException, PL1declException {
        this.parserError = null;
        String parseStr = pl1pict.substring(1, pl1pict.trim().length() - 1);
        System.out.println("parseStr = " + parseStr);
        PL1Utils.writeTraceLog("parseStr = " + parseStr);
        PL1pictParser parser = new PL1pictParser(pl1pict);
        PL1pictParser.PictSpecContext pictSpecCtx = parser.pictSpec();
        if (null != this.parserError) {
            Logger.getLogger(PL1Utils.class.getName()).log(Level.SEVERE, this.parserError.getMessage(), this.parserError);
            throw this.parserError;
        }
        return pictSpecCtx;
    }

    public List<PL1pictParser.PictSpecContext> parsePict(List<String> inputLines) throws IOException, PL1declException {
        ArrayList<PL1pictParser.PictSpecContext> arr = new ArrayList<PL1pictParser.PictSpecContext>();
        for (String line : inputLines) {
            if (line.trim().length() <= 1) continue;
            PL1Utils.writeTraceLog("parsePict(" + line.trim() + ")");
            arr.add(this.parsePict(line.trim()));
        }
        return arr;
    }

    public List<PL1pictParser.PictSpecContext> parsePict(InputStream inputStr) throws IOException, PL1declException {
        return this.parsePict(IOUtils.readLines(inputStr));
    }

    public ErrorHandler createErrorHandler() {
        return new ErrorHandler();
    }

    static {
        testLogFile = null;
        traceLogFile = null;
        testLogLevel = null;
        traceLogLevel = null;
        testLoggerName = PL1Utils.class.getName() + "_testlog";
        traceLoggerName = PL1Utils.class.getName() + "_tracelog";
        testLogger = null;
        traceLogger = null;
    }

    public class ErrorHandler
    implements ANTLRErrorListener {
        @Override
        public void syntaxError(Recognizer<?, ?> rcgnzr, Object o, int lineNo, int i1, String err, RecognitionException re) {
            PL1Utils.this.parserError = new PL1declException("Invalid syntax: " + err + " at line " + lineNo + " position " + i1, re);
        }

        @Override
        public void reportAmbiguity(Parser parser, DFA dfa, int i, int i1, boolean bln, BitSet bitset, ATNConfigSet atncs) {
            String msg = "\nstart index = " + i + ", stop index = " + i1 + ", exact = " + (bln ? "true" : "false") + ", bitset = " + (bitset != null ? bitset.toString() : "null") + "\n ATN config set = " + (atncs != null ? atncs.toString() : "null");
            PL1Utils.this.parserError = new PL1declException("Error: reportAmbiguity()" + msg);
        }

        @Override
        public void reportAttemptingFullContext(Parser parser, DFA dfa, int i, int i1, BitSet bitset, ATNConfigSet atncs) {
            PL1Utils.this.parserError = new PL1declException("Error: reportAttemptingFullContext()");
        }

        @Override
        public void reportContextSensitivity(Parser parser, DFA dfa, int i, int i1, int i2, ATNConfigSet atncs) {
            PL1Utils.this.parserError = new PL1declException("Error: reportContextSensitivity()");
        }

        public Exception getParserError() {
            return PL1Utils.this.parserError;
        }
    }
}

