/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.file;

import com.ibm.jzos.CatalogSearch;
import com.ibm.jzos.RcException;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.jzos.ZUtil;
import de.ubs.jdbcserver.file.AbstractProcessableFile;
import de.ubs.jdbcserver.file.MainframeSystemAbendCodes;
import de.ubs.jdbcserver.jdbccommons.FileType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.HexDump;
import org.apache.commons.lang3.StringUtils;

public class MainframeFile
extends AbstractProcessableFile {
    private static final String KEY_POSITION = "AMDKEY";
    private static final String ENTRY_TYPE = "ENTYPE";
    private static final char INDEX_ENTRY_TYPE = 'I';
    private static final int CATALOG_ERROR = 100;
    private final String path;
    private final FileType type;
    private final ZFile file;
    private final boolean readOnly;
    private int keyLength = -1;
    private int keyPosition = -1;

    public MainframeFile(String path, String mode, FileType type, boolean readOnly) throws ZFileException, SQLException {
        this.path = path;
        this.type = type;
        this.readOnly = readOnly;
        try {
            ZUtil.setEnv("_EDC_RRDS_HIDE_KEY", "Y");
            this.file = new ZFile(ZFile.getSlashSlashQuotedDSN(path, true), mode);
            Logger.getLogger(MainframeFile.class.getName()).log(Level.FINE, "VSAM index key length {0}", this.file.getVsamKeyLength());
        }
        catch (ZFileException ex) {
            String prettyFileName = StringUtils.strip(path, "/'");
            if (ex.getLastOp() == 50 && ex.getErrorCode() == 528) {
                throw new SQLException(String.format("The file %s is in use by another user or job", prettyFileName), "57011", -904);
            }
            throw new SQLException(String.format("Allocation failed. Operation %d error code %d. %s", ex.getLastOp(), ex.getErrorCode(), ex.getMessage()), "57011", -904);
        }
        this.determineKeyInformation();
    }

    @Override
    public boolean isVariableLength() {
        try {
            return this.file.getRecfm().charAt(0) == 'V';
        }
        catch (ZFileException ex) {
            Logger.getLogger(MainframeFile.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    @Override
    public int getRecordCount() {
        try {
            this.file.seek(0L, 2);
            long endPos = this.file.tell();
            this.file.seek(0L, 0);
            if (this.file.getDsorg() == 256) {
                return (int)endPos;
            }
            return (int)endPos;
        }
        catch (ZFileException ex) {
            Logger.getLogger(MainframeFile.class.getName()).log(Level.SEVERE, null, ex);
            return -1;
        }
    }

    public ZFile getFile() {
        return this.file;
    }

    @Override
    public int getKeyStartOffset() {
        return this.keyPosition;
    }

    @Override
    public int getKeyLength() {
        return this.keyLength;
    }

    @Override
    public void begin() throws IOException {
        if (this.type == FileType.VSAM_KSDS) {
            this.file.locate(0L, 1);
        } else {
            this.file.seek(0L, 0);
        }
    }

    @Override
    public void deleteLastReadRecord() throws IOException, SQLException {
        if (this.readOnly) {
            throw new SQLException(String.format("Cannot delete record: Data set %s is read-only, or associated tablespace is declared as read-only", this.path), "42807", -150);
        }
        try {
            this.file.delrec();
        }
        catch (ZFileException e) {
            this.checkException(e);
            throw e;
        }
    }

    private void determineKeyInformation() throws ZFileException {
        block6: {
            CatalogSearch searcher = new CatalogSearch(this.file.getActualFilename(), 64000);
            searcher.addFieldName(KEY_POSITION);
            searcher.addFieldName(ENTRY_TYPE);
            searcher.setClusterNameMatch(true);
            try {
                searcher.search();
                while (searcher.hasNext()) {
                    char entryType;
                    CatalogSearch.Entry entry = (CatalogSearch.Entry)searcher.next();
                    if (!entry.isDatasetEntry() || (entryType = entry.getField(ENTRY_TYPE).getChar()) != 'I') continue;
                    int key = entry.getField(KEY_POSITION).getInt();
                    this.keyPosition = key >> 16;
                    this.keyLength = key & 0xFFFF;
                    Logger.getLogger(MainframeFile.class.getName()).log(Level.FINE, "File: {0} key position: {1} key length: {2}", new Object[]{this.file.getActualFilename(), this.keyPosition, this.keyLength});
                }
            }
            catch (RcException e) {
                if (e.getRc() != 4 || searcher.getRc() != 100) break block6;
                while (searcher.hasNext()) {
                    CatalogSearch.Entry entry = (CatalogSearch.Entry)searcher.next();
                    if (!entry.hasError()) continue;
                    System.out.println("Entry Exception: ENTRY_RC=" + entry.getRc() + ", ENTRY_Reason=" + entry.getReason());
                }
            }
        }
    }

    @Override
    public String getName() {
        return this.path;
    }

    @Override
    public void close() {
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (RcException | ZFileException ex) {
                Logger.getLogger(MainframeFile.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void checkException(ZFileException e) throws IOException, SQLException {
        String msg;
        if (e.getFeedbackFdbk() != 0 && (msg = MainframeSystemAbendCodes.getErrorCodeText(e.getFeedbackFdbk())) != null) {
            throw new IOException(msg);
        }
    }

    @Override
    public void updateRecord(byte[] data, int length) throws IOException, SQLException {
        if (this.readOnly) {
            throw new SQLException(String.format("Cannot update record: Data set %s is read-only, or associated tablespace is declared as read-only", this.path), "42807", -150);
        }
        try {
            this.file.update(data, 0, length);
        }
        catch (ZFileException e) {
            if (e.getLastOp() != 115 || e.getFeedbackFdbk() == 96) {
                // empty if block
            }
            this.checkException(e);
            throw e;
        }
    }

    @Override
    public void writeRecord(byte[] data, int length) throws IOException, SQLException {
        if (this.readOnly) {
            throw new SQLException(String.format("Cannot write record: Data set %s is read-only, or associated tablespace is declared as read-only", this.path), "42807", -150);
        }
        try {
            this.file.write(data, 0, length);
        }
        catch (ZFileException e) {
            this.checkException(e);
            throw new IOException("unable to write data (org. length: " + data.length + " write length: " + length + " to file " + this.path, e);
        }
    }

    @Override
    public int readRecord(byte[] data) throws IOException, BufferOverflowException, SQLException {
        if (this.file.getLrecl() > data.length) {
            throw new BufferOverflowException();
        }
        try {
            int rc = this.file.read(data);
            if (Logger.getLogger(MainframeFile.class.getName()).isLoggable(Level.FINEST)) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                HexDump.dump(data, 0L, bos, 0);
                Logger.getLogger(MainframeFile.class.getName()).log(Level.FINEST, "Read data: \n{0}", new String(bos.toByteArray()));
            }
            return rc;
        }
        catch (ZFileException ex) {
            this.checkException(ex);
            throw ex;
        }
    }

    @Override
    public int getMaximumRecordLength() {
        try {
            return this.file.getLrecl();
        }
        catch (ZFileException ex) {
            Logger.getLogger(MainframeFile.class.getName()).log(Level.SEVERE, null, ex);
            return -1;
        }
    }

    @Override
    public boolean locate(byte[] data) throws IOException, BufferOverflowException, SQLException {
        return this.file.locate(data, 3);
    }
}

