/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.file;

import com.ibm.jzos.RecordWriter;
import com.ibm.jzos.ZFile;
import de.ubs.jdbcserver.file.CsvFileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MainframeCsvFileWriter
implements CsvFileWriter {
    private RecordWriter rw;
    private Charset encoding;

    public MainframeCsvFileWriter(ZFile f, String filename, Charset encoding) throws IOException {
        Logger.getLogger(MainframeCsvFileWriter.class.getName()).log(Level.FINE, String.format("Creating MainframeCsvFileWriter for %s", f.getFilename()));
        this.encoding = encoding;
        this.rw = RecordWriter.newWriter(filename, 8);
    }

    @Override
    public void write(String s) throws IOException {
        String[] parts;
        Logger.getLogger(MainframeCsvFileWriter.class.getName()).log(Level.FINE, String.format("MainframeCsvFileWriter.write() called", new Object[0]));
        if (s == null || s.isEmpty()) {
            return;
        }
        if (s.endsWith(System.lineSeparator())) {
            s = s.substring(0, s.length() - System.lineSeparator().length());
        }
        for (String p : parts = s.split("\n")) {
            this.rw.write(p.getBytes(this.encoding));
        }
    }

    @Override
    public void close() throws IOException {
        this.rw.close();
    }
}

