/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.command.sql;

import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import de.ubs.jdbcserver.CatalogRepository;
import de.ubs.jdbcserver.RecordTransformer;
import de.ubs.jdbcserver.ScratchPadManager;
import de.ubs.jdbcserver.command.AbstractServerCommand;
import de.ubs.jdbcserver.command.UniqueConnectionIdentifier;
import de.ubs.jdbcserver.command.sql.ParameterValueData;
import de.ubs.jdbcserver.command.sql.PreparedDeleteContext;
import de.ubs.jdbcserver.command.sql.PreparedInsertContext;
import de.ubs.jdbcserver.command.sql.PreparedUpdateContext;
import de.ubs.jdbcserver.command.sql.VSAMImplicitPrimaryKeyBuilder;
import de.ubs.jdbcserver.cursor.AbstractCursor;
import de.ubs.jdbcserver.cursor.Cursor;
import de.ubs.jdbcserver.cursor.FileCursor;
import de.ubs.jdbcserver.cursor.IndexFileCursor;
import de.ubs.jdbcserver.cursor.SortedCursor;
import de.ubs.jdbcserver.cursor.VirtualCursor;
import de.ubs.jdbcserver.evaluation.ColumnDefinitionVisitor;
import de.ubs.jdbcserver.evaluation.ExpressionEvaluator;
import de.ubs.jdbcserver.file.FileManager;
import de.ubs.jdbcserver.file.ProcessableFile;
import de.ubs.jdbcserver.index.IndexUtils;
import de.ubs.jdbcserver.jdbccomm.StatementAction;
import de.ubs.jdbcserver.jdbccomm.struct.ColumnDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.Field;
import de.ubs.jdbcserver.jdbccomm.struct.Section;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.TablespaceLayout;
import de.ubs.jdbcserver.jdbccomm.struct.UserPermission;
import de.ubs.jdbcserver.jdbccomm.transport.Transportable;
import de.ubs.jdbcserver.jdbccomm.util.ClientSerializer;
import de.ubs.jdbcserver.jdbccomm.util.CommonUtils;
import de.ubs.jdbcserver.jdbccomm.util.Pair;
import de.ubs.jdbcserver.jdbccommons.FileType;
import de.ubs.jdbcserver.jdbccommons.SQLTypes;
import de.ubs.jdbcserver.jdbccommons.cobol.CobolParser;
import de.ubs.jdbcserver.jdbccommons.pl1.PL1Utils;
import de.ubs.jdbcserver.jdbccommons.pl1.PL1declException;
import de.ubs.jdbcserver.jdbccommons.sql.parser.SQLParserParser;
import de.ubs.jdbcserver.jdbccommons.sql.parser.StatementInformation;
import de.ubs.jdbcserver.jdbccommons.struct.CatalogManager;
import de.ubs.jdbcserver.jdbccommons.struct.DatabaseObjectFactory;
import de.ubs.jdbcserver.jdbccommons.struct.PermissionManager;
import de.ubs.jdbcserver.jdbccommons.struct.TablespaceDefinition;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import net.sf.cb2xml.sablecc.lexer.LexerException;
import net.sf.cb2xml.sablecc.parser.ParserException;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class StatementCommand
extends AbstractServerCommand {
    public StatementCommand(UniqueConnectionIdentifier connectionId, Document doc) {
        super(connectionId, doc);
    }

    private static char constantToChar(SQLParserParser.ConstantContext con) {
        return StatementCommand.constantToString(con).charAt(0);
    }

    private static String constantToString(SQLParserParser.ConstantContext con) {
        if (con.StringLiteral() != null) {
            return con.value.toString();
        }
        if (con.number() != null) {
            return con.value.toString();
        }
        throw new RuntimeException("Unsupported value for constant");
    }

    @Override
    public Element execute() throws Exception {
        Element root = this.doc.getRootElement();
        StatementAction action = StatementAction.valueOf(root.getAttributeValue("action"));
        switch (action) {
            case CLOSE: {
                return this.closeStatement(root);
            }
            case EXECUTE: {
                return this.executeStatement(root);
            }
            case UPDATE_PARAMETER: {
                return this.updateParameter(root);
            }
        }
        throw new RuntimeException("Unsupported statement action: " + (Object)((Object)action));
    }

    private Element updateParameter(Element root) throws IOException {
        UUID statementUUID = UUID.fromString(root.getAttributeValue("uuid"));
        UUID connectionUUID = UUID.fromString(root.getAttributeValue("connection-uuid"));
        ParameterValueData pvd = ScratchPadManager.getDefault().get(this.connectionId, statementUUID, ParameterValueData.class);
        if (pvd == null) {
            throw new RuntimeException("No parameter marker data provided");
        }
        Transportable t = ScratchPadManager.getDefault().get(this.connectionId, connectionUUID, Transportable.class);
        List values = (List)t.deserialize(root.getText());
        pvd.setValues(new LinkedList<Object[]>(values));
        Logger.getLogger(StatementCommand.class.getName()).log(Level.FINE, "Updated parameter values {0} for statement {1}", new Object[]{values.size(), statementUUID.toString()});
        return new Element("statement");
    }

    private Element closeStatement(Element root) throws IOException {
        UUID statementUUID = UUID.fromString(root.getAttributeValue("uuid"));
        Cursor cursor = ScratchPadManager.getDefault().get(this.connectionId, statementUUID, Cursor.class);
        if (cursor != null) {
            cursor.close();
            Logger.getLogger(StatementCommand.class.getName()).log(Level.FINE, "Closed cursor {0}", cursor.getName());
        }
        int count = ScratchPadManager.getDefault().removeAll(this.connectionId, statementUUID);
        Logger.getLogger(StatementCommand.class.getName()).log(Level.FINER, "Removed all ({0}) resources for statement {1}", new Object[]{count, statementUUID.toString()});
        return new Element("statement");
    }

    private Element executeStatement(Element root) throws IOException, SQLException, JDOMException {
        UUID statementUUID = UUID.fromString(root.getAttributeValue("uuid"));
        StatementInformation statementInformation = ScratchPadManager.getDefault().get(this.connectionId, statementUUID, StatementInformation.class);
        SQLParserParser.StatementContext statementContext = statementInformation.getStatementInformation();
        if (statementContext.createStatement() != null) {
            SQLParserParser.CreateStatementContext createStatement = statementContext.createStatement();
            if (createStatement.createTable() != null) {
                return this.createTableStatement(createStatement.createTable());
            }
            if (createStatement.createTablespace() != null) {
                return this.createTablespaceStatement(createStatement.createTablespace());
            }
            throw new RuntimeException("Unsupported CREATE statement type");
        }
        if (statementContext.dropStatement() != null) {
            SQLParserParser.DropStatementContext dropStatement = statementContext.dropStatement();
            if (dropStatement.dropTable() != null) {
                return this.dropTableStatement(dropStatement.dropTable());
            }
            if (dropStatement.dropTablespace() != null) {
                return this.dropTablespaceStatement(dropStatement.dropTablespace());
            }
            throw new RuntimeException("Unsupported DROP statement type");
        }
        if (statementContext.deleteStatement() != null) {
            return this.processDeleteStatement(statementUUID);
        }
        if (statementContext.insertStatement() != null) {
            return this.processInsertStatement(statementUUID);
        }
        if (statementContext.selectStatement() != null) {
            return this.processSelectStatement(statementInformation, statementUUID);
        }
        if (statementContext.updateStatement() != null) {
            return this.processUpdateStatement(statementUUID);
        }
        if (statementContext.grantStatement() != null) {
            return this.processGrantStatement(statementInformation);
        }
        if (statementContext.alterTable() != null) {
            return this.processAlterTableStatement(statementInformation);
        }
        if (statementContext.alterTablespace() != null) {
            return this.processAlterTablespaceStatement(statementInformation);
        }
        throw new RuntimeException("Unsupported statement " + statementContext.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Element processSelectStatement(StatementInformation statementInformation, UUID statementUUID) throws SQLException, IOException {
        UUID resultSetUUID = UUID.randomUUID();
        Cursor cursor = null;
        String tableName = statementInformation.getTableName();
        String schema = statementInformation.getTableSchema();
        TableDefinition tableDefinition = statementInformation.getTable();
        ParameterValueData parameterValueData = new ParameterValueData();
        ScratchPadManager.getDefault().put(this.connectionId, statementUUID, parameterValueData);
        ExpressionEvaluator<Boolean> ee = null;
        if (statementInformation.getWhereCondition() != null) {
            ee = new ExpressionEvaluator<Boolean>(tableDefinition, parameterValueData, statementInformation.getWhereCondition());
        }
        if (schema.equalsIgnoreCase("SYSUBS")) {
            cursor = CatalogRepository.createVirtualCursor(tableDefinition, tableName, ee);
        } else {
            ProcessableFile file;
            TablespaceDefinition tablespace = CatalogManager.getDefault().getTablespace(tableDefinition.getTablespaceName());
            SQLParserParser.SelectStatementContext selectStatement = statementInformation.getStatementInformation().selectStatement();
            SQLParserParser.WhereClauseContext whereClauseCtx = selectStatement.whereClause();
            SQLParserParser.OrderByClauseContext orderByClauseCtx = selectStatement.orderByClause();
            String fileName = tablespace.getLayout().getFileName();
            Logger.getLogger(StatementCommand.class.getName()).log(Level.FINE, "Opening file {0}", fileName);
            switch (tablespace.getTablespaceType()) {
                case VSAM: {
                    file = FileManager.getDefault().open(fileName, "rb,type=record", FileType.VSAM_KSDS, tablespace, tableDefinition);
                    break;
                }
                case CSV: {
                    file = FileManager.getDefault().open(fileName, "rb,type=record", FileType.PLAINTEXT_CSV, tablespace, tableDefinition);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid file type " + tablespace.getTablespaceType().toString());
                }
            }
            if (tablespace.getTablespaceType() == TablespaceDefinition.TablespaceType.VSAM) {
                IndexUtils indexUtils = new IndexUtils();
                Boolean indexUsagePossible = indexUtils.isIndexAccessPossible(tablespace.getLayout(), statementInformation);
                Logger.getLogger(StatementCommand.class.getName()).log(Level.FINE, "Check for index usage for query was {0}", indexUsagePossible == false ? " not successful" : " successful");
                boolean thresholdExceeded = true;
                int recordCount = 0;
                if (!indexUsagePossible.booleanValue()) {
                    recordCount = file.getRecordCount();
                    Logger.getLogger(StatementCommand.class.getName()).log(Level.FINE, "Record count of {0} is {1}", new Object[]{tablespace.getLayout().getFileName(), recordCount});
                    if (-1 != tablespace.getMinThreshold()) {
                        boolean bl = thresholdExceeded = recordCount > tablespace.getMinThreshold();
                    }
                }
                if (recordCount == -1) {
                    cursor = new VirtualCursor(tableDefinition);
                } else if (indexUsagePossible.booleanValue()) {
                    cursor = new IndexFileCursor(tablespace, tableDefinition, file, statementInformation);
                } else if (orderByClauseCtx != null || selectStatement.DISTINCT() != null || whereClauseCtx != null && tablespace.isUseDfsortAccess() && thresholdExceeded) {
                    cursor = new SortedCursor(tablespace.getLayout(), tableDefinition, statementInformation, recordCount, file.getMaximumRecordLength(), file.isVariableLength());
                    FileManager.getDefault().close(file.getUUID());
                } else {
                    if (orderByClauseCtx != null) throw new SQLException("ORDER BY is only possible if DFSORT access is allowed", "42612", -84);
                    cursor = new FileCursor(tablespace, tableDefinition, file);
                }
            } else {
                cursor = new FileCursor(tablespace, tableDefinition, file);
            }
        }
        if (ee != null) {
            cursor.updateFilter(ee);
        }
        if (statementInformation.getMaxRowsToFetch() >= 0L) {
            cursor.setMaxRowsToFetch(statementInformation.getMaxRowsToFetch());
        }
        ScratchPadManager.getDefault().put(this.connectionId, resultSetUUID, cursor);
        ScratchPadManager.getDefault().put(this.connectionId, resultSetUUID, new RecordTransformer(statementInformation, tableDefinition));
        Element result = new Element("statement");
        result.setAttribute("uuid", resultSetUUID.toString());
        result.addContent(ClientSerializer.toXML(this.adaptTableDefinitionForSelect(tableDefinition, statementInformation)));
        return result;
    }

    private TableDefinition adaptTableDefinitionForSelect(TableDefinition td, StatementInformation statementInformation) throws SQLException {
        if (statementInformation.getStatementInformation().selectStatement().STAR() != null) {
            return td;
        }
        TableDefinition tableDefinition = new TableDefinition(td.getSchema(), td.getName());
        List<SQLParserParser.ColRefContext> list = statementInformation.getStatementInformation().selectStatement().colRef();
        for (int i = 0; i < list.size(); ++i) {
            SQLParserParser.ColRefContext colRef = list.get(i);
            String columnName = statementInformation.getReferencedColumnList().get(i).getName();
            ColumnDefinitionVisitor cdv = new ColumnDefinitionVisitor(td, columnName);
            ColumnDefinition cd = cdv.getColumnDefinitionFor(colRef);
            if (colRef.label() != null) {
                cd.setLabel(colRef.label().identifier().value);
            }
            tableDefinition.getColumns().add(cd);
        }
        return tableDefinition;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Element createTablespaceStatement(SQLParserParser.CreateTablespaceContext ctx) throws IOException, SQLException {
        String fileName = ctx.fileName().fileNameStr;
        Logger.getLogger(StatementCommand.class.getName()).log(Level.INFO, "Processing CREATE TABLESPACE statement, type {0}, tablespace name {1}, file name {2}", new Object[]{ctx.CSV() == null ? "VSAM" : "CSV", ctx.identifier().value.toUpperCase(), fileName});
        PermissionManager.getDefault().checkPermission(this.user, UserPermission.Action.CREATE_TABLESPACE);
        TablespaceDefinition tablespaceDefinition = DatabaseObjectFactory.create(ctx, this.user);
        if (ctx.tablespaceDescriptionClause() != null) {
            String descriptionFile = ctx.tablespaceDescriptionClause().fileName().fileNameStr;
            if (CommonUtils.isZos() && !ZFile.exists(String.format("//'%s'", descriptionFile)) && !ZFile.ddExists(descriptionFile) && !new File(descriptionFile).exists()) {
                throw new SQLException("Failed to open descriptor file " + descriptionFile, "57011", -904);
            }
        }
        if (CommonUtils.isZos() && !fileName.startsWith(File.separator)) {
            fileName = fileName.toUpperCase();
        }
        if (CommonUtils.isZos()) {
            if (tablespaceDefinition.getTablespaceType() == TablespaceDefinition.TablespaceType.CSV) {
                if (fileName.startsWith(File.separator)) {
                    if (!Files.exists(new File(fileName).toPath(), new LinkOption[0])) {
                        Logger.getLogger(StatementCommand.class.getName()).log(Level.FINE, "CSV file {0} associated with tablespace {1} does not exist, will be created", new Object[]{fileName, tablespaceDefinition.getName()});
                    }
                } else if (!ZFile.exists(String.format("//'%s'", fileName))) {
                    throw new SQLException("Failed to open CSV input dataset " + fileName, "57011", -904);
                }
            } else if (!ZFile.exists(String.format("//'%s'", fileName))) {
                throw new SQLException("Failed to open input dataset " + fileName, "57011", -904);
            }
        } else if (tablespaceDefinition.getTablespaceType() == TablespaceDefinition.TablespaceType.CSV) {
            if (!Files.exists(new File(fileName).toPath(), new LinkOption[0])) {
                Logger.getLogger(StatementCommand.class.getName()).log(Level.FINE, "CSV file {0} associated with tablespace {1} does not exist, will be created", new Object[]{fileName, tablespaceDefinition.getName()});
            }
        } else {
            if (!new File(fileName).exists()) {
                throw new SQLException("Failed to open input file " + new File(fileName).getAbsolutePath(), "57011", -904);
            }
            if (!Files.exists(new File(fileName).toPath(), new LinkOption[0])) {
                Logger.getLogger(StatementCommand.class.getName()).log(Level.FINE, "CSV file {0} associated with tablespace {1} does not exist, will be created", new Object[]{fileName, tablespaceDefinition.getName()});
            }
        }
        TablespaceLayout descriptor = null;
        if (ctx.tablespaceDescriptionClause() != null) {
            if (ctx.tablespaceDescriptionClause().COBOL() != null) {
                descriptor = this.readCobolStructure(ctx.tablespaceDescriptionClause());
            } else {
                if (ctx.tablespaceDescriptionClause().PL1() == null) throw new RuntimeException("Unsupported language for create tablespace");
                descriptor = this.readPl1Structure(ctx.tablespaceDescriptionClause());
            }
        } else {
            descriptor = tablespaceDefinition.getLayout();
        }
        SQLParserParser.EncodingSpecContext encodingSpecContext = ctx.fileName().encodingSpec();
        if (encodingSpecContext != null) {
            String encodingName = StringUtils.strip(encodingSpecContext.StringLiteral().getText(), "'");
            try {
                descriptor.setDefaultStringEncoding(encodingName);
            }
            catch (UnsupportedCharsetException ex) {
                throw new SQLException(String.format("The encoding %s is invalid", encodingName), "22522", -189);
            }
            tablespaceDefinition.setStrictEncoding(encodingSpecContext.STRICT() != null);
        }
        tablespaceDefinition.setLayout(descriptor);
        descriptor.setFileName(fileName);
        String newName = CatalogManager.getDefault().createTablespace(tablespaceDefinition);
        Element result = new Element("create");
        result.setAttribute("type", "tablespace");
        result.setAttribute("name", newName);
        return result;
    }

    private TablespaceLayout readPl1Structure(SQLParserParser.TablespaceDescriptionClauseContext ctx) throws IOException, SQLException {
        String descriptionFile = ctx.fileName().fileNameStr.toUpperCase();
        List<String> lines = this.readMemberContent(ctx.fileName().encodingSpec(), descriptionFile);
        Logger.getLogger(StatementCommand.class.getName()).log(Level.FINE, "Read PL1 declaration: {0}", StringUtils.join(lines, "\n"));
        try {
            Section startSection = PL1Utils.getInstance().parseItems(lines);
            TablespaceLayout descriptor = new TablespaceLayout();
            descriptor.setStartSection(startSection);
            return descriptor;
        }
        catch (PL1declException e) {
            throw new SQLException("Failed to parse PL/1 structure: " + e.getMessage(), "42601", -104);
        }
    }

    private TablespaceLayout readCobolStructure(SQLParserParser.TablespaceDescriptionClauseContext ctx) throws IOException, ZFileException, SQLException {
        String descriptionFile = ctx.fileName().fileNameStr.toUpperCase();
        List<String> lines = this.readMemberContent(ctx.fileName().encodingSpec(), descriptionFile);
        StringBuilder content = new StringBuilder();
        for (String line : lines) {
            if (line.length() > 8) {
                boolean isLineNumbering = true;
                for (int i = line.length() - 8; i < line.length(); ++i) {
                    if (Character.isDigit(line.charAt(i))) continue;
                    isLineNumbering = false;
                }
                if (isLineNumbering) {
                    line = line.substring(0, line.length() - 8);
                }
            }
            for (SQLParserParser.ReplacingClauseContext replacingClause : ctx.replacingClause()) {
                String unescaped;
                String searchStr = unescaped = StringUtils.strip(replacingClause.StringLiteral(0).getText(), "'");
                if (!unescaped.startsWith(":") && !unescaped.endsWith(":")) {
                    searchStr = replacingClause.StringLiteral(0).getText();
                }
                String replaceStr = StringUtils.strip(replacingClause.StringLiteral(1).getText(), "'");
                line = StringUtils.replace(line, searchStr, replaceStr);
            }
            content.append(line).append("\n");
        }
        for (SQLParserParser.ReplacingClauseContext replacingClause : ctx.replacingClause()) {
            String searchStr = StringUtils.strip(replacingClause.StringLiteral(0).getText(), "'");
            String replaceStr = StringUtils.strip(replacingClause.StringLiteral(1).getText(), "'");
            Logger.getLogger(StatementCommand.class.getName()).log(Level.FINE, "Replaced {0} by {1}", new Object[]{searchStr, replaceStr});
        }
        try {
            TablespaceLayout descriptor = new CobolParser().parse(content.toString(), false);
            Logger.getLogger(DatabaseObjectFactory.class.getName()).log(Level.FINE, "Read and parsed cobol copybook {0}", descriptionFile);
            return descriptor;
        }
        catch (JAXBException | LexerException | ParserException ex) {
            Logger.getLogger(StatementCommand.class.getName()).log(Level.FINE, null, ex);
            throw new SQLException("Failed to parse copy book: " + ex.getMessage(), "42601", -104);
        }
    }

    private List<String> readMemberContent(SQLParserParser.EncodingSpecContext encoding, String descriptionFile) throws IOException {
        List<String> lines = null;
        Charset charset = encoding != null ? Charset.forName(StringUtils.strip(encoding.StringLiteral().getText(), "'")) : Charset.defaultCharset();
        Logger.getLogger(StatementCommand.class.getName()).log(Level.FINE, "Reading description file {0} with encoding {1}", new Object[]{descriptionFile, charset.toString()});
        if (CommonUtils.isZos()) {
            ZFile zfile = null;
            String fileName = String.format("//'%s'", descriptionFile);
            if (ZFile.exists(fileName)) {
                zfile = new ZFile(fileName, "r");
            } else if (ZFile.ddExists(fileName)) {
                zfile = new ZFile(descriptionFile, "r");
            } else {
                throw new RuntimeException("File " + descriptionFile + " does not exist");
            }
            try (InputStream in = zfile.getInputStream();){
                lines = IOUtils.readLines(in, charset);
            }
        } else {
            lines = FileUtils.readLines(new File(descriptionFile), charset);
        }
        return lines;
    }

    private void addPrimaryKey(TablespaceLayout layout, TableDefinition tableDefinition, int keylength, int keystart) {
        VSAMImplicitPrimaryKeyBuilder builder = new VSAMImplicitPrimaryKeyBuilder();
        List<Pair<ColumnDefinition, Field>> buildImplicitPrimaryKey = builder.buildImplicitPrimaryKey(tableDefinition, keystart, keylength, layout);
        builder.applyPrimaryKey(buildImplicitPrimaryKey, tableDefinition);
    }

    private Element createTableStatement(SQLParserParser.CreateTableContext ctx) throws JDOMException, IOException, SQLException {
        PermissionManager.getDefault().checkPermission(this.user, UserPermission.Action.CREATE_TABLE);
        Pair<TablespaceDefinition, TableDefinition> pair = DatabaseObjectFactory.create(ctx, this.user);
        if (pair.first().getTablespaceType() == TablespaceDefinition.TablespaceType.VSAM) {
            String fileName = pair.first().getLayout().getFileName();
            ProcessableFile file = null;
            try {
                file = FileManager.getDefault().open(fileName, "rb,type=record", FileType.VSAM_KSDS, pair.first(), pair.second());
            }
            catch (IOException | SQLException ex) {
                file = FileManager.getDefault().open(fileName, "a+b,type=record", FileType.VSAM_KSDS, pair.first(), pair.second());
            }
            int keylength = file.getKeyLength();
            int keystart = file.getKeyStartOffset();
            FileManager.getDefault().close(file.getUUID());
            if (keylength != -1 && keystart != -1) {
                this.addPrimaryKey(pair.first().getLayout(), pair.second(), keylength, keystart);
            }
        }
        CatalogManager.getDefault().createTable(pair.first(), pair.second());
        Element result = new Element("create");
        result.setAttribute("type", "table");
        result.setAttribute("schema", pair.second().getSchema());
        result.setAttribute("name", pair.second().getName());
        return result;
    }

    private Element dropTableStatement(SQLParserParser.DropTableContext ctx) throws SQLException, IOException {
        PermissionManager.getDefault().checkPermission(this.user, UserPermission.Action.DROP_TABLE);
        String schema = ctx.schema().identifier().value;
        String name = ctx.name().identifier().value;
        if (schema.equalsIgnoreCase("SYSUBS")) {
            throw new SQLException("Operation DROP TABLE is not defined for directory tables", "42832", -607);
        }
        CatalogManager.getDefault().dropTable(schema, name);
        Element result = new Element("drop");
        result.setAttribute("type", "table");
        return result;
    }

    private Element dropTablespaceStatement(SQLParserParser.DropTablespaceContext ctx) throws SQLException, IOException {
        TablespaceDefinition tablespace;
        PermissionManager.getDefault().checkPermission(this.user, UserPermission.Action.DROP_TABLESPACE);
        String tablespaceName = null;
        if (null != ctx.identifier()) {
            tablespaceName = ctx.identifier().value.toUpperCase();
            if (tablespaceName.equalsIgnoreCase("SYS")) {
                throw new SQLException("Operation DROP TABLESPACE is not defined for directory tablespaces", "42832", -607);
            }
        } else if (null != ctx.fileName() && (tablespaceName = CatalogManager.getDefault().getTablespaceNameForFile(ctx.fileName().fileNameStr)) == null) {
            SQLException e = new SQLException("The tablespace with file " + ctx.fileName().fileNameStr + " is not defined", "42704", -204);
            Logger.getLogger(StatementCommand.class.getName()).log(Level.FINE, e.getMessage(), e);
            throw e;
        }
        String fileToDelete = null;
        if (ctx.PURGE() != null && (tablespace = CatalogManager.getDefault().getTablespace(tablespaceName)) != null && tablespace.getTablespaceType() == TablespaceDefinition.TablespaceType.CSV) {
            fileToDelete = tablespace.getLayout().getFileName();
        }
        CatalogManager.getDefault().dropTablespace(tablespaceName);
        if (fileToDelete != null) {
            try {
                FileManager.getDefault().deleteFile(fileToDelete);
            }
            catch (IOException ex) {
                Logger.getLogger(StatementCommand.class.getName()).log(Level.WARNING, "Tablespace {0} was dropped but associated file {1} could not be deleted", new Object[]{tablespaceName, fileToDelete});
            }
        }
        Element e = new Element("drop");
        e.setAttribute("type", "tablespace");
        e.setAttribute("name", tablespaceName);
        return e;
    }

    private Element processInsertStatement(UUID statementUUID) throws SQLException, IOException {
        ParameterValueData pvd = ScratchPadManager.getDefault().get(this.connectionId, statementUUID, ParameterValueData.class);
        Cursor cursor = ScratchPadManager.getDefault().get(this.connectionId, statementUUID, Cursor.class);
        PreparedInsertContext ctx = ScratchPadManager.getDefault().get(this.connectionId, statementUUID, PreparedInsertContext.class);
        ctx.getVisitor().getVisitor().setParameterMarkerContents(pvd);
        ctx.resetStatus();
        boolean[] isPlainMarker = new boolean[ctx.getColumnCount()];
        for (int i = 0; i < ctx.getColumnCount(); ++i) {
            isPlainMarker[i] = ctx.getInsertCtx().sum(i).getText().equals("?");
        }
        boolean process = true;
        do {
            try {
                for (int i = 0; i < ctx.getColumnCount(); ++i) {
                    if (!isPlainMarker[i]) {
                        ctx.setColumn(i, ctx.getVisitor().evaluate(ctx.getInsertCtx().sum(i)));
                        continue;
                    }
                    ctx.setColumn(i, pvd.getLatestValues()[i]);
                }
                cursor.insert(ctx.getData());
                ctx.getRcs().add(1);
            }
            catch (SQLException e) {
                ctx.addException(e);
            }
            if (pvd != null && !pvd.getValues().isEmpty()) {
                pvd.getValues().remove(0);
                process = !pvd.getValues().isEmpty();
                continue;
            }
            process = false;
        } while (process);
        return ctx.buildReplayTag("insert");
    }

    private Element processDeleteStatement(UUID statementUUID) throws SQLException, IOException {
        ParameterValueData pvd = ScratchPadManager.getDefault().get(this.connectionId, statementUUID, ParameterValueData.class);
        AbstractCursor cursor = ScratchPadManager.getDefault().get(this.connectionId, statementUUID, AbstractCursor.class);
        PreparedDeleteContext ctx = ScratchPadManager.getDefault().get(this.connectionId, statementUUID, PreparedDeleteContext.class);
        ExpressionEvaluator<Object> visitor = ctx.getVisitor();
        visitor.getVisitor().setParameterMarkerContents(pvd);
        ctx.resetStatus();
        if (cursor.getConditionEvaluator() != null) {
            cursor.getConditionEvaluator().getVisitor().setParameterMarkerContents(pvd);
        }
        boolean process = true;
        do {
            cursor.reset();
            try {
                int deletedRows;
                block9: {
                    deletedRows = 0;
                    try {
                        Object[] data;
                        while ((data = cursor.next()) != null) {
                            for (Map.Entry<String, Integer> entry : visitor.getReferencedWhereColumns().entrySet()) {
                                visitor.setValue(entry.getKey(), (Comparable)data[entry.getValue()]);
                            }
                            if (!cursor.delete()) continue;
                            ++deletedRows;
                        }
                    }
                    catch (IOException ex) {
                        if (ex.getMessage().toLowerCase().contains("trying to update an empty dataset")) break block9;
                        throw ex;
                    }
                }
                ctx.getRcs().add(deletedRows);
            }
            catch (SQLException e) {
                ctx.addException(e);
            }
            if (pvd != null && !pvd.getValues().isEmpty()) {
                pvd.getValues().remove(0);
                process = !pvd.getValues().isEmpty();
                continue;
            }
            process = false;
        } while (process);
        return ctx.buildReplayTag("delete");
    }

    private Element processUpdateStatement(UUID statementUUID) throws SQLException, IOException {
        ParameterValueData pvd = ScratchPadManager.getDefault().get(this.connectionId, statementUUID, ParameterValueData.class);
        AbstractCursor cursor = ScratchPadManager.getDefault().get(this.connectionId, statementUUID, AbstractCursor.class);
        PreparedUpdateContext ctx = ScratchPadManager.getDefault().get(this.connectionId, statementUUID, PreparedUpdateContext.class);
        ExpressionEvaluator<Object> visitor = ctx.getVisitor();
        visitor.getVisitor().setParameterMarkerContents(pvd);
        ctx.resetStatus();
        if (cursor.getConditionEvaluator() != null) {
            cursor.getConditionEvaluator().getVisitor().setParameterMarkerContents(pvd);
        }
        boolean process = true;
        do {
            cursor.reset();
            try {
                int updatedRows;
                block9: {
                    updatedRows = 0;
                    try {
                        Object[] data;
                        while ((data = cursor.next()) != null) {
                            for (Map.Entry<String, Integer> entry : visitor.getReferencedWhereColumns().entrySet()) {
                                visitor.setValue(entry.getKey(), (Comparable)data[entry.getValue()]);
                            }
                            ctx.updateData(data);
                            cursor.update(data);
                            ++updatedRows;
                        }
                    }
                    catch (IOException ex) {
                        if (ex.getMessage().toLowerCase().contains("trying to update an empty dataset")) break block9;
                        throw ex;
                    }
                }
                ctx.getRcs().add(updatedRows);
            }
            catch (SQLException e) {
                ctx.addException(e);
            }
            if (pvd != null && !pvd.getValues().isEmpty()) {
                pvd.getValues().remove(0);
                process = !pvd.getValues().isEmpty();
                continue;
            }
            process = false;
        } while (process);
        return ctx.buildReplayTag("update");
    }

    private Element processGrantStatement(StatementInformation si) throws SQLException {
        block25: {
            SQLParserParser.GrantStatementContext grantStatement;
            block27: {
                String grantor;
                block26: {
                    block24: {
                        grantStatement = si.getStatementInformation().grantStatement();
                        grantor = this.user.toUpperCase();
                        if (grantStatement.grantTable() == null) break block24;
                        TableDefinition td = si.getTable();
                        for (SQLParserParser.UserSpecContext userSpec : grantStatement.grantTable().userSpecs().userSpec()) {
                            String grantee = userSpec.ID().getText().toUpperCase();
                            if (grantStatement.grantTable().ALL() != null) {
                                PermissionManager.getDefault().grantDelete(td, grantor, grantee);
                                PermissionManager.getDefault().grantInsert(td, grantor, grantee);
                                PermissionManager.getDefault().grantUpdate(td, grantor, grantee);
                                PermissionManager.getDefault().grantSelect(td, grantor, grantee);
                                continue;
                            }
                            for (SQLParserParser.TablePermissionContext tp : grantStatement.grantTable().tablePermission()) {
                                if (tp.DELETE() != null) {
                                    PermissionManager.getDefault().grantDelete(td, grantor, grantee);
                                    continue;
                                }
                                if (tp.UPDATE() != null) {
                                    PermissionManager.getDefault().grantUpdate(td, grantor, grantee);
                                    continue;
                                }
                                if (tp.SELECT() != null) {
                                    PermissionManager.getDefault().grantSelect(td, grantor, grantee);
                                    continue;
                                }
                                if (tp.INSERT() == null) continue;
                                PermissionManager.getDefault().grantInsert(td, grantor, grantee);
                            }
                        }
                        break block25;
                    }
                    if (grantStatement.grantUser() == null) break block26;
                    for (SQLParserParser.UserPermissionContext userPermission : grantStatement.grantUser().userPermission()) {
                        for (SQLParserParser.UserSpecContext userSpec : grantStatement.grantUser().userSpecs().userSpec()) {
                            String grantee = userSpec.ID().getText().toUpperCase();
                            if (null != userPermission.SYSADM()) {
                                PermissionManager.getDefault().grantSysadm(grantor, grantee);
                                continue;
                            }
                            if (userPermission.CREATETB() != null) {
                                PermissionManager.getDefault().grantCreateTable(grantor, grantee);
                                continue;
                            }
                            if (userPermission.CREATETS() != null) {
                                PermissionManager.getDefault().grantCreateTablespace(grantor, grantee);
                                continue;
                            }
                            if (userPermission.DROPTB() != null) {
                                PermissionManager.getDefault().grantDropTable(grantor, grantee);
                                continue;
                            }
                            if (userPermission.DROPTS() == null) continue;
                            PermissionManager.getDefault().grantDropTablespace(grantor, grantee);
                        }
                    }
                    break block25;
                }
                if (grantStatement.revokeTable() == null) break block27;
                String tableName = grantStatement.grantTable().name().identifier().value;
                String tableSchema = grantStatement.grantTable().schema().identifier().value;
                TableDefinition td = CatalogManager.getDefault().getTableDefinition(tableSchema, tableName);
                for (SQLParserParser.UserSpecContext userSpec : grantStatement.revokeTable().userSpecs().userSpec()) {
                    String grantee = userSpec.ID().getText().toUpperCase();
                    if (grantStatement.revokeTable().ALL() != null) {
                        PermissionManager.getDefault().revokeDelete(td, grantor, grantee);
                        PermissionManager.getDefault().revokeInsert(td, grantor, grantee);
                        PermissionManager.getDefault().revokeUpdate(td, grantor, grantee);
                        PermissionManager.getDefault().revokeSelect(td, grantor, grantee);
                        continue;
                    }
                    for (SQLParserParser.TablePermissionContext tp : grantStatement.revokeTable().tablePermission()) {
                        if (tp.DELETE() != null) {
                            PermissionManager.getDefault().revokeDelete(td, grantor, grantee);
                            continue;
                        }
                        if (tp.UPDATE() != null) {
                            PermissionManager.getDefault().revokeUpdate(td, grantor, grantee);
                            continue;
                        }
                        if (tp.SELECT() != null) {
                            PermissionManager.getDefault().revokeSelect(td, grantor, grantee);
                            continue;
                        }
                        if (tp.INSERT() == null) continue;
                        PermissionManager.getDefault().revokeInsert(td, grantor, grantee);
                    }
                }
                break block25;
            }
            if (grantStatement.revokeUser() == null) break block25;
            for (SQLParserParser.UserPermissionContext userPermission : grantStatement.revokeUser().userPermission()) {
                for (SQLParserParser.UserSpecContext userSpec : grantStatement.revokeUser().userSpecs().userSpec()) {
                    String grantee = userSpec.ID().getText().toUpperCase();
                    if (null != userPermission.SYSADM()) {
                        PermissionManager.getDefault().revokeSysadm(grantee, grantee);
                        continue;
                    }
                    if (userPermission.CREATETB() != null) {
                        PermissionManager.getDefault().revokeCreateTable(grantee, grantee);
                        continue;
                    }
                    if (userPermission.CREATETS() != null) {
                        PermissionManager.getDefault().revokeCreateTablespace(grantee, grantee);
                        continue;
                    }
                    if (userPermission.DROPTB() != null) {
                        PermissionManager.getDefault().revokeDropTable(grantee, grantee);
                        continue;
                    }
                    if (userPermission.DROPTS() == null) continue;
                    PermissionManager.getDefault().revokeDropTablespace(grantee, grantee);
                }
            }
        }
        return new Element("grant").setText("1");
    }

    private Element processAlterTableStatement(StatementInformation statementInformation) throws SQLException, IOException {
        TableDefinition table = statementInformation.getTable();
        if (table.getSchema().equalsIgnoreCase("SYSUBS")) {
            throw new SQLException("Operation ALTER TABLE is not defined for directory tables", "42832", -607);
        }
        SQLParserParser.AlterTableContext alterTable = statementInformation.getStatementInformation().alterTable();
        if (alterTable.identifier() != null) {
            String columnName = alterTable.identifier().value;
            ColumnDefinition cd = table.getColumnDefinition(columnName);
            if (cd == null) {
                throw new SQLException(String.format("%s is not a column of table %s.%s", columnName, table.getSchema(), table.getName()), "42703", -205);
            }
            String typeName = alterTable.typeSpec().ID().getText().toUpperCase();
            try {
                SQLTypes valueOf = SQLTypes.valueOf(typeName);
                cd.setTypeName(typeName);
            }
            catch (Exception e) {
                throw new SQLException("Invalid column data type specified: " + typeName, "42815", -171);
            }
            cd.setLength(alterTable.typeSpec().number().size() > 0 ? Integer.parseInt(alterTable.typeSpec().number(0).getText()) : 0);
            cd.setScale(alterTable.typeSpec().number().size() > 1 ? Integer.parseInt(alterTable.typeSpec().number(1).getText()) : 0);
        } else if (alterTable.whenCondition() != null) {
            table.setWhenCondition(DatabaseObjectFactory.getDisjunctionText(alterTable.whenCondition().disjunction()));
        }
        CatalogManager.getDefault().updateTable(table);
        Element result = new Element("alter");
        result.setAttribute("type", "table");
        result.setAttribute("schema", table.getSchema());
        result.setAttribute("name", table.getName());
        return result;
    }

    private Element processAlterTablespaceStatement(StatementInformation statementInformation) throws IOException, SQLException {
        SQLParserParser.AlterTablespaceContext ctx = statementInformation.getStatementInformation().alterTablespace();
        String tablespaceName = ctx.identifier().value.toUpperCase();
        if (tablespaceName.equalsIgnoreCase("SYS")) {
            throw new SQLException("Operation DROP TABLESPACE is not defined for directory tablespaces", "42832", -607);
        }
        TablespaceDefinition ts = CatalogManager.getDefault().getTablespace(tablespaceName);
        if (ts == null) {
            throw new SQLException(String.format("%s is an undefined name", tablespaceName), "42704", -204);
        }
        if (ctx.dfsortClause() != null) {
            ts.setUseDfsortAccess(true);
            if (ctx.dfsortClause().THRESHOLD() != null) {
                ts.setMinThreshold(Integer.valueOf(ctx.dfsortClause().number().getText()));
            }
            LinkedList<String> options = new LinkedList<String>();
            for (TerminalNode opt : ctx.dfsortClause().StringLiteral()) {
                options.add(StringUtils.strip(opt.getText(), "'"));
            }
            ts.setDfsortOptions(StringUtils.join(options, ","));
        } else if (ctx.DEACTIVATE() != null) {
            ts.setDfsortOptions(null);
            ts.setMinThreshold(-1);
            ts.setUseDfsortAccess(false);
        } else if (ctx.tablespaceDescriptionClause() != null) {
            TablespaceLayout layout = this.readCobolStructure(ctx.tablespaceDescriptionClause());
            ts.getLayout().setStartSection(layout.getStartSection());
        } else if (ctx.fileName() != null) {
            ts.getLayout().setFileName(ctx.fileName().fileNameStr);
        }
        if (ts.getTablespaceType() == TablespaceDefinition.TablespaceType.CSV) {
            DatabaseObjectFactory.applyCsvTablespaceAttributes(ts, ctx.csvOptions());
        }
        CatalogManager.getDefault().updateTablespace(ts);
        Element result = new Element("alter");
        result.setAttribute("type", "tablespace");
        result.setAttribute("name", ts.getName());
        return result;
    }
}

