/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.accessor.mainframe;

import de.ubs.jdbcserver.accessor.AbstractDataAccessor;
import de.ubs.jdbcserver.jdbccomm.struct.Field;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.text.DecimalFormat;
import org.apache.commons.lang3.StringUtils;

public class ExternalDecimalAccessor
extends AbstractDataAccessor<BigDecimal> {
    private static final BigDecimal ZERO_POINT_ONE = new BigDecimal("0.1");
    private final Charset charset;
    private final DecimalFormat formatter;

    public ExternalDecimalAccessor(int position, Field item, Charset charset) {
        super(item, position);
        this.charset = charset;
        StringBuilder pattern = new StringBuilder();
        pattern.append(StringUtils.repeat("0", item.getLength() - item.getScale()));
        if (item.getScale() > 0) {
            pattern.append(".");
            pattern.append(StringUtils.repeat("0", item.getScale()));
        }
        this.formatter = new DecimalFormat(pattern.toString());
    }

    @Override
    public BigDecimal get(byte[] input, int offset) throws SQLException {
        String str = new String(input, this.position + offset, this.field.getLength(), this.charset);
        BigDecimal decimal = new BigDecimal(str);
        if (this.field.isImpliedDecimalPoint() && this.field.getScale() > 0) {
            decimal.multiply(ZERO_POINT_ONE.pow(this.field.getScale()));
        }
        return decimal;
    }

    @Override
    public void put(BigDecimal data, byte[] output, int offset) throws SQLException {
        byte[] bytes = this.formatter.format(data).getBytes(this.charset);
        System.arraycopy(bytes, 0, output, this.position + offset, this.field.getLength());
    }
}

