/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.driver;

import de.ubs.jdbcserver.driver.UBSConnection;
import de.ubs.jdbcserver.driver.UBSStatement;
import de.ubs.jdbcserver.jdbccomm.StatementAction;
import de.ubs.jdbcserver.jdbccomm.transport.Transportable;
import de.ubs.jdbcserver.jdbccomm.util.ComparableByteArray;
import de.ubs.jdbcserver.jdbccomm.util.XmlUtils;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jdom2.Element;

public class UBSPreparedStatement
extends UBSStatement
implements PreparedStatement {
    private final boolean isSelectStatement;
    private final ArrayList<Object[]> parameterValues = new ArrayList();
    private Object[] currentValues;

    public UBSPreparedStatement(UBSConnection connection, String sql) throws SQLException {
        super(connection);
        this.isSelectStatement = sql.trim().toUpperCase().startsWith("SELECT");
        if (this.isSelectStatement) {
            super.executeQuery(sql);
        } else {
            this.internalPrepareStatement(sql);
        }
        if (null != this.getParameterMetaData()) {
            this.currentValues = new Object[this.getParameterMetaData().getParameterCount()];
        }
    }

    private void internalSendParameterValues() throws SQLException {
        String data = null;
        Transportable<ArrayList> transportable = this.connection.getTransportable();
        try {
            if (!this.parameterValues.isEmpty()) {
                data = transportable.serialize(this.parameterValues);
            } else {
                ArrayList<Object[]> list = new ArrayList<Object[]>();
                list.add(this.currentValues);
                data = transportable.serialize(list);
            }
            Element statementElement = new Element("statement");
            statementElement.setAttribute("action", StatementAction.UPDATE_PARAMETER.name());
            statementElement.setAttribute("uuid", this.statementUUID.toString());
            statementElement.setAttribute("connection-uuid", this.connection.getConnectionUUID().toString());
            statementElement.setText(data);
            this.connection.getRemoteSession().send(statementElement);
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.internalSendParameterValues();
        return this.currentResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() throws SQLException {
        try {
            this.internalSendParameterValues();
            Element result = this.internalExecuteStatement();
            List<Element> exceptions = result.getChildren("exception");
            if (!exceptions.isEmpty()) {
                Element element = exceptions.iterator().next();
                SQLException exception = (SQLException)XmlUtils.createException(element);
                throw exception;
            }
            int n = this.getResultReturnCodes(result)[0];
            return n;
        }
        finally {
            this.close();
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setObject(parameterIndex, null);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setObject(parameterIndex, new BigDecimal(x));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setObject(parameterIndex, new BigDecimal(x));
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setObject(parameterIndex, new BigDecimal(x));
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setObject(parameterIndex, new BigDecimal(x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setObject(parameterIndex, new BigDecimal(x));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.setObject(parameterIndex, new ComparableByteArray(x));
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setObject(parameterIndex, new Timestamp(x.getTime()));
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setObject(parameterIndex, new Timestamp(x.getTime()));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void clearParameters() throws SQLException {
        for (int i = 0; i < this.currentValues.length; ++i) {
            this.currentValues[i] = null;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        int type = this.parameterMetaData.getParameterType(parameterIndex);
        switch (type) {
            case -5: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (x instanceof BigDecimal) {
                    this.currentValues[parameterIndex - 1] = x;
                    break;
                }
                if (x instanceof Integer) {
                    this.currentValues[parameterIndex - 1] = new BigDecimal((Integer)x);
                    break;
                }
                if (x instanceof Long) {
                    this.currentValues[parameterIndex - 1] = new BigDecimal((Long)x);
                    break;
                }
                if (x instanceof Short) {
                    this.currentValues[parameterIndex - 1] = new BigDecimal(((Short)x).shortValue());
                    break;
                }
                if (x instanceof Double) {
                    this.currentValues[parameterIndex - 1] = new BigDecimal((Double)x);
                    break;
                }
                if (x instanceof Float) {
                    this.currentValues[parameterIndex - 1] = new BigDecimal(((Float)x).floatValue());
                    break;
                }
                if (x == null) {
                    this.currentValues[parameterIndex - 1] = null;
                    break;
                }
                throw new SQLException("Invalid type " + x.getClass() + " for SQL type " + type);
            }
            default: {
                if (x instanceof String) {
                    x = StringUtils.stripEnd((String)x, " ");
                }
                this.currentValues[parameterIndex - 1] = x;
            }
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.currentResultSet = null;
        this.currentUpdateCount = -1;
        if (this.isSelectStatement) {
            this.currentResultSet = this.executeQuery();
            return true;
        }
        this.currentUpdateCount = this.executeUpdate();
        return false;
    }

    @Override
    public void addBatch() throws SQLException {
        this.parameterValues.add(this.currentValues);
        this.currentValues = new Object[this.getParameterMetaData().getParameterCount()];
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.getResultSet() != null ? this.getResultSet().getMetaData() : null;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.setObject(parameterIndex, new Timestamp(x.getTime()));
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.setObject(parameterIndex, new Timestamp(x.getTime()));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setObject(parameterIndex, null);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public final ParameterMetaData getParameterMetaData() throws SQLException {
        return this.parameterMetaData;
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setObject(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void cancel() throws SQLException {
        this.close();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void clearBatch() throws SQLException {
        this.parameterValues.clear();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (this.parameterValues.isEmpty()) {
            return new int[0];
        }
        this.internalSendParameterValues();
        this.clearBatch();
        Element result = this.internalExecuteStatement();
        int[] resultReturnCodes = this.getResultReturnCodes(result);
        List<Element> exceptions = result.getChildren("exception");
        if (!exceptions.isEmpty()) {
            BatchUpdateException batchUpdateException = new BatchUpdateException(resultReturnCodes);
            for (Element element : exceptions) {
                SQLException exception = (SQLException)XmlUtils.createException(element);
                batchUpdateException.setNextException(exception);
            }
            throw batchUpdateException;
        }
        return resultReturnCodes;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

