/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cb2xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import net.sf.cb2xml.CobolPreprocessor;
import net.sf.cb2xml.CopyBookAnalyzer;
import net.sf.cb2xml.DebugLexer;
import net.sf.cb2xml.DebugParserException;
import net.sf.cb2xml.sablecc.lexer.Lexer;
import net.sf.cb2xml.sablecc.lexer.LexerException;
import net.sf.cb2xml.sablecc.node.Start;
import net.sf.cb2xml.sablecc.node.Switch;
import net.sf.cb2xml.sablecc.parser.Parser;
import net.sf.cb2xml.sablecc.parser.ParserException;
import net.sf.cb2xml.util.XmlUtils;
import org.w3c.dom.Document;

public class Cb2Xml2 {
    private static final int FIRST_COBOL_COLUMN = 6;
    private static final int LAST_COBOL_COLUMN = 72;
    private static int[] END_COLS = new int[9];

    public static Document convertToXMLDOM(File file) throws ParserException, LexerException, IOException {
        return Cb2Xml2.convert(file, null, null, false);
    }

    public static Document convertToXMLDOM(File file, boolean bl) throws ParserException, LexerException, IOException {
        return Cb2Xml2.convert(file, null, null, bl);
    }

    public static Document convertToXMLDOM(File file, boolean bl, int n) throws ParserException, LexerException, IOException {
        return Cb2Xml2.convert(file, null, null, bl, n, 6, 72);
    }

    public static Document convertToXMLDOM(File file, boolean bl, int n, int n2) throws ParserException, LexerException, IOException {
        return Cb2Xml2.convert(file, null, null, bl, 2, n, n2);
    }

    public static Document convertToXMLDOM(InputStream inputStream, String string, boolean bl, int n) throws ParserException, LexerException, IOException {
        return Cb2Xml2.convert(null, inputStream, string, bl, n, 6, 72);
    }

    public static Document convertToXMLDOM(InputStream inputStream, String string, boolean bl, int n, int n2) throws ParserException, LexerException, IOException {
        return Cb2Xml2.convert(null, inputStream, string, bl, 2, n, n2);
    }

    public static Document convertToXMLDOM(InputStream inputStream, String string) throws ParserException, LexerException, IOException {
        return Cb2Xml2.convert(null, inputStream, string, false);
    }

    public static Document convertToXMLDOM(InputStream inputStream, String string, boolean bl) throws ParserException, LexerException, IOException {
        return Cb2Xml2.convert(null, inputStream, string, bl);
    }

    public static String convertToXMLString(Document document) {
        return XmlUtils.domToString(document).toString();
    }

    private static Document convert(File file, InputStream inputStream, String string, boolean bl) throws ParserException, LexerException, IOException {
        return Cb2Xml2.convert(file, inputStream, string, bl, 8, 6, 72);
    }

    public static Document convert(File file, InputStream inputStream, String string, boolean bl, int n, int n2, int n3) throws ParserException, LexerException, IOException {
        Start start;
        Parser parser;
        Object object;
        Reader reader;
        Document document = null;
        String string2 = null;
        String string3 = string;
        int n4 = 6;
        if (inputStream == null) {
            switch (n) {
                case 9: {
                    reader = new FileReader(file);
                    n4 = 0;
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    string2 = CobolPreprocessor.preProcess(new FileInputStream(file), 6, END_COLS[n]);
                    reader = new StringReader(string2);
                    break;
                }
                case 2: {
                    string2 = CobolPreprocessor.preProcess(new FileInputStream(file), n2, n3);
                    reader = new StringReader(string2);
                    break;
                }
                default: {
                    string2 = CobolPreprocessor.preProcess(new FileInputStream(file));
                    reader = new StringReader(string2);
                }
            }
            string3 = file.getName();
        } else {
            switch (n) {
                case 9: {
                    reader = new InputStreamReader(inputStream);
                    n4 = 0;
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    string2 = CobolPreprocessor.preProcess(inputStream, 6, END_COLS[n]);
                    reader = new StringReader(string2);
                    break;
                }
                case 2: {
                    string2 = CobolPreprocessor.preProcess(inputStream, n2, n3);
                    reader = new StringReader(string2);
                    break;
                }
                default: {
                    string2 = CobolPreprocessor.preProcess(inputStream);
                    reader = new StringReader(string2);
                }
            }
        }
        PushbackReader pushbackReader = new PushbackReader(reader, 1000);
        if (bl) {
            System.err.println("*** debug mode ***");
            object = new DebugLexer(pushbackReader);
            parser = new Parser((Lexer)object);
            try {
                start = parser.parse(n4);
            }
            catch (ParserException parserException) {
                StringBuffer stringBuffer = ((DebugLexer)object).getBuffer();
                String string4 = "";
                if (stringBuffer != null) {
                    string4 = stringBuffer.toString();
                }
                throw new DebugParserException(parserException, string4);
            }
        } else {
            parser = new Parser(new Lexer(pushbackReader));
            start = parser.parse(n4);
        }
        object = new CopyBookAnalyzer(string3, parser);
        start.apply((Switch)object);
        document = ((CopyBookAnalyzer)object).getDocument();
        return document;
    }

    static {
        Cb2Xml2.END_COLS[1] = 72;
        Cb2Xml2.END_COLS[3] = 80;
        Cb2Xml2.END_COLS[4] = 16000;
    }
}

