/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.cursor;

import de.ubs.jdbcserver.cursor.Cursor;
import de.ubs.jdbcserver.evaluation.ExpressionEvaluator;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractCursor
implements Cursor {
    private final TableDefinition tableDefinition;
    protected long maxRowsToFetch = -1L;
    protected long rowsReturnedToCaller = 0L;
    private ExpressionEvaluator<Boolean> conditionEvaluator;

    public AbstractCursor(TableDefinition tableDefinition) {
        this.tableDefinition = tableDefinition;
    }

    @Override
    public void reset() throws IOException, SQLException {
    }

    @Override
    public void close() throws IOException {
    }

    public TableDefinition getTableDefinition() {
        return this.tableDefinition;
    }

    protected Object[] matchesFilter(Object[] record) throws SQLException {
        if (this.conditionEvaluator == null || record == null) {
            return record;
        }
        for (Map.Entry<String, Integer> entry : this.conditionEvaluator.getReferencedWhereColumns().entrySet()) {
            Object data = (Comparable)record[entry.getValue()];
            if (data instanceof String) {
                data = StringUtils.stripEnd((String)data, " ");
            }
            this.conditionEvaluator.setValue(entry.getKey(), (Comparable)data);
        }
        Boolean b = this.conditionEvaluator.evaluate();
        return b == null || b != false ? record : null;
    }

    public ExpressionEvaluator<Boolean> getConditionEvaluator() {
        return this.conditionEvaluator;
    }

    @Override
    public void updateFilter(ExpressionEvaluator conditionEvaluator) {
        this.conditionEvaluator = conditionEvaluator;
    }

    @Override
    public void setMaxRowsToFetch(long maxRowsToFetch) {
        this.maxRowsToFetch = maxRowsToFetch;
    }
}

