/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.driver;

import de.ubs.jdbcserver.driver.AbstractResultSet;
import de.ubs.jdbcserver.driver.AbstractStatement;
import de.ubs.jdbcserver.driver.UBSConnection;
import de.ubs.jdbcserver.driver.UBSResultSet;
import de.ubs.jdbcserver.driver.UBSResultSetMetaData;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccomm.util.ClientSerializer;
import de.ubs.jdbcserver.jdbccomm.util.XmlUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom2.Element;

public class UBSStatement
extends AbstractStatement {
    public UBSStatement(UBSConnection connection) {
        super(connection);
    }

    private Element getResult(String sql) throws SQLException {
        this.internalPrepareStatement(sql);
        return this.internalExecuteStatement();
    }

    private ResultSet getResultSet(String sql, List<String> orderBy) throws SQLException {
        Element result = this.getResult(sql);
        try {
            TableDefinition td = ClientSerializer.tableDefinitionFromXML(result.getChild("table-definition"));
            UBSResultSetMetaData metaData = new UBSResultSetMetaData(td);
            UUID resultSetUUID = UUID.fromString(result.getAttributeValue("uuid"));
            UBSResultSet currentResultSet = new UBSResultSet(resultSetUUID, this, metaData);
            Logger.getLogger(UBSStatement.class.getName()).log(Level.FINE, "Created result set with ID {0}", resultSetUUID.toString());
            if (!orderBy.isEmpty()) {
                currentResultSet.preCacheAndSort(orderBy, metaData);
            }
            return currentResultSet;
        }
        catch (ParseException ex) {
            SQLException e = new SQLException(ex.getMessage(), ex);
            Logger.getLogger(AbstractResultSet.class.getName()).log(Level.FINE, e.getMessage(), e);
            throw e;
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        Logger.getLogger(UBSStatement.class.getName()).log(Level.FINE, "executeQuery() sql:\n{0}", sql);
        this.currentResultSet = this.getResultSet(sql, new ArrayList<String>());
        return this.currentResultSet;
    }

    public ResultSet executeQueryOrdered(String sql, List<String> labels) throws SQLException {
        Logger.getLogger(UBSStatement.class.getName()).log(Level.FINE, "executeQuery() sql:\n{0}", sql);
        this.currentResultSet = this.getResultSet(sql, labels);
        return this.currentResultSet;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.currentResultSet = null;
        this.currentUpdateCount = -1;
        if (sql.trim().toUpperCase().startsWith("SELECT")) {
            this.currentResultSet = this.executeQuery(sql);
            return true;
        }
        this.currentUpdateCount = this.executeUpdate(sql);
        return false;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.internalPrepareStatement(sql);
        Element result = this.internalExecuteStatement();
        List<Element> exceptions = result.getChildren("exception");
        if (!exceptions.isEmpty()) {
            Element element = exceptions.iterator().next();
            SQLException exception = (SQLException)XmlUtils.createException(element);
            throw exception;
        }
        switch (result.getName()) {
            case "create": {
                String createType;
                switch (createType = result.getAttributeValue("type")) {
                    case "tablespace": {
                        Logger.getLogger(UBSStatement.class.getName()).log(Level.FINE, "Tablespace has been created and stored with name {0}", result.getAttributeValue("name"));
                        break;
                    }
                }
                return 1;
            }
            case "drop": {
                String createType;
                switch (createType = result.getAttributeValue("type")) {
                    case "tablespace": {
                        Logger.getLogger(UBSStatement.class.getName()).log(Level.FINE, "Tablespace {0} has been dropped", result.getAttributeValue("name"));
                        break;
                    }
                }
                return 1;
            }
            case "insert": 
            case "update": 
            case "delete": {
                return this.getResultReturnCodes(result)[0];
            }
        }
        return -1;
    }

    protected int[] getResultReturnCodes(Element result) throws NumberFormatException {
        ArrayList<Integer> rcs = new ArrayList<Integer>();
        StringTokenizer st = new StringTokenizer(result.getText(), ",");
        while (st.hasMoreTokens()) {
            rcs.add(Integer.parseInt(st.nextToken()));
        }
        int[] x = new int[rcs.size()];
        for (int i = 0; i < x.length; ++i) {
            x[i] = (Integer)rcs.get(i);
        }
        return x;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void cancel() throws SQLException {
        this.close();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.executeQuery("select * from sysubs.sysdummy1 where 1 = 0");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

