/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.file;

import de.ubs.jdbcserver.builder.CSVRecordBuilder;
import de.ubs.jdbcserver.file.AbstractProcessableFile;
import de.ubs.jdbcserver.file.CsvFileReader;
import de.ubs.jdbcserver.file.CsvFileWriter;
import de.ubs.jdbcserver.file.ModifiableCsvFile;
import de.ubs.jdbcserver.jdbccomm.struct.ColumnDefinition;
import de.ubs.jdbcserver.jdbccommons.struct.TablespaceDefinition;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.BufferOverflowException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractModifiableCsvFile
extends AbstractProcessableFile
implements ModifiableCsvFile {
    protected static int DELTA_MAP_BASE_ENTRY_SIZE = 24;
    protected CsvFileReader in = null;
    protected CsvFileWriter out = null;
    protected Charset encoding;
    protected TreeMap<Long, String> deltaMap = new TreeMap();
    protected int maxDeltaMapSizeInBytes;
    protected int currentDeltaMapSizeInBytes = 0;
    protected boolean closed = false;
    protected char columnDelimiter;
    protected char stringDelimiter;
    protected TablespaceDefinition.CsvQuoteMode csvQuoteMode;
    protected int maximumRecordLength = 131072;
    protected boolean readOnly;
    protected CharsetDecoder charsetDecoder;
    protected CodingErrorAction codingErrorAction = CodingErrorAction.REPLACE;
    protected String lineSeparator = System.lineSeparator();
    protected List<String> columnNames = null;
    protected boolean firstLineIsHeader;
    protected String filenameForMessages;
    protected String previouslyReadRecord = null;
    protected int flushCount = 0;

    public AbstractModifiableCsvFile(Charset encoding, char columnDelimiter, char stringDelimiter, TablespaceDefinition.CsvQuoteMode csvQuoteMode, boolean readOnly, int cacheSize, boolean strictEncoding, boolean withHeader, String[] colNames) {
        this.stringDelimiter = stringDelimiter;
        this.columnDelimiter = columnDelimiter;
        this.csvQuoteMode = csvQuoteMode;
        this.encoding = encoding;
        this.charsetDecoder = encoding.newDecoder();
        this.maxDeltaMapSizeInBytes = cacheSize;
        this.codingErrorAction = strictEncoding ? CodingErrorAction.REPORT : CodingErrorAction.REPLACE;
        this.firstLineIsHeader = withHeader;
        this.readOnly = readOnly;
        if (colNames != null) {
            this.columnNames = new ArrayList<String>();
            for (String s : colNames) {
                this.columnNames.add(s);
            }
        }
    }

    protected static String[] columnNamesToStringArray(List<ColumnDefinition> cols) {
        String[] r = new String[cols.size()];
        int i = 0;
        for (ColumnDefinition c : cols) {
            r[i] = c.getName();
            ++i;
        }
        return r;
    }

    protected abstract CsvFileReader createNewReader(boolean var1) throws IOException;

    protected abstract CsvFileWriter createNewWriter() throws IOException;

    protected abstract void applyDelta() throws IOException, SQLException;

    protected String convertBytesToString(byte[] bytes, int byteCount) throws IOException {
        int rc;
        ByteArrayInputStream in = new ByteArrayInputStream(bytes, 0, byteCount);
        InputStreamReader isr = new InputStreamReader((InputStream)in, this.charsetDecoder);
        StringBuilder sb = new StringBuilder();
        while ((rc = isr.read()) != -1) {
            sb.append((char)rc);
        }
        return sb.toString();
    }

    protected void writeHeader() throws IOException {
        if (this.readOnly) {
            return;
        }
        if (!this.firstLineIsHeader) {
            return;
        }
        if (this.in != null) {
            throw new RuntimeException("Cannot write header while already reading the file");
        }
        Logger.getLogger(AbstractModifiableCsvFile.class.getName()).log(Level.FINE, String.format("Writing CSV header to file %s", this.filenameForMessages));
        this.out = this.createNewWriter();
        StringBuilder sb = new StringBuilder();
        if (this.columnNames != null) {
            String strDel = Character.toString(this.stringDelimiter);
            Pattern stringDelimiterPattern = Pattern.compile(strDel, 16);
            String escapedStringDelimiterReplacement = Matcher.quoteReplacement(strDel + strDel);
            for (int i = 0; i < this.columnNames.size(); ++i) {
                if (i > 0) {
                    sb.append(this.columnDelimiter);
                }
                sb.append(CSVRecordBuilder.escape(this.columnNames.get(i), this.csvQuoteMode, this.stringDelimiter, stringDelimiterPattern, escapedStringDelimiterReplacement));
            }
        }
        sb.append("\n");
        this.out.write(sb.toString());
        this.out.close();
        this.out = null;
    }

    @Override
    public void close() {
        if (!this.readOnly) {
            try {
                this.applyDelta();
            }
            catch (IOException | SQLException ex) {
                throw new RuntimeException(ex);
            }
        }
        try {
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        try {
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.closed = true;
    }

    @Override
    public void updateRecord(byte[] data, int length) throws IOException, SQLException {
        if (this.closed) {
            throw new RuntimeException("Cannot update record: File is closed");
        }
        if (this.readOnly) {
            throw new SQLException(String.format("Cannot update record: File %s is read-only, or associated tablespace is declared as read-only", this.filenameForMessages), "42807", -150);
        }
        if (this.out != null) {
            throw new RuntimeException("Cannot update record: Last operation was not a read operation");
        }
        if (length > this.maximumRecordLength) {
            throw new SQLException("Cannot update record: Maximum record length is " + this.maximumRecordLength + ", but record has " + length + " bytes");
        }
        String newRecord = this.convertBytesToString(data, length);
        if (!newRecord.equals(this.previouslyReadRecord)) {
            this.deltaMap.put(this.in.getRecordNumber(), newRecord);
            this.currentDeltaMapSizeInBytes += DELTA_MAP_BASE_ENTRY_SIZE + length;
            if (this.currentDeltaMapSizeInBytes >= this.maxDeltaMapSizeInBytes) {
                this.applyDelta();
            }
        }
    }

    @Override
    public void deleteLastReadRecord() throws IOException, SQLException {
        if (this.closed) {
            throw new RuntimeException("Cannot delete record: File is closed");
        }
        if (this.readOnly) {
            throw new SQLException(String.format("Cannot delete record: File %s is read-only, or associated tablespace is declared as read-only", this.filenameForMessages), "42807", -150);
        }
        if (this.out != null) {
            throw new RuntimeException("Cannot delete record: Last operation was not a read operation");
        }
        this.deltaMap.put(this.in.getRecordNumber(), null);
        this.currentDeltaMapSizeInBytes += DELTA_MAP_BASE_ENTRY_SIZE;
        if (this.currentDeltaMapSizeInBytes >= this.maxDeltaMapSizeInBytes) {
            this.applyDelta();
        }
    }

    @Override
    public void writeRecord(byte[] data, int length) throws IOException, SQLException {
        if (this.closed) {
            throw new RuntimeException("Cannot write record: File is closed");
        }
        if (this.readOnly) {
            throw new SQLException(String.format("Cannot write record: File %s is read-only, or associated tablespace is declared as read-only", this.filenameForMessages), "42807", -150);
        }
        if (length > this.maximumRecordLength) {
            throw new SQLException("Cannot update record: Maximum record length is " + this.maximumRecordLength + ", but record has " + length + " bytes");
        }
        if (this.in != null) {
            this.applyDelta();
            this.in.close();
            this.in = null;
            this.out = this.createNewWriter();
        }
        String s = this.convertBytesToString(data, length);
        this.out.write(s + this.lineSeparator);
    }

    @Override
    public int readRecord(byte[] data) throws IOException, BufferOverflowException, SQLException {
        String line;
        block7: {
            String replacement;
            Logger.getLogger(AbstractModifiableCsvFile.class.getName()).log(Level.FINER, String.format("readRecord() called for CSV file %s", this.filenameForMessages));
            if (this.closed) {
                throw new RuntimeException("Cannot read record: File is closed");
            }
            if (this.out != null) {
                throw new RuntimeException("Cannot read record: Last operation was an append operation. Call begin() before reading again.");
            }
            do {
                try {
                    line = this.in.readRecord();
                }
                catch (MalformedInputException ex) {
                    throw new SQLException(String.format("Malformed data in input file %s. Cannot interpret record %d as %s.", this.filenameForMessages, this.in.getRecordNumber(), this.encoding.displayName()), ex);
                }
                if (line == null) {
                    this.previouslyReadRecord = null;
                    return -1;
                }
                if (!this.deltaMap.containsKey(this.in.getRecordNumber())) break block7;
            } while ((replacement = this.deltaMap.get(this.in.getRecordNumber())) == null);
            byte[] replacementBytes = replacement.getBytes(this.encoding);
            System.arraycopy(replacementBytes, 0, data, 0, replacementBytes.length);
            this.previouslyReadRecord = replacement;
            return replacementBytes.length;
        }
        byte[] bytes = line.getBytes(this.encoding);
        if (bytes.length > this.maximumRecordLength) {
            throw new SQLException(String.format("Cannot read record: Record %d has %d bytes (maximum length is %d)", this.in.getRecordNumber(), bytes.length, this.maximumRecordLength));
        }
        System.arraycopy(bytes, 0, data, 0, bytes.length);
        this.previouslyReadRecord = line;
        return bytes.length;
    }

    @Override
    public void begin() throws IOException {
        if (this.closed) {
            throw new RuntimeException("Cannot set cursor to start of file " + this.filenameForMessages + ": File is closed");
        }
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
        if (this.in != null) {
            this.in.close();
        }
        this.in = this.createNewReader(false);
    }

    public void setMaxDeltaMapSizeInBytes(int maxDeltaMapSizeInBytes) {
        if (maxDeltaMapSizeInBytes < 1) {
            this.maxDeltaMapSizeInBytes = 1;
        }
        this.maxDeltaMapSizeInBytes = maxDeltaMapSizeInBytes;
    }

    @Override
    public boolean locate(byte[] data) throws IOException, BufferOverflowException, SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getRecordCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getKeyStartOffset() {
        return -1;
    }

    @Override
    public int getKeyLength() {
        return -1;
    }

    @Override
    public boolean isVariableLength() {
        return true;
    }

    @Override
    public int getMaximumRecordLength() {
        return this.maximumRecordLength;
    }

    public void setMaximumRecordLength(int maximumRecordLength) {
        this.maximumRecordLength = maximumRecordLength;
    }

    int getFlushCount() {
        return this.flushCount;
    }
}

