/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.BsamRecordReader;
import com.ibm.jzos.Messages;
import com.ibm.jzos.RcException;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileConstants;
import com.ibm.jzos.ZFileException;
import com.ibm.jzos.ZFileRecordReader;
import com.ibm.jzos.ZUtil;

public abstract class RecordReader
implements ZFileConstants {
    protected boolean autoFree = false;

    RecordReader() {
    }

    public static RecordReader newReaderForDD(String ddname) throws ZFileException {
        ZFile.checkSecurityManager("//DD:" + ddname, "r");
        return RecordReader.basicNewReaderForDD(ddname);
    }

    static RecordReader basicNewReaderForDD(String ddname) throws ZFileException {
        RecordReader reader = null;
        try {
            reader = BsamRecordReader.newReaderForDD(ddname);
        }
        catch (UnsupportedOperationException uoe) {
            reader = new ZFileRecordReader(ddname);
        }
        return reader;
    }

    public static RecordReader newReader(String name, int flags) throws ZFileException, RcException {
        ZFile.checkSecurityManager(name, "r");
        String fqdsn = ZFile.getFullyQualifiedDSN(name);
        String ddname = null;
        boolean autoFree = false;
        ddname = RecordReader.extractDDName(name);
        if (ddname != null) {
            if (flags != 0) {
                ZUtil.logDiagnostic(3, Messages.getString("RecordReader.DDNameNotSupported") + " " + name);
            }
        } else if (flags == 1) {
            ddname = RecordReader.doAlloc(fqdsn, "shr");
            autoFree = true;
        } else if (flags == 4 || flags == 0) {
            ddname = RecordReader.doAlloc(fqdsn, "old");
            autoFree = true;
        } else {
            throw new IllegalArgumentException(Messages.getString("RecordReader.InvalidFlags") + " 0x" + Integer.toHexString(flags));
        }
        try {
            RecordReader instance = RecordReader.basicNewReaderForDD(ddname);
            instance.setAutoFree(autoFree);
            return instance;
        }
        catch (ZFileException zfe) {
            if (autoFree) {
                RecordReader.doFree(ddname);
            }
            throw zfe;
        }
    }

    public abstract int read(byte[] var1) throws ZFileException;

    public abstract int read(byte[] var1, int var2, int var3) throws ZFileException;

    public abstract void close() throws ZFileException;

    public abstract int getLrecl();

    public abstract int getBlksize();

    public abstract int getRecfmBits();

    public abstract String getRecfm();

    public abstract String getDDName();

    public abstract String getDsn();

    public boolean getAutoFree() {
        return this.autoFree;
    }

    public void setAutoFree(boolean autoFree) {
        this.autoFree = autoFree;
    }

    protected static String doAlloc(String fqdsn, String disp) throws RcException {
        String ddname = ZFile.allocDummyDDName();
        try {
            ZFile.bpxwdyn("alloc fi(" + ddname + ") da(" + fqdsn + ") reuse " + disp + " msg(2)");
            ZUtil.logDiagnostic(5, "RecordReader: Allocated " + fqdsn + " to DD:" + ddname + " DISP=" + disp);
        }
        catch (RcException rce) {
            RecordReader.doFree(ddname);
            throw rce;
        }
        return ddname;
    }

    protected static void doFree(String ddname) {
        try {
            ZFile.bpxwdyn("free fi(" + ddname + ") msg(2)");
            ZUtil.logDiagnostic(5, "RecordReader: Freed DD:" + ddname);
        }
        catch (RcException rce) {
            ZUtil.logDiagnostic(1, "RecordReader: Error freeing DD:" + ddname + " - " + rce.getMessage());
        }
    }

    protected void doAutoFree() {
        if (this.autoFree) {
            RecordReader.doFree(this.getDDName());
        }
    }

    private static String extractDDName(String filename) {
        if (filename == null) {
            return null;
        }
        String upperFilename = filename.toUpperCase().trim();
        int i = upperFilename.indexOf("DD:");
        if (i >= 0 && (i += 3) < upperFilename.length()) {
            return upperFilename.substring(i);
        }
        return null;
    }
}

