/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.xdm.utils.template;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import javax.script.ScriptException;
import org.apache.commons.io.IOUtils;

public class TemplateUtilities {
    private static Configuration configuration = new Configuration();

    public static String tailorFromURL(URL resourcePath, Map<String, Object> properties) throws IOException, ScriptException {
        String content = IOUtils.toString(resourcePath, Charset.defaultCharset());
        return TemplateUtilities.tailorContent(content, properties, resourcePath.getPath());
    }

    @Deprecated
    public static String tailorFromResource(URL resourcePath, Map<String, Object> properties) throws FileNotFoundException, ScriptException, URISyntaxException {
        File file = new File(resourcePath.toURI());
        return TemplateUtilities.tailor(file.getAbsolutePath(), properties);
    }

    public static String tailorContent(String templateContent, String variableName, Object value) throws ScriptException {
        return TemplateUtilities.tailorContent(templateContent, Collections.singletonMap(variableName, value));
    }

    public static String tailorContent(String templateContent, String variableName, Object value, String name) throws ScriptException {
        return TemplateUtilities.tailorContent(templateContent, Collections.singletonMap(variableName, value), name);
    }

    public static String tailorContent(String templateContent, Map<String, Object> properties) throws ScriptException {
        return TemplateUtilities.tailorContent(templateContent, properties, "template");
    }

    public static String tailorContent(String templateContent, Map<String, Object> properties, String name) throws ScriptException {
        StringWriter writer = new StringWriter();
        try {
            Template template = new Template(name, new StringReader(templateContent), configuration);
            template.setBooleanFormat("yes,no");
            template.process(properties, writer);
        }
        catch (TemplateException | IOException ex) {
            throw new ScriptException(ex);
        }
        return writer.toString();
    }

    public static String tailor(String templateFileName, Map<String, Object> properties) throws FileNotFoundException, ScriptException {
        String string;
        FileReader in = new FileReader(templateFileName);
        try {
            string = TemplateUtilities.tailor(in, properties);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ((Reader)in).close();
        return string;
    }

    public static String tailor(Reader in, Map<String, Object> properties) throws ScriptException {
        try {
            return TemplateUtilities.tailorContent(IOUtils.toString(in), properties, "template");
        }
        catch (IOException ex) {
            throw new ScriptException(ex);
        }
    }
}

