/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.jdbccommons.struct;

import de.ubs.jdbcserver.jdbccomm.struct.AbstractItem;
import de.ubs.jdbcserver.jdbccomm.struct.ColumnDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.Field;
import de.ubs.jdbcserver.jdbccomm.struct.ItemPath;
import de.ubs.jdbcserver.jdbccomm.struct.Section;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.TablespaceLayout;
import de.ubs.jdbcserver.jdbccomm.util.Pair;
import de.ubs.jdbcserver.jdbccommons.SQLTypes;
import de.ubs.jdbcserver.jdbccommons.sql.parser.ParserUtils;
import de.ubs.jdbcserver.jdbccommons.sql.parser.SQLParserParser;
import de.ubs.jdbcserver.jdbccommons.struct.CatalogManager;
import de.ubs.jdbcserver.jdbccommons.struct.TablespaceDefinition;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;

public class DatabaseObjectFactory {
    public static final String ISO_DATE_PATTERN = "yyyy-MM-dd";
    public static final String ISO_TIME_PATTERN = "HH:mm:ss";
    public static final String ISO_TIMESTAMP_PATTERN = "yyyy-MM-dd-HH:mm:ss.SSS";

    private static char constantToChar(SQLParserParser.ConstantContext con) throws SQLException {
        String r = DatabaseObjectFactory.constantToString(con);
        if (r.length() != 1) {
            throw new SQLException("The value \"" + con.value.toString() + "\" is not a single character");
        }
        return r.charAt(0);
    }

    private static String constantToString(SQLParserParser.ConstantContext con) throws SQLException {
        if (con.StringLiteral() != null) {
            return con.value.toString();
        }
        if (con.number() != null) {
            return con.value.toString();
        }
        if (con.HexLiteral() != null) {
            try {
                return new String(Hex.decodeHex(con.value.toString().toCharArray()));
            }
            catch (DecoderException e) {
                throw new SQLException(e);
            }
        }
        throw new RuntimeException("Unsupported value for constant");
    }

    public static void applyCsvTablespaceAttributes(TablespaceDefinition ts, SQLParserParser.CsvOptionsContext ctx) throws SQLException {
        if (ctx.coldelOption() != null && !ctx.coldelOption().isEmpty()) {
            if (ctx.coldelOption().size() > 1) {
                throw new SQLException("COLDEL must be specified only once");
            }
            ts.setCSVColumnDelimiter(DatabaseObjectFactory.constantToChar(ctx.coldelOption(0).constant()));
        }
        if (ctx.chardelOption() != null && !ctx.chardelOption().isEmpty()) {
            if (ctx.chardelOption().size() > 1) {
                throw new SQLException("CHARDEL must be specified only once");
            }
            ts.setCSVStringDelimiter(DatabaseObjectFactory.constantToChar(ctx.chardelOption(0).constant()));
        }
        if (ctx.decptOption() != null && !ctx.decptOption().isEmpty()) {
            if (ctx.decptOption().size() > 1) {
                throw new SQLException("DECPT must be specified only once");
            }
            ts.setCSVDecimalDelimiter(DatabaseObjectFactory.constantToChar(ctx.decptOption(0).constant()));
        }
        if (ctx.headerOption() != null && !ctx.headerOption().isEmpty()) {
            if (ctx.headerOption().size() > 1) {
                throw new SQLException("HEADER must be specified only once");
            }
            ts.setCSVHeader(ctx.headerOption(0).YES() != null);
        }
        if (ctx.boolvaluesOption() != null && !ctx.boolvaluesOption().isEmpty()) {
            if (ctx.boolvaluesOption().size() > 1) {
                throw new SQLException("BOOLVALUES must be specified only once");
            }
            ts.setCSVBoolean(true, DatabaseObjectFactory.constantToString(ctx.boolvaluesOption(0).constant(0)));
            ts.setCSVBoolean(false, DatabaseObjectFactory.constantToString(ctx.boolvaluesOption(0).constant(1)));
        }
        if (ctx.csvQuoteMode() != null && !ctx.csvQuoteMode().isEmpty()) {
            if (ctx.csvQuoteMode().size() > 1) {
                throw new SQLException("QUOTE must be specified only once");
            }
            if (ctx.csvQuoteMode(0).ALL() != null) {
                ts.setCSVQuoteMode(TablespaceDefinition.CsvQuoteMode.ALL);
            } else if (ctx.csvQuoteMode(0).STRINGS() != null) {
                ts.setCSVQuoteMode(TablespaceDefinition.CsvQuoteMode.STRINGS);
            } else if (ctx.csvQuoteMode(0).MINIMAL() != null) {
                ts.setCSVQuoteMode(TablespaceDefinition.CsvQuoteMode.MINIMAL);
            } else if (ctx.csvQuoteMode(0).NONE() != null) {
                ts.setCSVQuoteMode(TablespaceDefinition.CsvQuoteMode.NONE);
            }
        }
        if (ctx.cacheSize() != null && !ctx.cacheSize().isEmpty()) {
            if (ctx.cacheSize().size() > 1) {
                throw new SQLException("CACHESIZE must be specified only once");
            }
            long cacheSize = Integer.valueOf(ctx.cacheSize(0).number().getText()).intValue();
            if (ctx.cacheSize(0).KB() != null) {
                cacheSize *= 1024L;
            } else if (ctx.cacheSize(0).MB() != null) {
                cacheSize *= 0x100000L;
            }
            if (cacheSize > Integer.MAX_VALUE) {
                throw new SQLException("Cache size for CSV tablespace must not exceed 2048 MB");
            }
            ts.setCSVCacheSize((int)Math.max(cacheSize, 0L));
        }
    }

    public static TablespaceDefinition create(SQLParserParser.CreateTablespaceContext ctx, String creator) throws SQLException {
        String name = ctx.identifier() != null ? ctx.identifier().value.toUpperCase() : null;
        TablespaceDefinition tablespaceDefinition = new TablespaceDefinition();
        tablespaceDefinition.setName(name);
        tablespaceDefinition.setCreator(creator);
        tablespaceDefinition.setCreatedTimestamp(new Timestamp(new Date().getTime()));
        tablespaceDefinition.setAlteredTimestamp(new Timestamp(new Date().getTime()));
        if (ctx.CSV() != null) {
            tablespaceDefinition.setTablespaceType(TablespaceDefinition.TablespaceType.CSV);
            DatabaseObjectFactory.applyCsvTablespaceAttributes(tablespaceDefinition, ctx.csvOptions());
        }
        if (ctx.READONLY() != null) {
            tablespaceDefinition.setReadOnly(true);
        }
        if (ctx.dfsortClause() != null) {
            tablespaceDefinition.setUseDfsortAccess(true);
            if (ctx.dfsortClause().THRESHOLD() != null) {
                tablespaceDefinition.setMinThreshold(Integer.valueOf(ctx.dfsortClause().number().getText()));
            }
            LinkedList<String> options = new LinkedList<String>();
            for (TerminalNode opt : ctx.dfsortClause().StringLiteral()) {
                options.add(StringUtils.strip(opt.getText(), "'"));
            }
            tablespaceDefinition.setDfsortOptions(StringUtils.join(options, ","));
        }
        return tablespaceDefinition;
    }

    public static Pair<TablespaceDefinition, TableDefinition> create(SQLParserParser.CreateTableContext ctx, String creator) throws SQLException, IOException {
        String schema = ctx.identifier((int)0).value;
        String name = ctx.identifier((int)1).value;
        String tablespaceName = null;
        if (ctx.FILE() == null && ctx.identifier().size() > 2) {
            tablespaceName = ctx.identifier((int)2).value.toUpperCase();
        } else if (ctx.FILE() != null && ctx.StringLiteral() != null) {
            String fileName = StringUtils.strip(ctx.StringLiteral().getText(), "'");
            tablespaceName = CatalogManager.getDefault().getTablespaceNameForFile(fileName);
            if (tablespaceName == null) {
                SQLException e = new SQLException("The file " + fileName + " is not defined as a tablespace", "42704", -204);
                Logger.getLogger(CatalogManager.class.getName()).log(Level.SEVERE, e.getMessage(), e);
                throw e;
            }
        }
        TablespaceDefinition tablespace = CatalogManager.getDefault().getTablespace(tablespaceName);
        if (tablespace == null) {
            SQLException e = new SQLException("The tablespace " + tablespaceName + " is not defined", "42704", -204);
            Logger.getLogger(CatalogManager.class.getName()).log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        if (tablespace.getName().equalsIgnoreCase("SYS")) {
            SQLException e = new SQLException("Cannot create table in system tablespace", "42832", -607);
            Logger.getLogger(CatalogManager.class.getName()).log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        TableDefinition tableDefinition = new TableDefinition(schema, name);
        tableDefinition.setCreator(creator);
        tableDefinition.setAlteredTimestamp(new Timestamp(new Date().getTime()));
        tableDefinition.setCreatedTimestamp(new Timestamp(new Date().getTime()));
        tableDefinition.setTablespaceName(tablespaceName);
        if (tablespace.getTablespaceType() == TablespaceDefinition.TablespaceType.CSV) {
            List<ColumnDefinition> columns = DatabaseObjectFactory.processColumnDefinition(ctx.columnDef(), tablespace.getLayout());
            TablespaceLayout csvLayout = tablespace.getLayout();
            Section mainSection = csvLayout.getStartSection();
            for (ColumnDefinition column : columns) {
                Field field = new Field(mainSection, column.getName(), column.getTypeName(), -1, column.getLength(), column.getScale());
                mainSection.addItem(field);
                tableDefinition.getColumns().add(column);
            }
            tablespace.setLayout(csvLayout);
        } else if (tablespace.getTablespaceType() == TablespaceDefinition.TablespaceType.VSAM) {
            if (ctx.whenCondition() != null) {
                tableDefinition.setWhenCondition(DatabaseObjectFactory.getDisjunctionText(ctx.whenCondition().disjunction()));
            }
            ParserUtils utils = new ParserUtils();
            List<ColumnDefinition> columns = DatabaseObjectFactory.processColumnDefinition(ctx.columnDef(), tablespace.getLayout());
            for (ColumnDefinition column : columns) {
                if (!column.getFieldPath().getPathElements()[0].equals("REMAINING_BYTES") && null == tablespace.getLayout().getField(column.getFieldPath())) {
                    SQLException e = new SQLException(String.format("The specified path %s of column %s is not defined", column.getFieldPath().toString(), column.getName()), "42703", -205);
                    Logger.getLogger(CatalogManager.class.getName()).log(Level.SEVERE, e.getMessage(), e);
                    throw e;
                }
                tableDefinition.getColumns().add(column);
                if (column.getExistenceExpression() == null) continue;
                SQLParserParser.DisjunctionContext disjuncation = utils.parseDisjuncation(column.getExistenceExpression());
                DatabaseObjectFactory.updateReadOnlyColumns(tableDefinition, ParserUtils.getReferencedColumns(disjuncation));
            }
            if (ctx.whenCondition() != null) {
                DatabaseObjectFactory.updateReadOnlyColumns(tableDefinition, ParserUtils.getReferencedColumns(ctx.whenCondition().disjunction()));
            }
        } else {
            SQLException e = new SQLException(String.format("Unsupported tablespace type", new Object[0]), "56038", -4700);
            Logger.getLogger(CatalogManager.class.getName()).log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        return new Pair<TablespaceDefinition, TableDefinition>(tablespace, tableDefinition);
    }

    public static String getDisjunctionText(SQLParserParser.DisjunctionContext disjunction) {
        int a = disjunction.start.getStartIndex();
        int b = disjunction.stop.getStopIndex();
        Interval interval = new Interval(a, b);
        CharStream inputStream = disjunction.getStart().getInputStream();
        return inputStream.getText(interval);
    }

    private static List<ColumnDefinition> processColumnDefinition(List<SQLParserParser.ColumnDefContext> defs, TablespaceLayout tablespace) throws NumberFormatException, SQLException {
        LinkedList<ColumnDefinition> columns = new LinkedList<ColumnDefinition>();
        for (SQLParserParser.ColumnDefContext columnDef : defs) {
            if (columnDef.GROUP() != null) {
                String groupName = columnDef.identifier().value;
                ItemPath groupPath = DatabaseObjectFactory.createFieldPath(columnDef.usesPath());
                AbstractItem groupItem = tablespace.getItem(groupPath);
                if (groupItem == null) {
                    throw new SQLException(String.format("The specified path %s of group %s is not valid", groupPath.toString(), groupName), "42703", -205);
                }
                String[] groupPathElements = groupPath.getPathElements();
                List<ColumnDefinition> groupColumns = DatabaseObjectFactory.processColumnDefinition(columnDef.columnDef(), tablespace);
                for (int i = 1; i <= groupItem.getMaximumOccurrences(); ++i) {
                    for (ColumnDefinition column : groupColumns) {
                        String[] columnPathElements = column.getFieldPath().getPathElements();
                        String[] newItemPathStr = new String[groupPathElements.length + columnPathElements.length];
                        System.arraycopy(groupPathElements, 0, newItemPathStr, 0, groupPathElements.length);
                        System.arraycopy(columnPathElements, 0, newItemPathStr, groupPathElements.length, columnPathElements.length);
                        ItemPath newItemPath = new ItemPath(newItemPathStr);
                        ColumnDefinition newColumn = column.deepCopy();
                        newColumn.setFieldPath(newItemPath);
                        String newColumnName = StringUtils.replace(newColumn.getName(), ":" + groupName + ":", String.format("%03d", i));
                        newColumn.setName(newColumnName);
                        columns.add(newColumn);
                        newColumn.setExistenceExpression(DatabaseObjectFactory.buildColumnExpression(tablespace, newColumn.getFieldPath(), i, columns));
                    }
                }
                continue;
            }
            columns.add(DatabaseObjectFactory.createColumnDefinition(columnDef));
        }
        return columns;
    }

    private static String buildColumnExpression(TablespaceLayout layout, ItemPath path, int occurrenceNo, List<ColumnDefinition> columns) throws SQLException {
        AbstractItem item;
        LinkedList<String> expressions = new LinkedList<String>();
        ItemPath parentPath = path;
        while ((parentPath = parentPath.getParentPath()) != null && (item = layout.getItem(parentPath)) != null) {
            if (item.getOccurrenceCounterField() == null) continue;
            Field field = TablespaceLayout.findOccurrenceCounterField(item.getParent(), item.getOccurrenceCounterField());
            if (field == null) {
                throw new RuntimeException("The occurrence counter field " + item.getOccurrenceCounterField() + " must be located before " + path.toString());
            }
            ColumnDefinition matchedColumn = null;
            for (ColumnDefinition column : columns) {
                if (!column.getFieldPath().equals(field.getFieldPath())) continue;
                matchedColumn = column;
            }
            if (matchedColumn == null) {
                throw new SQLException("The occurrence counter field " + field.getFieldPath().toString() + " is not in table", "42703", -205);
            }
            expressions.add(String.format("\"%s\" >= %d", matchedColumn.getName(), occurrenceNo));
        }
        return expressions.isEmpty() ? null : StringUtils.join(expressions, " AND ");
    }

    private static ColumnDefinition createColumnDefinition(SQLParserParser.ColumnDefContext columnDef) throws SQLException, NumberFormatException {
        String columnName = columnDef.identifier().value;
        CatalogManager.checkLength(columnName, "column name", 128);
        ColumnDefinition cd = new ColumnDefinition(columnName);
        cd.setNullable(columnDef.NOT() == null);
        String typeName = columnDef.typeSpec().ID().getText().toUpperCase();
        try {
            SQLTypes valueOf = SQLTypes.valueOf(typeName);
            cd.setTypeName(typeName);
        }
        catch (Exception e) {
            throw new SQLException("Invalid column data type specified: " + typeName, "42815", -171);
        }
        switch (cd.getType()) {
            case 3: {
                cd.setLength(columnDef.typeSpec().number().size() > 0 ? Integer.parseInt(columnDef.typeSpec().number(0).getText()) : 5);
                cd.setScale(columnDef.typeSpec().number().size() > 1 ? Integer.parseInt(columnDef.typeSpec().number(1).getText()) : 0);
                break;
            }
            case 91: {
                if (columnDef.typeSpec().PATTERN() != null) {
                    String datePattern = StringUtils.strip(columnDef.typeSpec().StringLiteral().getText(), "'");
                    cd.setTimestampPattern(datePattern);
                    break;
                }
                cd.setTimestampPattern(ISO_DATE_PATTERN);
                break;
            }
            case 92: {
                if (columnDef.typeSpec().PATTERN() != null) {
                    String timePattern = StringUtils.strip(columnDef.typeSpec().StringLiteral().getText(), "'");
                    cd.setTimestampPattern(timePattern);
                    break;
                }
                cd.setTimestampPattern(ISO_TIME_PATTERN);
                break;
            }
            case 93: {
                cd.setScale(columnDef.typeSpec().number().size() > 0 ? Integer.parseInt(columnDef.typeSpec().number(0).getText()) : 3);
                if (columnDef.typeSpec().PATTERN() != null) {
                    String timestampPattern = StringUtils.strip(columnDef.typeSpec().StringLiteral().getText(), "'");
                    cd.setTimestampPattern(timestampPattern);
                } else {
                    cd.setTimestampPattern(ISO_TIMESTAMP_PATTERN);
                }
                if (columnDef.typeSpec().number().size() <= 1) break;
                throw new SQLException(cd.getTypeName() + " can only have a scale, not both length and scale");
            }
            case -16: 
            case -15: 
            case -9: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                cd.setLength(columnDef.typeSpec().number().size() > 0 ? Integer.parseInt(columnDef.typeSpec().number(0).getText()) : 1);
                if (columnDef.typeSpec().number().size() <= 1) break;
                throw new SQLException(cd.getTypeName() + " cannot have a scale");
            }
            default: {
                if (columnDef.typeSpec().number().isEmpty()) break;
                throw new SQLException(cd.getTypeName() + " cannot have a length and/or scale");
            }
        }
        if (columnDef.IF() != null) {
            cd.setExistenceExpression(DatabaseObjectFactory.getDisjunctionText(columnDef.disjunction()));
        }
        if (columnDef.USE() != null || columnDef.USES() != null) {
            ItemPath fieldPath;
            if (columnDef.usesPath() != null) {
                fieldPath = DatabaseObjectFactory.createFieldPath(columnDef.usesPath());
                cd.setFieldPath(fieldPath);
            } else if (columnDef.REMAINING_BYTES() != null) {
                fieldPath = new ItemPath(new String[0]);
                fieldPath.setPathElements(new String[]{"REMAINING_BYTES"});
                cd.setFieldPath(fieldPath);
            }
        }
        return cd;
    }

    private static ItemPath createFieldPath(SQLParserParser.UsesPathContext usePathCtx) throws SQLException {
        int referenceCount = usePathCtx.StringLiteral().size();
        String[] referencedFieldPath = new String[referenceCount];
        for (int i = 0; i < referenceCount; ++i) {
            referencedFieldPath[i] = StringUtils.strip(usePathCtx.StringLiteral(i).getText(), "'").toUpperCase();
        }
        return new ItemPath(referencedFieldPath);
    }

    private static void updateReadOnlyColumns(TableDefinition tableDefinition, Set<String> referencedColumns) {
        for (String column : referencedColumns) {
            tableDefinition.getColumnDefinition(column).setReadOnly(true);
        }
    }
}

