/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.command.sql;

import de.ubs.jdbcserver.command.sql.ImplicitPrimaryKeyBuilder;
import de.ubs.jdbcserver.command.sql.StatementCommand;
import de.ubs.jdbcserver.jdbccomm.struct.ColumnDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.Field;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.TablespaceLayout;
import de.ubs.jdbcserver.jdbccomm.util.Pair;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VSAMImplicitPrimaryKeyBuilder
implements ImplicitPrimaryKeyBuilder {
    @Override
    public List<Pair<ColumnDefinition, Field>> buildImplicitPrimaryKey(TableDefinition tableDefinition, int keystart, int keylength, TablespaceLayout layout) {
        Logger.getLogger(StatementCommand.class.getName()).log(Level.FINE, "Physical key for {0}.{1} is {2} / {3}", new Object[]{tableDefinition.getSchema(), tableDefinition.getName(), keystart, keylength});
        List<Pair<ColumnDefinition, Field>> primaryKeyColumns = this.findFieldsOnVsamKey(tableDefinition, layout, keystart, keylength);
        Collections.sort(primaryKeyColumns, new Comparator<Pair<ColumnDefinition, Field>>(){

            @Override
            public int compare(Pair<ColumnDefinition, Field> o1, Pair<ColumnDefinition, Field> o2) {
                return o1.second().getAbsolutePosition() - o2.second().getAbsolutePosition();
            }
        });
        return primaryKeyColumns;
    }

    List<Pair<ColumnDefinition, Field>> findFieldsOnVsamKey(TableDefinition tableDefinition, TablespaceLayout layout, int keystart, int keylength) {
        HashSet<ColumnDefinition> foundColumns = new HashSet<ColumnDefinition>();
        LinkedList<Pair<ColumnDefinition, Field>> primaryKeyColumns = new LinkedList<Pair<ColumnDefinition, Field>>();
        for (ColumnDefinition column : tableDefinition.getColumns()) {
            Field field = layout.getField(column.getFieldPath());
            int absolutePosition = field.getAbsolutePosition();
            if (absolutePosition < keystart || absolutePosition + field.getLength() > keystart + keylength || foundColumns.contains(column)) continue;
            primaryKeyColumns.add(new Pair<ColumnDefinition, Field>(column, field));
            foundColumns.add(column);
        }
        return primaryKeyColumns;
    }

    @Override
    public void applyPrimaryKey(List<Pair<ColumnDefinition, Field>> primaryKeyColumns, TableDefinition tableDefinition) {
        for (int i = 0; i < primaryKeyColumns.size(); ++i) {
            Pair<ColumnDefinition, Field> pair = primaryKeyColumns.get(i);
            pair.first().setKeySequence(i + 1);
            Logger.getLogger(StatementCommand.class.getName()).log(Level.FINE, "Added implicit primary key for column {0} record position: {1} length: {2}", new Object[]{pair.first().getName(), pair.second().getPosition(), pair.second().getLength()});
        }
    }
}

