/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields;

import com.ibm.jzos.ByteUtil;
import com.ibm.jzos.fields.FloatAccessor;

public class IbmFloatField
implements FloatAccessor {
    public static final int BYTE_LENGTH = 4;
    private static final int SIGN_BIT = Integer.MIN_VALUE;
    private static final int ALL_NON_SIGN_BITS = Integer.MAX_VALUE;
    private static final int HFP_FRACTION_MASK = 0xFFFFFF;
    private static final int BFP_FRACTION_MASK = 0x7FFFFF;
    private static final int BFP_FRACTION_IMPLIED_HOB = 0x800000;
    private static final int HFP_FRACTION_HON = 0xF00000;
    private static final int HFP_EXP_MASK = 0x7F000000;
    private static final int BFP_EXP_MASK = 2139095040;
    private static final int HFP_FRACTION_LENGTH = 24;
    private static final int BFP_FRACTION_LENGTH = 23;
    private static final int BFP_BIAS = 127;
    private static final int BFP_INF_EXP = 255;
    private int offset;

    public IbmFloatField(int offset) {
        this.offset = offset;
    }

    public int getByteLength() {
        return 4;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public float getFloat(byte[] buffer) {
        return this.getFloat(buffer, 0);
    }

    public float getFloat(byte[] buffer, int bufOffset) {
        int hfpBits = ByteUtil.bytesAsInt(buffer, this.offset + bufOffset, 4);
        int bfpBits = this.hfp2bfp(hfpBits);
        return Float.intBitsToFloat(bfpBits);
    }

    public void putFloat(float value, byte[] buffer) {
        this.putFloat(value, buffer, 0);
    }

    public void putFloat(float value, byte[] buffer, int bufOffset) {
        int bfpBits = Float.floatToIntBits(value);
        int hfpBits = this.bfp2hfp(bfpBits);
        ByteUtil.putInt(hfpBits, buffer, this.offset + bufOffset);
    }

    private int bfp2hfp(int bfpBits) {
        int sign = bfpBits & Integer.MIN_VALUE;
        if ((bfpBits & Integer.MAX_VALUE) == 0) {
            return sign;
        }
        int fraction = bfpBits & 0x7FFFFF;
        int bfpExp = (bfpBits & 0x7F800000) >> 23;
        if (bfpExp == 255) {
            return sign | 0x7F000000 | 0xFFFFFF;
        }
        if (bfpExp > 0) {
            fraction |= 0x800000;
        }
        if (bfpExp == 0 && (fraction & 0xF00000) == 0) {
            fraction <<= 4;
            bfpExp -= 3;
        }
        int hfpExp = bfpExp + 130;
        fraction >>= -hfpExp & 3;
        hfpExp += 3;
        hfpExp /= 4;
        while ((fraction & 0xF00000) == 0) {
            --hfpExp;
            fraction <<= 4;
        }
        return sign | hfpExp << 24 | fraction;
    }

    private int hfp2bfp(int hfpBits) {
        int sign = hfpBits & Integer.MIN_VALUE;
        if ((hfpBits & Integer.MAX_VALUE) == 0) {
            return sign;
        }
        int fraction = hfpBits & 0xFFFFFF;
        int characteristic = (hfpBits & 0x7F000000) >> 24;
        int exp = (characteristic - 64 << 2) + 127 - 1;
        while ((fraction & 0x800000) == 0) {
            --exp;
            fraction <<= 1;
        }
        if (exp <= 0) {
            fraction = exp < -24 ? 0 : (fraction >>= -exp + 1);
            exp = 0;
        } else if (exp >= 255) {
            fraction = 0;
            exp = 255;
        } else {
            fraction &= 0x7FFFFF;
        }
        return sign | exp << 23 | fraction;
    }

    public boolean equals(Float aFloat, float afloat) {
        if (aFloat == null) {
            return false;
        }
        return aFloat.floatValue() == afloat;
    }
}

