/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cb2xml.convert;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import net.sf.cb2xml.convert.Utils;
import net.sf.cb2xml.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MainframeToXml {
    private String mainframeBuffer = null;
    private Document resultDocument = null;

    private static String stripNullChars(String string) {
        try {
            int n;
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = ((Reader)bufferedReader).read()) > -1) {
                if (n != 0) {
                    stringBuffer.append((char)n);
                    continue;
                }
                stringBuffer.append(' ');
            }
            ((Reader)bufferedReader).close();
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public Document convert(String string, Document document) {
        this.mainframeBuffer = MainframeToXml.stripNullChars(string);
        this.resultDocument = XmlUtils.getNewXmlDocument();
        int n = string.length();
        Element element = document.getDocumentElement();
        Element element2 = Utils.getFirstElement(element);
        Element element3 = this.resultDocument.createElement(element.getTagName());
        int n2 = Integer.parseInt(element2.getAttribute("storage-length"));
        for (int i = 0; i < n; i += n2) {
            Element element4 = this.convertNode(element2, i);
            element3.appendChild(element4);
        }
        this.resultDocument.appendChild(element3);
        return this.resultDocument;
    }

    private Element convertNode(Element element, int n) {
        Node node;
        String string = element.getAttribute("name");
        Element element2 = this.resultDocument.createElement(string);
        int n2 = Integer.parseInt(element.getAttribute("position"));
        int n3 = Integer.parseInt(element.getAttribute("storage-length"));
        boolean bl = "true".equalsIgnoreCase(element.getAttribute("numeric"));
        int n4 = 0;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element3;
            node = nodeList.item(i);
            if (node.getNodeType() != 1 || (element3 = (Element)node).getAttribute("level").equals("88")) continue;
            ++n4;
            if (element3.hasAttribute("occurs")) {
                int n5;
                int n6 = Integer.parseInt(element3.getAttribute("occurs"));
                int n7 = n5 = Integer.parseInt(element3.getAttribute("storage-length"));
                for (int j = 0; j < n6; ++j) {
                    element2.appendChild(this.convertNode(element3, n + j * n7));
                }
                continue;
            }
            element2.appendChild(this.convertNode(element3, n));
        }
        if (n4 == 0) {
            if (n > 0) {
                n2 += n;
            }
            String string2 = null;
            try {
                string2 = this.mainframeBuffer.substring(n2 - 1, n2 + n3 - 1);
                if (bl) {
                    string2 = string2.trim();
                }
            }
            catch (Exception exception) {
                System.err.println(exception);
                System.err.println("element = " + element.getAttribute("name"));
                System.err.println("position = " + n2);
                System.err.println("length = " + n3);
                System.err.println("Mainframe buffer length = " + this.mainframeBuffer.length());
            }
            node = this.resultDocument.createTextNode(string2);
            element2.appendChild(node);
        }
        return element2;
    }
}

