/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.jdbccommons.cobol;

import de.ubs.jdbcserver.jdbccomm.struct.AbstractItem;
import de.ubs.jdbcserver.jdbccomm.struct.Field;
import de.ubs.jdbcserver.jdbccomm.struct.Section;
import de.ubs.jdbcserver.jdbccomm.struct.TablespaceLayout;
import de.ubs.jdbcserver.jdbccommons.cobol.Condition;
import de.ubs.jdbcserver.jdbccommons.cobol.Copybook;
import de.ubs.jdbcserver.jdbccommons.cobol.Item;
import de.ubs.jdbcserver.jdbccommons.struct.MainframeDataTypes;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import net.sf.cb2xml.Cb2Xml2;
import net.sf.cb2xml.sablecc.lexer.LexerException;
import net.sf.cb2xml.sablecc.parser.ParserException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;

public class CobolParser {
    private String preprocess(String copybookContent) {
        if (copybookContent != null && !copybookContent.trim().isEmpty()) {
            String[] data = copybookContent.split("\n");
            LinkedList<String> outputList = new LinkedList<String>();
            for (String line : data) {
                if (line.trim().isEmpty()) continue;
                outputList.add(line);
            }
            if (!outputList.isEmpty()) {
                int i;
                int blankCount = 0;
                String str = (String)outputList.get(0);
                for (i = 0; i < str.length() && str.charAt(i) == ' '; ++i) {
                    ++blankCount;
                }
                for (i = 0; i < outputList.size(); ++i) {
                    outputList.set(i, StringUtils.repeat(" ", 6) + ((String)outputList.get(i)).substring(blankCount));
                }
            }
            return StringUtils.join(outputList, "\n");
        }
        return "";
    }

    public TablespaceLayout parse(InputStream in) throws ParserException, JAXBException, UnsupportedEncodingException, LexerException, IOException {
        return this.parse(in, Charset.defaultCharset().name(), true);
    }

    public TablespaceLayout parse(InputStream in, String charset, boolean reformat) throws ParserException, JAXBException, UnsupportedEncodingException, LexerException, IOException {
        return this.parse(StringUtils.join(IOUtils.readLines(in, charset), "\n"), reformat);
    }

    public TablespaceLayout parse(String content) throws ParserException, JAXBException, UnsupportedEncodingException, LexerException, IOException {
        return this.parse(content, true);
    }

    public TablespaceLayout parse(String content, boolean reformat) throws ParserException, JAXBException, UnsupportedEncodingException, LexerException, IOException {
        String reformatedCopyBook = reformat ? this.preprocess(content) : content;
        Logger.getLogger(CobolParser.class.getName()).log(Level.FINE, "Parse cobol copy book");
        Logger.getLogger(CobolParser.class.getName()).log(Level.FINEST, "{0}", reformatedCopyBook);
        JAXBContext jc = JAXBContext.newInstance(Condition.class, Copybook.class, Item.class);
        ByteArrayInputStream in = new ByteArrayInputStream(reformatedCopyBook.getBytes(Charset.defaultCharset()));
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        Document doc = Cb2Xml2.convertToXMLDOM(in, "test", false, 1);
        JAXBElement<Copybook> copybookElement = unmarshaller.unmarshal(doc, Copybook.class);
        return this.createRecordDescriptor(copybookElement.getValue());
    }

    private MainframeDataTypes determineType(Item item) {
        if (item.isNumeric() != null && item.isNumeric().booleanValue()) {
            String usage;
            String string = usage = item.getUsage() != null ? item.getUsage() : "display";
            if (usage.equals("binary") || usage.equals("computational") || usage.equals("computational-4") || usage.equals("computational-5")) {
                boolean signed = item.isSigned() != null && item.isSigned() != false;
                switch (item.getStorageLength()) {
                    case 2: {
                        return signed ? MainframeDataTypes.SHORT : MainframeDataTypes.UNSIGNED_SHORT;
                    }
                    case 4: {
                        return signed ? MainframeDataTypes.INTEGER : MainframeDataTypes.UNSIGNED_INTEGER;
                    }
                    case 8: {
                        return signed ? MainframeDataTypes.LONG : MainframeDataTypes.UNSIGNED_LONG;
                    }
                }
            } else {
                if (usage.equals("computational-1")) {
                    return MainframeDataTypes.FLOAT;
                }
                if (usage.equals("computational-2")) {
                    return MainframeDataTypes.DOUBLE;
                }
                if (usage.equals("computational-3") || usage.equals("packed-decimal")) {
                    return item.isSigned() != null && item.isSigned() != false ? MainframeDataTypes.PACKED_DECIMAL : MainframeDataTypes.UNSIGNED_PACKED_DECIMAL;
                }
                if (usage.equals("display")) {
                    if (item.getPicture().toUpperCase().contains("E")) {
                        return MainframeDataTypes.EXTERNAL_FLOAT;
                    }
                    return MainframeDataTypes.EXTERNAL_DECIMAL;
                }
                throw new RuntimeException("Unexpected type for field " + item.getName() + " type: " + item.getPicture());
            }
        }
        return MainframeDataTypes.STRING;
    }

    private void processItems(Section parent, List<Item> items) {
        HashSet<String> itemSetName = new HashSet<String>();
        for (Item item : items) {
            if (!itemSetName.add(item.getName())) {
                throw new RuntimeException("Item " + item.getName() + " is defined twice at the same level");
            }
            AbstractItem newItem = null;
            if (item.getItem().isEmpty()) {
                MainframeDataTypes rawType = this.determineType(item);
                String type = rawType.name();
                newItem = new Field(parent, item.getName().toUpperCase(), type, item.getStorageLength(), item.getDisplayLength(), item.getScale() != null ? item.getScale() : 0);
                Field field = (Field)newItem;
                field.setImpliedDecimalPoint(item.isInsertDecimalPoint() != null && item.isInsertDecimalPoint() != false);
                if (field.getType().equals(MainframeDataTypes.EXTERNAL_FLOAT.name())) {
                    String picture = item.getPicture();
                    int indexOfE = picture.indexOf("E");
                    char mantissaSign = picture.charAt(0);
                    char exponentSign = picture.charAt(indexOfE + 1);
                    field.setProperty("mantissa-sign", String.valueOf(mantissaSign));
                    field.setProperty("exponent-sign", String.valueOf(exponentSign));
                    if (field.getScale() < 4) {
                        throw new RuntimeException("Unexpected scale of " + field.getScale() + " for field " + field.getName());
                    }
                    field.setScale(field.getScale() - 4);
                }
            } else {
                newItem = new Section(parent, item.getName().toUpperCase());
                this.processItems((Section)newItem, item.getItem());
            }
            if (item.getOccurs() != null) {
                newItem.setMaximumOccurrences(item.getOccurs());
            }
            if (null != item.getDependingOn()) {
                newItem.setOccurrencesField(item.getDependingOn().toUpperCase());
            }
            parent.addItem(newItem);
            if (null == item.getRedefines()) continue;
            AbstractItem originalItem = parent.getItem(item.getRedefines());
            newItem.setPosition(originalItem.getPosition());
            newItem.setRedefine(item.getRedefines());
        }
    }

    private TablespaceLayout createRecordDescriptor(Copybook cb) {
        TablespaceLayout descriptor = new TablespaceLayout();
        this.processItems(descriptor.getStartSection(), cb.getItem());
        return descriptor;
    }
}

