/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.cursor;

import com.ibm.jzos.DfSort;
import com.ibm.jzos.ErrnoException;
import com.ibm.jzos.RcException;
import de.ubs.jdbcserver.cursor.AbstractCursor;
import de.ubs.jdbcserver.cursor.FileCursor;
import de.ubs.jdbcserver.cursor.FixedRecordInputStream;
import de.ubs.jdbcserver.cursor.RecordInputStream;
import de.ubs.jdbcserver.cursor.VariableRecordInputStream;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.TablespaceLayout;
import de.ubs.jdbcserver.jdbccommons.sql.parser.ParserUtils;
import de.ubs.jdbcserver.jdbccommons.sql.parser.SQLParserParser;
import de.ubs.jdbcserver.jdbccommons.sql.parser.StatementInformation;
import de.ubs.jdbcserver.sort.ExpressionOptimizer;
import de.ubs.jdbcserver.sort.SortUtils;
import de.ubs.jdbcserver.splitter.SimpleRecordSplitter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.misc.Interval;
import org.apache.commons.lang.StringUtils;

public class SortedCursor
extends AbstractCursor {
    protected final SimpleRecordSplitter splitter;
    protected final byte[] workingArea;
    private final DfSort dfSort = new DfSort();
    private final int lrecl;
    private final SQLParserParser.SelectStatementContext selectCtx;
    private final TablespaceLayout layout;
    private RecordInputStream sortin;
    private boolean variableRecordFormat = false;
    private long lastReadRecordNo = 0L;
    private StatementInformation statement;

    public SortedCursor(TablespaceLayout layout, TableDefinition tableDefinition, StatementInformation statement, int recordCount, int lrecl, boolean vb) throws IOException, SQLException {
        super(tableDefinition);
        char recordType;
        this.layout = layout;
        this.statement = statement;
        this.selectCtx = statement.getStatementInformation().selectStatement();
        this.lrecl = lrecl;
        this.splitter = new SimpleRecordSplitter(layout, tableDefinition);
        this.workingArea = new byte[this.lrecl];
        this.dfSort.addAllocation("alloc fi(sortin) da(" + layout.getFileName() + ") reuse shr msg(2)");
        if (!vb) {
            this.dfSort.setOutputStreamRecLen(lrecl);
            recordType = 'F';
        } else {
            this.dfSort.setOutputStreamHasRdws();
            this.variableRecordFormat = true;
            recordType = 'V';
        }
        this.dfSort.addControlStatement(String.format("OPTION FILSZ=E%d", recordCount));
        this.dfSort.addControlStatement("RECORD TYPE=" + recordType + ",LENGTH=(" + lrecl + ")");
        this.dfSort.setSameAddressSpace(true);
    }

    private SQLParserParser.DisjunctionContext buildDisjunctionWithTableCondition() throws IOException, SQLException {
        String filterExpression = null;
        if (this.getTableDefinition().getWhenCondition() != null && !this.getTableDefinition().getWhenCondition().isEmpty()) {
            filterExpression = this.getTableDefinition().getWhenCondition();
        }
        if (this.selectCtx.whereClause() != null) {
            SQLParserParser.DisjunctionContext disjunction = this.selectCtx.whereClause().disjunction();
            int a = disjunction.start.getStartIndex();
            int b = disjunction.stop.getStopIndex();
            Interval interval = new Interval(a, b);
            CharStream inputStream = this.selectCtx.getStart().getInputStream();
            String whereCondition = inputStream.getText(interval);
            filterExpression = filterExpression != null ? filterExpression + " AND " + whereCondition : whereCondition;
        }
        if (filterExpression != null) {
            return new ParserUtils().parseDisjuncation(filterExpression);
        }
        return null;
    }

    @Override
    public String getName() {
        return "Sorted cursor";
    }

    @Override
    public Object[] next() throws IOException, SQLException {
        int readBytes;
        if (this.maxRowsToFetch >= 0L && this.rowsReturnedToCaller >= this.maxRowsToFetch) {
            Logger.getLogger(FileCursor.class.getName()).log(Level.FINE, "SortedCursor returning no more rows because FETCH FIRST N ROWS ONLY has been reached");
            return null;
        }
        Object[] matchedRecord = null;
        do {
            readBytes = this.provideNextRecord();
            ++this.lastReadRecordNo;
            if (readBytes != -1) continue;
            return null;
        } while ((matchedRecord = this.matchesFilter(this.splitter.split(this.lastReadRecordNo, Arrays.copyOfRange(this.workingArea, 0, readBytes)))) == null);
        ++this.rowsReturnedToCaller;
        return matchedRecord;
    }

    private int provideNextRecord() throws IOException, SQLException, ErrnoException {
        int readBytes;
        if (this.sortin == null) {
            this.initializeDfsort();
        }
        if ((readBytes = this.sortin.readRecord(this.workingArea)) == -1) {
            try {
                int rc = this.dfSort.getReturnCode();
                if (rc != 0) {
                    throw new SQLException("Failed to sort data. RC = " + rc, "57011", -904);
                }
            }
            catch (RcException rce) {
                String str = StringUtils.join((Collection)this.dfSort.getStderrLines(), "\n");
                throw new SQLException("Failed to sort data: " + rce.getMessage() + "\n" + str, "57011", -904);
            }
            return -1;
        }
        return readBytes;
    }

    protected void initializeDfsort() throws ErrnoException, IOException, SQLException {
        if (this.getConditionEvaluator() != null) {
            ExpressionOptimizer optimizer = new ExpressionOptimizer(this.getTableDefinition(), this.splitter.getDataAccessors(), this.layout.getDefaultStringEncoding(), this.getConditionEvaluator().getVisitor().getParameterMarkerContents(), this.buildDisjunctionWithTableCondition());
            if (null == optimizer.getOptimizedDisjunction()) {
                super.updateFilter(null);
            } else {
                this.getConditionEvaluator().getVisitor().setParsedTree(optimizer.getOptimizedDisjunction());
            }
            Logger.getLogger(SortedCursor.class.getName()).log(Level.FINE, "DFSORT: {0} optimized expression: {1}", new Object[]{optimizer.getSortFilterExpression(), optimizer.getOptimizedExpression()});
            for (String cmd : SortUtils.buildIncludeCommand(optimizer)) {
                this.dfSort.addControlStatement(cmd);
            }
        }
        for (String cmd : SortUtils.buildSortCommand(this.getTableDefinition(), this.splitter.getDataAccessors(), this.statement, this.lrecl)) {
            this.dfSort.addControlStatement(cmd);
        }
        this.dfSort.execute();
        this.sortin = this.variableRecordFormat ? new VariableRecordInputStream(this.dfSort.getChildStdoutStream()) : new FixedRecordInputStream(this.dfSort.getChildStdoutStream());
    }

    @Override
    public void close() throws IOException {
        if (this.sortin != null) {
            this.sortin.close();
        }
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void update(Object[] data) throws IOException, SQLException {
        throw new SQLException("UPDATE is not allowed on a read only cursor", "42828", -510);
    }

    @Override
    public boolean delete() throws IOException, SQLException {
        throw new SQLException("DELETE is not allowed on a read only cursor", "42828", -510);
    }

    @Override
    public void insert(Object[] data) throws IOException, SQLException {
        throw new SQLException("INSERT is not allowed on a read only cursor", "42828", -510);
    }
}

