/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.command.file;

import com.ibm.jzos.AccessMethodServices;
import com.ibm.jzos.RcException;
import com.ibm.jzos.ZFile;
import de.ubs.jdbcserver.ScratchPadManager;
import de.ubs.jdbcserver.command.AbstractServerCommand;
import de.ubs.jdbcserver.command.UniqueConnectionIdentifier;
import de.ubs.jdbcserver.file.FileManager;
import de.ubs.jdbcserver.file.ProcessableFile;
import de.ubs.jdbcserver.jdbccomm.Constants;
import de.ubs.jdbcserver.jdbccomm.transport.Transportable;
import de.ubs.jdbcserver.jdbccomm.transport.TransportableFactory;
import de.ubs.jdbcserver.jdbccommons.FileType;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class FileCommand
extends AbstractServerCommand {
    public FileCommand(UniqueConnectionIdentifier connectionId, Document doc) {
        super(connectionId, doc);
    }

    private static ArrayList<byte[]> readRecord(ProcessableFile file, int recordCount) throws IOException, SQLException {
        int maximumRecordLength = file.getMaximumRecordLength();
        if (maximumRecordLength != -1) {
            byte[] data = new byte[maximumRecordLength];
            ArrayList<byte[]> readRecords = new ArrayList<byte[]>(recordCount);
            boolean eof = false;
            block0: for (int i = 0; i < recordCount && !eof; ++i) {
                boolean recordRead = false;
                while (!recordRead && !eof) {
                    int readByteCount = file.readRecord(data);
                    if (readByteCount == -1) {
                        eof = true;
                        continue;
                    }
                    byte[] readData = new byte[readByteCount];
                    System.arraycopy(data, 0, readData, 0, readByteCount);
                    readRecords.add(readData);
                    recordRead = true;
                    continue block0;
                }
            }
            return readRecords;
        }
        throw new RuntimeException("Non record based files are not supported yet");
    }

    @Override
    public Element execute() throws Exception {
        Element root = this.doc.getRootElement();
        String actionStr = root.getAttributeValue("action");
        Constants.FileAction action = Constants.FileAction.valueOf(actionStr);
        Logger.getLogger(FileCommand.class.getName()).log(Level.FINE, "Process action {0}", (Object)action);
        switch (action) {
            case IDCAMS: {
                return this.executeIdcams(root);
            }
            case CLOSE: {
                return this.closeFile(root);
            }
            case OPEN: {
                return this.openFile(root);
            }
            case READ: {
                return this.readRecord(root);
            }
            case WRITE: {
                return this.writeRecord(root);
            }
        }
        return null;
    }

    private Element readRecord(Element root) throws RuntimeException, NumberFormatException, IOException, SQLException {
        UUID fileUUID = this.getUUID(root);
        ProcessableFile file = FileManager.getDefault().get(fileUUID);
        int recordCount = Integer.parseInt(root.getAttributeValue("record-count", "1"));
        Element dataElement = new Element("data");
        ArrayList<byte[]> data = FileCommand.readRecord(file, recordCount);
        if (!data.isEmpty()) {
            Transportable t = this.getTransportable(fileUUID);
            String packedData = t.serialize(data);
            dataElement.setText(packedData);
        }
        if (data.size() < recordCount) {
            dataElement.setAttribute("eof", "true");
        }
        return dataElement;
    }

    protected Element openFile(Element root) throws IOException, SQLException {
        String path = root.getAttributeValue("path");
        String mode = root.getAttributeValue("mode");
        String typeStr = root.getAttributeValue("type");
        FileType type = FileType.valueOf(typeStr);
        ProcessableFile file = FileManager.getDefault().open(path, mode, type, null, null);
        Transportable transportable = this.registerTransportable(file, root);
        Logger.getLogger(FileCommand.class.getName()).log(Level.FINE, "Opened file {0} with mode {1}", new Object[]{path, mode});
        Logger.getLogger(FileCommand.class.getName()).log(Level.FINE, "Use {0} transport mechanism", transportable.getClass().getSimpleName());
        return new Element("file").setAttribute("file-id", file.getUUID().toString());
    }

    protected Element closeFile(Element root) {
        UUID fileUUID = this.getUUID(root);
        ProcessableFile file = FileManager.getDefault().close(fileUUID);
        int count = ScratchPadManager.getDefault().removeAll(this.connectionId, fileUUID);
        Logger.getLogger(FileCommand.class.getName()).log(Level.FINER, "Removed {0} open resources for file {1}", new Object[]{count, file.getName()});
        if (file != null) {
            Logger.getLogger(FileCommand.class.getName()).log(Level.FINE, "Closed file {0}", file.getName());
        } else {
            Logger.getLogger(FileCommand.class.getName()).log(Level.WARNING, "File with ID {0} not opened", fileUUID);
        }
        return new Element("file");
    }

    private Transportable registerTransportable(ProcessableFile file, Element e) {
        Transportable<ArrayList> t = TransportableFactory.createTransportable(e, ArrayList.class);
        ScratchPadManager.getDefault().put(this.connectionId, file.getUUID(), t);
        return t;
    }

    private Transportable getTransportable(UUID uuid) {
        return ScratchPadManager.getDefault().get(this.connectionId, uuid, Transportable.class);
    }

    private UUID getUUID(Element root) {
        String id = root.getAttributeValue("file-id");
        return UUID.fromString(id);
    }

    private Element executeIdcams(Element root) throws IOException {
        int rc = 0;
        String command = root.getText();
        String output = null;
        try {
            if (command.trim().toUpperCase().startsWith("ALLOC") || command.trim().toUpperCase().startsWith("FREE")) {
                Logger.getLogger(FileCommand.class.getName()).log(Level.FINE, "Execute BPXWDYN command: {0}", command);
                ZFile.bpxwdyn(command);
            } else {
                Logger.getLogger(FileCommand.class.getName()).log(Level.FINE, "Execute IDCAMS command: {0}", command);
                AccessMethodServices ams = new AccessMethodServices();
                for (String split : command.split("\n")) {
                    ams.addInputLine(split);
                }
                rc = ams.execute();
                output = ams.getOutputLines();
            }
        }
        catch (RcException ex) {
            Logger.getLogger(FileCommand.class.getName()).log(Level.INFO, "Unable to execute \"{0}\", RC = {1}, message = {2}", new Object[]{command, ex.getRc(), ex.getMessage()});
            throw new IOException(ex.getMessage());
        }
        Element result = new Element("result");
        result.setAttribute("rc", String.valueOf(rc));
        if (output != null) {
            LinkedList<String> lines = new LinkedList<String>();
            for (String split : output.split("\n")) {
                if ((split = split.trim()).isEmpty()) continue;
                lines.add(split);
            }
            output = StringUtils.join(lines, "\n");
            result.setText(output);
        }
        return result;
    }

    private Element writeRecord(Element root) throws IOException, SQLException {
        UUID fileUUID = this.getUUID(root);
        ProcessableFile file = FileManager.getDefault().get(fileUUID);
        Transportable t = this.getTransportable(fileUUID);
        ArrayList data = (ArrayList)t.deserialize(root.getText());
        file.writeRecord((byte[])data.get(0), ((byte[])data.get(0)).length);
        return new Element("result");
    }
}

