/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.accessor.mainframe;

import de.ubs.jdbcserver.accessor.AbstractDataAccessor;
import de.ubs.jdbcserver.jdbccomm.struct.Field;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.sql.SQLException;

public class TerminatedStringAccessor
extends AbstractDataAccessor<String> {
    private final int maxLength;
    private final Charset charset;
    private final CharsetEncoder encoder;
    private final byte terminationCharacter;

    public TerminatedStringAccessor(Field field, int position, byte terminationCharacter, Charset charset) {
        super(field, position);
        this.terminationCharacter = terminationCharacter;
        this.maxLength = field.getLength();
        this.charset = charset;
        this.encoder = charset.newEncoder();
        System.out.println("encoder.maxBytesPerChar() = " + this.encoder.maxBytesPerChar());
    }

    @Override
    public String get(byte[] input, int offset) throws SQLException {
        int length = 0;
        for (int i = 0; i < this.maxLength; ++i) {
            int relativeOffset = i + this.position + offset;
            if (this.terminationCharacter == input[relativeOffset]) {
                boolean eos = true;
                int j = 0;
                while ((float)j < this.encoder.maxBytesPerChar()) {
                    if (this.terminationCharacter != input[j + relativeOffset]) {
                        eos = false;
                    }
                    ++j;
                }
                if (eos) break;
            }
            ++length;
        }
        System.out.println("length = " + length);
        return new String(input, this.position + offset, length, this.charset);
    }

    @Override
    public void put(String data, byte[] output, int offset) throws SQLException {
        if (!this.encoder.canEncode(data)) {
            throw new SQLException(String.format("Character conversion cannot be performed because a string cannot be converted from %s to %s", Charset.forName("UTF-8").name(), this.charset.name()), "22021", -331);
        }
        byte[] bytes = data.getBytes(this.charset);
        System.arraycopy(bytes, 0, output, this.position + offset, this.maxLength);
        int i = 0;
        while ((float)i < this.encoder.maxBytesPerChar()) {
            output[this.position + offset + i + bytes.length] = this.terminationCharacter;
            ++i;
        }
    }
}

