/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields;

import com.ibm.jzos.fields.ByteArrayField;
import com.ibm.jzos.fields.ExternalDecimalAsBigDecimalField;
import com.ibm.jzos.fields.ExternalDecimalAsBigIntegerField;
import com.ibm.jzos.fields.ExternalDecimalAsIntField;
import com.ibm.jzos.fields.ExternalDecimalAsLongField;
import com.ibm.jzos.fields.Field;
import com.ibm.jzos.fields.StringField;
import java.util.Stack;

public abstract class DatatypeFactory {
    protected int offset = 0;
    protected int maximumOffset = 0;
    private Stack offsetStack = new Stack();
    protected String stringEncoding;
    protected boolean stringTrimDefault = false;

    public int getOffset() {
        return this.offset;
    }

    public int getMaximumOffset() {
        return this.maximumOffset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
        this.maximumOffset = Math.max(offset, this.maximumOffset);
    }

    public void pushOffset() {
        this.offsetStack.push(new Integer(this.offset));
    }

    public void popOffset() {
        this.offset = (Integer)this.offsetStack.pop();
    }

    public void incrementOffset(int amount) {
        this.setOffset(this.offset + amount);
    }

    protected void advanceOffset(Field field) {
        this.incrementOffset(field.getByteLength());
    }

    public String getStringEncoding() {
        return this.stringEncoding;
    }

    public boolean getStringTrimDefault() {
        return this.stringTrimDefault;
    }

    public void setStringTrimDefault(boolean value) {
        this.stringTrimDefault = value;
    }

    public void setStringEncoding(String stringEncoding) {
        this.stringEncoding = stringEncoding;
    }

    public ExternalDecimalAsBigDecimalField getExternalDecimalAsBigDecimalField(int precision, int scale, boolean signed) {
        return this.getExternalDecimalAsBigDecimalField(precision, scale, signed, true, false, false);
    }

    public ExternalDecimalAsBigDecimalField getExternalDecimalAsBigDecimalField(int precision, int scale, boolean signed, boolean signTrailing, boolean signExternal, boolean blankWhenZero) {
        ExternalDecimalAsBigDecimalField field = new ExternalDecimalAsBigDecimalField(this.offset, precision, scale, signed, signTrailing, signExternal, blankWhenZero);
        this.advanceOffset(field);
        return field;
    }

    public ExternalDecimalAsBigIntegerField getExternalDecimalAsBigIntegerField(int precision, boolean signed) {
        return this.getExternalDecimalAsBigIntegerField(precision, 0, signed, true, false, false);
    }

    public ExternalDecimalAsBigIntegerField getExternalDecimalAsBigIntegerField(int precision, int scale, boolean signed, boolean signTrailing, boolean signExternal, boolean blankWhenZero) {
        ExternalDecimalAsBigIntegerField field = new ExternalDecimalAsBigIntegerField(this.offset, precision, scale, signed, signTrailing, signExternal, blankWhenZero);
        this.advanceOffset(field);
        return field;
    }

    public ExternalDecimalAsIntField getExternalDecimalAsIntField(int precision, boolean signed) {
        return this.getExternalDecimalAsIntField(precision, signed, true, false, false);
    }

    public ExternalDecimalAsIntField getExternalDecimalAsIntField(int precision, boolean signed, boolean signTrailing, boolean signExternal, boolean blankWhenZero) {
        ExternalDecimalAsIntField field = new ExternalDecimalAsIntField(this.offset, precision, signed, signTrailing, signExternal, blankWhenZero);
        this.advanceOffset(field);
        return field;
    }

    public ExternalDecimalAsLongField getExternalDecimalAsLongField(int precision, boolean signed) {
        return this.getExternalDecimalAsLongField(precision, signed, true, false, false);
    }

    public ExternalDecimalAsLongField getExternalDecimalAsLongField(int precision, boolean signed, boolean signTrailing, boolean signExternal, boolean blankWhenZero) {
        ExternalDecimalAsLongField field = new ExternalDecimalAsLongField(this.offset, precision, signed, signTrailing, signExternal, blankWhenZero);
        this.advanceOffset(field);
        return field;
    }

    public ByteArrayField getByteArrayField(int length) {
        ByteArrayField field = new ByteArrayField(this.offset, length);
        this.advanceOffset(field);
        return field;
    }

    public StringField getStringField(int length) {
        StringField field = new StringField(this.offset, length, this.getStringTrimDefault());
        field.setEncoding(this.stringEncoding);
        this.advanceOffset(field);
        return field;
    }

    public StringField getStringField(int length, boolean trim) {
        StringField field = new StringField(this.offset, length, trim);
        field.setEncoding(this.stringEncoding);
        this.advanceOffset(field);
        return field;
    }

    public StringField getStringField(int length, boolean trim, boolean padLeft, boolean allowTruncation, String encoding) {
        StringField field = new StringField(this.offset, length, trim, padLeft, allowTruncation);
        field.setEncoding(encoding);
        this.advanceOffset(field);
        return field;
    }

    public StringField getStringField(int length, boolean trim, boolean padLeft, boolean allowTruncation) {
        StringField field = new StringField(this.offset, length, trim, padLeft, allowTruncation);
        field.setEncoding(this.stringEncoding);
        this.advanceOffset(field);
        return field;
    }

    public StringField getStringField(int length, boolean trim, boolean padLeft) {
        StringField field = new StringField(this.offset, length, trim, padLeft);
        field.setEncoding(this.stringEncoding);
        this.advanceOffset(field);
        return field;
    }
}

