/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields;

import com.ibm.jzos.fields.BinaryAsBigDecimalField;
import com.ibm.jzos.fields.BinaryAsBigIntegerField;
import com.ibm.jzos.fields.BinaryAsIntField;
import com.ibm.jzos.fields.BinaryAsLongField;
import com.ibm.jzos.fields.DatatypeFactory;
import com.ibm.jzos.fields.ExternalFloatField;
import com.ibm.jzos.fields.Field;
import com.ibm.jzos.fields.IbmDoubleField;
import com.ibm.jzos.fields.IbmFloatField;
import com.ibm.jzos.fields.PackedDecimalAsBigDecimalField;
import com.ibm.jzos.fields.PackedDecimalAsBigIntegerField;
import com.ibm.jzos.fields.PackedDecimalAsIntField;
import com.ibm.jzos.fields.PackedDecimalAsLongField;

public class CobolDatatypeFactory
extends DatatypeFactory {
    public BinaryAsLongField getBinaryAsLongField(int precision, boolean signed) {
        BinaryAsLongField field = new BinaryAsLongField(this.offset, this.getBinaryLength(precision), signed);
        this.advanceOffset(field);
        return field;
    }

    public BinaryAsIntField getBinaryAsIntField(int precision, boolean signed) {
        BinaryAsIntField field = new BinaryAsIntField(this.offset, this.getBinaryLength(precision), signed);
        this.advanceOffset(field);
        return field;
    }

    public BinaryAsBigDecimalField getBinaryAsBigDecimalField(int precision, int scale, boolean signed) {
        BinaryAsBigDecimalField field = new BinaryAsBigDecimalField(this.offset, precision, scale, signed);
        this.advanceOffset(field);
        return field;
    }

    public BinaryAsBigIntegerField getBinaryAsBigIntegerField(int precision, int scale, boolean signed) {
        BinaryAsBigIntegerField field = new BinaryAsBigIntegerField(this.offset, this.getBinaryLength(precision), scale, signed);
        this.advanceOffset(field);
        return field;
    }

    public Field getBinaryField(int precision, int scale, boolean signed, boolean comp5) {
        if (scale > 0) {
            return this.getBinaryAsBigDecimalField(precision, scale, signed);
        }
        if (scale < 0) {
            return this.getBinaryAsBigIntegerField(precision, scale, signed);
        }
        switch (this.getBinaryLength(precision) - scale) {
            case 2: {
                return this.getBinaryAsIntField(precision, signed);
            }
            case 4: {
                if (!signed && comp5) {
                    return this.getBinaryAsLongField(precision, signed);
                }
                return this.getBinaryAsIntField(precision, signed);
            }
        }
        if (!signed && comp5) {
            return this.getBinaryAsBigIntegerField(precision, 0, signed);
        }
        return this.getBinaryAsLongField(precision, signed);
    }

    public Field getExternalDecimalField(int precision, int scale, boolean signed, boolean signTailing, boolean signExternal, boolean blankWhenZero) {
        if (scale > 0) {
            return this.getExternalDecimalAsBigDecimalField(precision, scale, signed, signTailing, signExternal, blankWhenZero);
        }
        if (scale < 0) {
            return this.getExternalDecimalAsBigIntegerField(precision, scale, signed, signTailing, signExternal, blankWhenZero);
        }
        if (precision <= 9) {
            return this.getExternalDecimalAsIntField(precision, signed, signTailing, signExternal, blankWhenZero);
        }
        if (precision <= 18) {
            return this.getExternalDecimalAsLongField(precision, signed, signTailing, signExternal, blankWhenZero);
        }
        if (precision <= 31) {
            return this.getExternalDecimalAsBigIntegerField(precision, scale, signed, signTailing, signExternal, blankWhenZero);
        }
        throw new IllegalArgumentException("precision too big");
    }

    public ExternalFloatField getExternalFloatField(int precision, int scale, boolean showMantissaPlusSign, boolean showExponentPlusSign, boolean impliedDecimalPoint) {
        ExternalFloatField field = new ExternalFloatField(this.offset, precision, scale, showMantissaPlusSign, showExponentPlusSign, impliedDecimalPoint);
        this.advanceOffset(field);
        return field;
    }

    public Field getPackedDecimalField(int precision, int scale, boolean signed) {
        if (scale > 0) {
            return this.getPackedDecimalAsBigDecimalField(precision, scale, signed);
        }
        if (scale < 0) {
            return this.getPackedDecimalAsBigIntegerField(precision, scale, signed);
        }
        if (precision <= 9) {
            return this.getPackedDecimalAsIntField(precision, signed);
        }
        if (precision <= 18) {
            return this.getPackedDecimalAsLongField(precision, signed);
        }
        if (precision <= 31) {
            return this.getPackedDecimalAsBigIntegerField(precision, scale, signed);
        }
        throw new IllegalArgumentException("precision too big");
    }

    public PackedDecimalAsBigDecimalField getPackedDecimalAsBigDecimalField(int precision, int scale, boolean signed) {
        PackedDecimalAsBigDecimalField field = new PackedDecimalAsBigDecimalField(this.offset, precision, scale, signed);
        this.advanceOffset(field);
        return field;
    }

    public PackedDecimalAsBigIntegerField getPackedDecimalAsBigIntegerField(int precision, int scale, boolean signed) {
        PackedDecimalAsBigIntegerField field = new PackedDecimalAsBigIntegerField(this.offset, precision, scale, signed);
        this.advanceOffset(field);
        return field;
    }

    public PackedDecimalAsIntField getPackedDecimalAsIntField(int precision, boolean signed) {
        PackedDecimalAsIntField field = new PackedDecimalAsIntField(this.offset, precision, signed);
        this.advanceOffset(field);
        return field;
    }

    public PackedDecimalAsLongField getPackedDecimalAsLongField(int precision, boolean signed) {
        PackedDecimalAsLongField field = new PackedDecimalAsLongField(this.offset, precision, signed);
        this.advanceOffset(field);
        return field;
    }

    public IbmFloatField getIbmFloatField() {
        IbmFloatField field = new IbmFloatField(this.offset);
        this.advanceOffset(field);
        return field;
    }

    public IbmDoubleField getIbmDoubleField() {
        IbmDoubleField field = new IbmDoubleField(this.offset);
        this.advanceOffset(field);
        return field;
    }

    private int getBinaryLength(int precision) {
        int length;
        if (precision <= 4) {
            length = 2;
        } else if (precision <= 9) {
            length = 4;
        } else if (precision <= 18) {
            length = 8;
        } else {
            throw new IllegalArgumentException("precision too big for binary field");
        }
        return length;
    }
}

