/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.jdbccomm;

import de.ubs.jdbcserver.jdbccomm.transport.OptimizedXmlSerializer;
import de.ubs.jdbcserver.jdbccomm.util.CommonUtils;
import de.ubs.jdbcserver.jdbccomm.util.XmlUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class RemoteSession
implements Closeable {
    protected final String server;
    protected final int port;
    protected Socket socket;
    protected DataInputStream dataInputStream;
    protected DataOutputStream dataOutputStream;
    protected String databaseProductName = null;
    protected String databaseProductVersion = null;
    OptimizedXmlSerializer serializer = new OptimizedXmlSerializer();

    protected RemoteSession(String server, int port, String user, String password, boolean encrypted) throws Exception {
        this.server = server;
        this.port = port;
        SocketFactory factory = encrypted ? SSLSocketFactory.getDefault() : SocketFactory.getDefault();
        this.socket = factory.createSocket(server, port);
        this.dataOutputStream = new DataOutputStream(this.socket.getOutputStream());
        this.dataInputStream = new DataInputStream(this.socket.getInputStream());
        this.dataOutputStream.writeBytes("FILEBRIDGE_COMM_V_1_0_0");
        Element root = new Element("authenticate");
        root.setAttribute("user", user);
        root.setAttribute("password", password);
        Document doc = new Document(root);
        Element result = this.send(doc);
        if (result != null) {
            Attribute a = result.getAttribute("database-product-name");
            if (a != null) {
                this.databaseProductName = a.getValue();
            }
            if ((a = result.getAttribute("database-product-version")) != null) {
                this.databaseProductVersion = a.getValue();
            }
        }
    }

    public static RemoteSession connect(String server, int port, String user, String password, boolean encrypted) throws Exception {
        return new RemoteSession(server, port, user, password, encrypted);
    }

    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    public String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    @Override
    public void close() throws IOException {
        this.disconnect();
    }

    public final synchronized Element send(Element e) throws Exception {
        return this.send(new Document(e));
    }

    public final synchronized Element send(Document doc) throws Exception {
        block9: {
            byte[] bytes = this.serializer.serializeXml(doc);
            CommonUtils.writeUTF(this.dataOutputStream, bytes);
            byte[] replyXml = CommonUtils.read(this.dataInputStream);
            try {
                Document receivedDoc = this.serializer.deserializeXml(replyXml);
                Element root = receivedDoc.getRootElement();
                if (Logger.getLogger(RemoteSession.class.getName()).isLoggable(Level.FINEST)) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    new XMLOutputter(Format.getPrettyFormat()).output(root, (OutputStream)out);
                    Logger.getLogger(RemoteSession.class.getName()).log(Level.FINEST, out.toString(StandardCharsets.UTF_8.displayName()));
                }
                if (root.getName().equals("reply")) {
                    switch (CommonUtils.getStatus(root)) {
                        case OK: {
                            return root.getChildren().isEmpty() ? null : root.getChildren().get(0);
                        }
                        case INVALID: {
                            Logger.getLogger(RemoteSession.class.getName()).log(Level.SEVERE, "Invalid command received: {0}", doc.getRootElement().getName());
                            return null;
                        }
                        case EXCEPTION: {
                            throw XmlUtils.createException(root.getChild("exception"));
                        }
                    }
                    break block9;
                }
                throw new RuntimeException("The reply element " + root.getName() + " is unexpected");
            }
            catch (JDOMException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "send: ex", ex);
                throw new RuntimeException(ex);
            }
        }
        return null;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void disconnect() {
        if (this.dataInputStream != null) {
            try {
                this.dataInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.dataInputStream = null;
        }
        if (this.dataOutputStream != null) {
            try {
                this.dataOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.dataOutputStream = null;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
    }
}

