/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.jdbccomm.transport;

import de.ubs.jdbcserver.jdbccomm.transport.CompressTransportable;
import de.ubs.jdbcserver.jdbccomm.transport.SerializeTransportable;
import de.ubs.jdbcserver.jdbccomm.transport.SimpleTransportable;
import de.ubs.jdbcserver.jdbccomm.transport.Transportable;
import java.io.IOException;
import java.io.Serializable;
import org.jdom2.Element;

public class TransportableFactory {
    public static <T extends Serializable> Transportable<T> createTransportable(TransportType type, Class<T> clazz) {
        switch (type) {
            case SIMPLE: {
                return new SimpleTransportable();
            }
            case COMPRESS: {
                return new CompressTransportable();
            }
            case SERIAL: {
                try {
                    return new SerializeTransportable();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        throw new AssertionError((Object)("Unknown transport type: " + (Object)((Object)type)));
    }

    public static <T extends Serializable> Transportable<T> createTransportable(Element e, Class<T> clazz) {
        String value = e.getAttributeValue("transportable");
        return TransportableFactory.createTransportable(value != null ? TransportType.valueOf(value) : TransportType.SIMPLE, clazz);
    }

    public static enum TransportType {
        SIMPLE,
        COMPRESS,
        SERIAL;

    }
}

