/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.jdbccomm.transport;

import de.ubs.jdbcserver.jdbccomm.transport.Transportable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.SerializationUtils;

public class CompressTransportable<T extends Serializable>
implements Transportable<T> {
    private ByteArrayOutputStream byteArrayOutputStream;

    @Override
    public String serialize(T data) throws IOException {
        if (this.byteArrayOutputStream == null) {
            this.byteArrayOutputStream = new ByteArrayOutputStream();
        }
        GZIPOutputStream zipOutputStream = new GZIPOutputStream(this.byteArrayOutputStream);
        byte[] byteData = SerializationUtils.serialize(data);
        zipOutputStream.write(byteData);
        zipOutputStream.finish();
        byte[] compressedData = this.byteArrayOutputStream.toByteArray();
        String encodeBase64String = Base64.encodeBase64String(compressedData);
        this.byteArrayOutputStream.reset();
        if (Logger.getLogger(CompressTransportable.class.getName()).isLoggable(Level.FINEST)) {
            Logger.getLogger(CompressTransportable.class.getName()).log(Level.FINEST, "Compressed {0} kb to {1} kb. Compression rate is {2} %", new Object[]{(double)byteData.length / 1024.0, (double)compressedData.length / 1024.0, 100.0 - (double)compressedData.length * 100.0 / (double)byteData.length});
        }
        return encodeBase64String;
    }

    @Override
    public T deserialize(String data) throws IOException {
        byte[] byteData = Base64.decodeBase64(data);
        GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(byteData));
        return (T)((Serializable)SerializationUtils.deserialize(in));
    }
}

