/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.driver;

import de.ubs.jdbcserver.driver.UBSConnection;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UBSDriver
implements Driver {
    public static final int MAJOR_VERSION = 1;
    private static final String PROP_USER = "user";
    private static final String PROP_PASSWORD = "password";
    private static final Pattern URL_PATTERN = Pattern.compile("^jdbc:ubs://([^:]+):(\\d+)");
    private static int buildDate = -1;

    public UBSDriver() throws SQLException {
        DriverManager.registerDriver(this);
    }

    public static int getDriverBuildDate() {
        if (buildDate == -1) {
            buildDate = 0;
            InputStream versionResource = UBSDriver.class.getResourceAsStream("/filebridge-driver-version.properties");
            if (versionResource != null) {
                try {
                    Properties properties = new Properties();
                    properties.load(versionResource);
                    String buildTime = properties.getProperty("build.time");
                    if (buildTime != null) {
                        buildDate = Integer.parseInt(buildTime);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return buildDate;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        Matcher matcher = URL_PATTERN.matcher(url);
        if (matcher.find()) {
            String host = matcher.group(1);
            int port = Integer.parseInt(matcher.group(2));
            String user = info.getProperty(PROP_USER);
            String password = info.getProperty(PROP_PASSWORD);
            HashMap<String, String> properties = new HashMap<String, String>();
            StringTokenizer st = new StringTokenizer(url, ";");
            st.nextToken();
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int pos = token.indexOf("=");
                String name = token.substring(0, pos);
                String value = token.substring(pos + 1);
                properties.put(name, value);
            }
            Logger.getLogger(UBSDriver.class.getName()).log(Level.FINE, "Connect to {0}:{1} with user {2}", new Object[]{host, port, user});
            properties.put("host", host);
            properties.put(PROP_USER, user);
            properties.put(PROP_PASSWORD, password);
            properties.put("port", String.valueOf(port));
            return new UBSConnection(url, properties);
        }
        return null;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return URL_PATTERN.matcher(url).find();
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return UBSDriver.getDriverBuildDate();
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return Logger.getLogger(UBSDriver.class.getName()).getParent();
    }
}

