/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.jdbccommons.sql.parser;

import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccommons.sql.parser.ColumnInformation;
import de.ubs.jdbcserver.jdbccommons.sql.parser.SQLParserParser;
import de.ubs.jdbcserver.jdbccommons.struct.CatalogManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class StatementInformation {
    private final List<ColumnInformation> referencedColumnList = new ArrayList<ColumnInformation>();
    private String tableSchema;
    private String tableName;
    private String label;
    private SQLParserParser.StatementContext statementInformation;
    private TableDefinition table;

    public List<ColumnInformation> getReferencedColumnList() {
        return this.referencedColumnList;
    }

    public TableDefinition getTable() throws SQLException {
        if (this.table == null) {
            this.table = CatalogManager.getDefault().getTableDefinition(this.getTableSchema(), this.getTableName());
        }
        return this.table;
    }

    public int indexOf(String columnName) {
        for (int i = 0; i < this.referencedColumnList.size(); ++i) {
            if (!this.referencedColumnList.get(i).getName().equals(columnName)) continue;
            return i;
        }
        return -1;
    }

    public long getMaxRowsToFetch() {
        if (this.statementInformation.selectStatement() != null && this.statementInformation.selectStatement().fetchClause() != null) {
            SQLParserParser.FetchClauseContext fcc = this.statementInformation.selectStatement().fetchClause();
            if (fcc.number() == null) {
                return 1L;
            }
            return Long.valueOf(fcc.number().getText());
        }
        return -1L;
    }

    public SQLParserParser.DisjunctionContext getWhereCondition() {
        if (this.statementInformation.selectStatement() != null && this.statementInformation.selectStatement().whereClause() != null) {
            return this.statementInformation.selectStatement().whereClause().disjunction();
        }
        return null;
    }

    public SQLParserParser.StatementContext getStatementInformation() {
        return this.statementInformation;
    }

    public void setStatementInformation(SQLParserParser.StatementContext statementInformation) {
        this.statementInformation = statementInformation;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableSchema() {
        return this.tableSchema;
    }

    public void setTableSchema(String tableSchema) {
        this.tableSchema = tableSchema;
    }
}

