/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.index;

import de.ubs.jdbcserver.accessor.DataAccessor;
import de.ubs.jdbcserver.command.sql.ParameterValueData;
import de.ubs.jdbcserver.evaluation.EvaluationVisitor;
import de.ubs.jdbcserver.index.ByteBuffer;
import de.ubs.jdbcserver.index.IndexUtils;
import de.ubs.jdbcserver.jdbccomm.struct.ColumnDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.Field;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccomm.util.ComparableByteArray;
import de.ubs.jdbcserver.jdbccomm.util.Pair;
import de.ubs.jdbcserver.jdbccommons.sql.parser.SQLParserBaseVisitor;
import de.ubs.jdbcserver.jdbccommons.sql.parser.SQLParserParser;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;

class IndexQueryByteBuilderVisitor
extends SQLParserBaseVisitor<Pair<Boolean, List<ByteBuffer>>> {
    private static final Pattern DATE_PATTERN = Pattern.compile("[0-9]{4}\\-[0-9]{2}\\-[0-9]{2}");
    private static final Pattern TIME_PATTERN = Pattern.compile("[0-9]{2}\\-[0-9]{2}\\-[0-9]{2}");
    private static final Pattern TIMESTAMP_PATTERN = Pattern.compile("[0-9]{4}\\-[0-9]{2}\\-[0-9]{2}\\-[0-9]{2}\\-[0-9]{2}\\-[0-9]{2}\\-([0-9]{1,3}\\-)?");
    private final FastDateFormat TIMESTAMP_PARSER = FastDateFormat.getInstance("yyyy-MM-dd-HH:mm:ss.SSS");
    private final FastDateFormat TIME_PARSER = FastDateFormat.getInstance("HH:mm:ss");
    private final FastDateFormat DATE_PARSER = FastDateFormat.getInstance("yyyy-MM-dd");
    private final DataAccessor[] dataAccessors;
    private final TableDefinition tableDefinition;
    private final int sizeOfBuffer;
    private int keyOffset = 0;
    private ByteBuffer currentByteBuffer;
    private ParameterValueData parameterMarkerContents;

    public IndexQueryByteBuilderVisitor(TableDefinition tabeDefinition, DataAccessor[] dataAccessors, ParameterValueData parameterMarkerContents) {
        this.dataAccessors = dataAccessors;
        this.tableDefinition = tabeDefinition;
        int calculatedSizeOfBuffer = 0;
        for (ColumnDefinition column : tabeDefinition.getColumns()) {
            if (column.getKeySequence() != -1) {
                calculatedSizeOfBuffer += dataAccessors[this.tableDefinition.indexOfColumn(column.getName())].getField().getDisplayLength();
            }
            if (column.getKeySequence() != 1) continue;
            this.keyOffset = dataAccessors[this.tableDefinition.indexOfColumn(column.getName())].getPosition();
        }
        this.sizeOfBuffer = calculatedSizeOfBuffer;
        this.parameterMarkerContents = parameterMarkerContents;
    }

    public int getKeyOffset() {
        return this.keyOffset;
    }

    @Override
    public Pair<Boolean, List<ByteBuffer>> visitDisjunction(SQLParserParser.DisjunctionContext ctx) {
        LinkedList<ByteBuffer> cummulatedResult = new LinkedList<ByteBuffer>();
        if (ctx != null) {
            for (ParseTree parseTree : ctx.children) {
                this.currentByteBuffer = null;
                Pair subResult = (Pair)super.visit(parseTree);
                if (subResult == null) continue;
                if (((Boolean)subResult.first()).booleanValue()) {
                    for (ByteBuffer byteBuffer : (List)subResult.second()) {
                        cummulatedResult.add(byteBuffer);
                    }
                    continue;
                }
                return new Pair<Boolean, Object>(false, null);
            }
            return new Pair<Boolean, List<ByteBuffer>>(true, cummulatedResult);
        }
        return new Pair<Boolean, Object>(false, null);
    }

    @Override
    public Pair<Boolean, List<ByteBuffer>> visitConjunction(SQLParserParser.ConjunctionContext ctx) {
        if (this.currentByteBuffer == null) {
            this.currentByteBuffer = new ByteBuffer(this.sizeOfBuffer);
        }
        return (Pair)super.visitConjunction(ctx);
    }

    @Override
    public Pair<Boolean, List<ByteBuffer>> visitColumn(SQLParserParser.ColumnContext ctx) {
        return new Pair<Boolean, Object>(true, null);
    }

    @Override
    public Pair<Boolean, List<ByteBuffer>> visitOperator(SQLParserParser.OperatorContext ctx) {
        if (null != ctx.OP_EQUALS()) {
            return new Pair<Boolean, Object>(true, null);
        }
        return new Pair<Boolean, Object>(false, null);
    }

    @Override
    public Pair<Boolean, List<ByteBuffer>> visitConstant(SQLParserParser.ConstantContext ctx) {
        if (ctx.StringLiteral() != null) {
            return new Pair<Boolean, Object>(true, null);
        }
        if (ctx.number() != null) {
            return new Pair<Boolean, Object>(true, null);
        }
        return new Pair<Boolean, Object>(false, null);
    }

    @Override
    public Pair<Boolean, List<ByteBuffer>> visitParameterMarker(SQLParserParser.ParameterMarkerContext ctx) {
        if (this.parameterMarkerContents == null) {
            throw new RuntimeException("No parameter values provided");
        }
        return new Pair<Boolean, Object>(true, null);
    }

    @Override
    public Pair<Boolean, List<ByteBuffer>> visitEquation(SQLParserParser.EquationContext ctx) {
        if (ctx.operator() != null) {
            Field f;
            SQLParserParser.SumContext columnCtx = null;
            SQLParserParser.SumContext constantCtx = null;
            if (this.isColumn(ctx.sum(0))) {
                columnCtx = ctx.sum(0);
            } else if (this.isColumn(ctx.sum(1))) {
                columnCtx = ctx.sum(1);
            }
            if (this.isConstant(ctx.sum(0))) {
                constantCtx = ctx.sum(0);
            } else if (this.isConstant(ctx.sum(1))) {
                constantCtx = ctx.sum(1);
            }
            if (columnCtx == null || constantCtx == null) {
                return new Pair<Boolean, Object>(false, null);
            }
            Pair columnValue = (Pair)this.visitSum(columnCtx);
            Pair constantValue = (Pair)this.visitSum(constantCtx);
            Object op = this.visitOperator(ctx.operator());
            if (((Boolean)columnValue.first()).booleanValue() && ((Boolean)constantValue.first()).booleanValue() && ((Boolean)((Pair)op).first()).booleanValue() && (f = this.getField(columnCtx)) != null) {
                String columnName = columnCtx.product().atom().column().identifier().value;
                ColumnDefinition columnDefinition = this.tableDefinition.getColumnDefinition(columnName);
                int indexOfColumn = this.tableDefinition.indexOfColumn(columnName);
                if (this.currentByteBuffer == null) {
                    this.currentByteBuffer = new ByteBuffer(this.sizeOfBuffer);
                }
                if (columnDefinition.getKeySequence() != -1) {
                    try {
                        Object value = null;
                        if (constantCtx.product().atom().constant() != null) {
                            value = this.buildType(constantCtx.product().atom().constant());
                        } else if (constantCtx.product().atom().parameterMarker() != null) {
                            int parameterMarkerIndex = constantCtx.product().atom().parameterMarker().no;
                            value = this.parameterMarkerContents.getLatestValues()[parameterMarkerIndex];
                        } else {
                            return new Pair<Boolean, Object>(false, null);
                        }
                        this.dataAccessors[indexOfColumn].put(value, this.currentByteBuffer.getBuffer(), -this.keyOffset);
                        for (int i = this.dataAccessors[indexOfColumn].getPosition() - this.keyOffset; i < this.dataAccessors[indexOfColumn].getPosition() - this.keyOffset + this.dataAccessors[indexOfColumn].getField().getLength(); ++i) {
                            this.currentByteBuffer.getMarkerBuffer()[i] = -1;
                        }
                    }
                    catch (SQLException ex) {
                        Logger.getLogger(IndexUtils.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                return new Pair<Boolean, List<ByteBuffer>>(true, Collections.singletonList(this.currentByteBuffer));
            }
        }
        return new Pair<Boolean, Object>(false, null);
    }

    private Field getField(SQLParserParser.SumContext ctx) {
        String columnName = ctx.product().atom().column().identifier().value;
        int indexOfColumn = this.tableDefinition.indexOfColumn(columnName);
        if (indexOfColumn != -1) {
            return this.dataAccessors[indexOfColumn].getField();
        }
        return null;
    }

    private boolean isColumn(SQLParserParser.SumContext ctx) {
        return ctx != null && ctx.product() != null && ctx.product().atom() != null && ctx.product().atom().column() != null;
    }

    private boolean isConstant(SQLParserParser.SumContext ctx) {
        if (ctx != null && ctx.product() != null && ctx.product().atom() != null) {
            SQLParserParser.AtomContext atom = ctx.product().atom();
            if (atom.constant() != null) {
                SQLParserParser.ConstantContext x = atom.constant();
                return x.StringLiteral() != null || x.number() != null;
            }
            if (atom.parameterMarker() != null) {
                return true;
            }
        }
        return false;
    }

    private Object buildType(SQLParserParser.ConstantContext ctx) {
        if (ctx.NULL() != null) {
            return null;
        }
        if (ctx.StringLiteral() != null) {
            String str = ((String)((Object)ctx.value)).replaceAll("''", "'");
            try {
                if (TIMESTAMP_PATTERN.matcher(str).matches()) {
                    return new Timestamp(this.TIMESTAMP_PARSER.parse(str).getTime());
                }
                if (DATE_PATTERN.matcher(str).matches()) {
                    return new Timestamp(this.DATE_PARSER.parse(str).getTime());
                }
                if (TIME_PATTERN.matcher(str).matches()) {
                    return new Timestamp(this.TIME_PARSER.parse(str).getTime());
                }
            }
            catch (ParseException e) {
                Logger.getLogger(EvaluationVisitor.class.getName()).log(Level.SEVERE, "Failed to parse timestamp {0}", str);
            }
            return StringUtils.stripEnd(str, " ");
        }
        if (ctx.BinaryLiteral() != null) {
            String binRepresentation = (String)((Object)ctx.value);
            return new BigDecimal(Long.parseLong(binRepresentation, 2));
        }
        if (ctx.HexLiteral() != null) {
            String hexRepresentation = (String)((Object)ctx.value);
            try {
                byte[] ret = Hex.decodeHex(hexRepresentation.toCharArray());
                return new ComparableByteArray(ret);
            }
            catch (DecoderException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (ctx.number() != null) {
            return new BigDecimal(ctx.getText());
        }
        throw new RuntimeException("No viable alternative for constant");
    }
}

