/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.accessor.mainframe;

import com.ibm.jzos.fields.PackedDecimalAsBigDecimalField;
import de.ubs.jdbcserver.accessor.AbstractDataAccessor;
import de.ubs.jdbcserver.jdbccomm.struct.Field;
import java.math.BigDecimal;
import java.sql.SQLException;

public class PackedDecimalAccessor
extends AbstractDataAccessor<BigDecimal> {
    private final PackedDecimalAsBigDecimalField internal;

    public PackedDecimalAccessor(int position, Field item, boolean signed) {
        super(item, position);
        this.internal = new PackedDecimalAsBigDecimalField(position, item.getDisplayLength(), item.getScale(), true);
    }

    @Override
    public BigDecimal get(byte[] input, int offset) throws SQLException {
        try {
            return this.internal.getBigDecimal(input, offset);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().contains("packed field contains invalid sign")) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public void put(BigDecimal data, byte[] output, int offset) throws SQLException {
        if (data != null) {
            this.internal.putBigDecimal(data, output, offset);
        }
    }
}

